function [flag,Params] = checkMaskAndAtlas(atlasPath,Params)

flag = 1;
Pub = Params.PublicParams;
Priv = Params.PrivateParams;
try
    if Params.PublicParams.useTemplate
        maskPath = atlasPath;
        %    atlasPath = Pub.atlasPath;
        %    maskPath = Pub.atlasPath;
        
        [dn,fn] = fileparts(Priv.brainMask);
        dat = [maskPath fn];
        
        if strcmp(Pub.fileFormat,'nii')
            if ~strcmp(dat,'nii')
                ext = '.nii';
            else
                ext = '';
            end
            D = load_nii([dat ext]);
        else
            D = load(dat);
        end
        Priv.brainMask = dat;        
    else        
        %  Pub.maskPath = maskPath;
        atype = [{'cort'};{'sub'};{'cort'};{'sub'};{'cort'};{'sub'}];
        Pub.atlasPath = atlasPath;
        Priv.atlasTh = [0 0 25 25 50 50];
        Priv.voxelSize = 2;
        %    disp('OK!')
        for k = 1:length(atype)
            Priv.brainAtlases{k} = [atlasPath 'HarvardOxford-'...
                atype{k} '-maxprob-thr' num2str(Priv.atlasTh(k)) ...
                '-' num2str(Priv.voxelSize) 'mm.nii'];
            at = load_nii([Priv.brainAtlases{k}]);
            at = at.img;
        end
    end    
catch
    flag = 0;
    disp(lasterr)
end

Params.PublicParams = Pub;
Params.PrivateParams = Priv;
