function [dataStd, dataVar, partData] = ISCJackKnife(path)
% Usage: [dataStd, dataVar, partData] = ISCJackKnife(memMapMatpath)
% 
% The function computes the Jackknife estimates of mean correlation of the
% analysis results. To use the function the full correaltion matrixes must
% have been saved during the analysis. 
%
% memMapMatpath is the absolute path to the memMaps.mat file
% dataStd is the Std map (size of the original volume) 
% dataVar is the var map (size of the original volume)
% partData has the jackknife means for each leave one out correlation mean 
%
% Juha Pajula 11.9.2014

load(path)
%get the correlation matrixes
fullData = memMaps.cormatMap.whole.band0.Session1.cor.Data.xyzc;
%get the number of subjects
nrSubj = length(fieldnames(memMaps.origMap.Session1));
%generate the template of matrix

%Check the size
koko=size(fullData);
partData = zeros([koko(1:3),nrSubj]);
for k = 1:nrSubj
    disp(['leaving out subject nr. ' num2str(k)])
    proto = ones(nrSubj); %all subjects selected
    proto(k,:) = 0; %removing subject k from selection vertical
    proto(:,k) = 0; %removing subject k from selection horisontal
    proto = proto(triu(ones(nrSubj),1)==1); %selecting the upper triangular matrix
    loc = find(proto==1); % get the indexes for the correlations
    partData(:,:,:,k) = mean(squeeze(fullData(:,:,:,loc)),4);
    %generate an binary index for each correlation missing one subject,
    %select the upper triangle from the binary index and create indexes for
    %that.
    
    %use the created index to select all correlations once
    
    %average the matrix and save the result
    
    %repeat the process with all subjects missing from the index (jacknife)
    
    
    
end

dataVar = var(partData,0,4);
dataVar(isnan(dataVar))=0;

dataStd = std(partData,0,4);
dataStd(isnan(dataStd))=0;