/* Jukka-Pekka Kauppi $  $Date: 2011/01/08 18:00:20 $ */

#include "mex.h"
#include <math.h>
#include <string.h>

/* Compute shared nearest neighbors (SNNs) and SNN "densities" */
void  compSNN(double *x,int numPoints,int numNeighbors,double *d)
{
    
    int i,j,m,Val1,Val2,p,q;
    double *X1,*X2,*X0,*D1,*D2,*D0,*Dens1,*Dens2;
    
    D0 = d;
    D1 = d;
    D2 = d;
    X0 = x;
    X1 = x;
    X2 = x;
    Val1 = 0;
    Val2 = 0;
    Dens1 = x;
    Dens2 = x;
    
    for (i = 0; i < numPoints; i++ ) {
        for (j = 0; j < numNeighbors; j++, X1++, D1++) {
            Dens1 = X0 + i*numNeighbors;
            Val1 = (int)*X1;
            X2 = X0 + (Val1-1)*numNeighbors;
            D2 = D0 + (Val1-1)*numNeighbors;
            if ( i+1 < Val1 ) {
                for ( m = 0; m < numNeighbors; m++, X2++, D2++ ) {
                    Val2 = (int)*X2;
                    if ( Val2 == i+1 ) { /* found SNN */
                        *D1 = 1;
                        *D2 = 1;   
                        /* compute SNN density values: */
                        for ( p = 0; p < numNeighbors; p++, Dens1++ ) {
                            Dens2 = X0 + (Val1-1)*numNeighbors;
                            for ( q = 0; q < numNeighbors; q++, Dens2++ ) {
                                if (*Dens1 == *Dens2) {
                                    *D1 = *D1 + 1;
                                    *D2 = *D2 + 1;
                                    break;
                                }
                                
                            }
                        }
                        break;
                    }
                    
                }

                
            }
            
        }
        
    }
    
    
}


/* the gateway function */
void mexFunction( int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    
    int numNeighbors,numPoints;
    
    if (nrhs<1) {
        mexErrMsgIdAndTxt("computeSNN.c:TooFewInputs",
        "One input argument required.");
    } else if (nrhs>1) {
        mexErrMsgIdAndTxt("computeSNN.c:TooManyInputs",
        "One input argument required.");
    } else if(nlhs>1) {
        mexErrMsgIdAndTxt("computeSNN.c:TooManyOutputs",
        "Too many output arguments.");
    }
    
    if (mxIsDouble(prhs[0])) {
        double *x,*d;
        
        x = mxGetPr(prhs[0]);        
        numPoints = mxGetN(prhs[0]);
        numNeighbors = mxGetM(prhs[0]);
        plhs[0] = mxCreateDoubleMatrix(numNeighbors,numPoints, mxREAL);
        d = mxGetPr(plhs[0]);
        
        /* compute SNN: */
        compSNN(x,numPoints,numNeighbors,d);
        
    } else {
        mexErrMsgIdAndTxt("computeSNN.c:BadInputType",
        "computeSNN.c only supports real DOUBLE data.");
    }
    
}

