function [bestMu,idx,GMM] = estimateGMM(features,Centroids,covoption,...
    regul_option,resultPath,k,featureSet,overwrite_GMM)

% set program internal parameters:
maxIterGMM = 2000;
maxIterKM = 2000;
runKmeansBeforeGMM = 1;

Ce = size(Centroids,1);

% run K-means based on obtained initial cluster centers:
V = version;

% run GMM-based on K-means solution:
fn3 = ([resultPath '/GMM_k' num2str(k) '_featureSet' num2str(featureSet) 'regul_option' num2str(regul_option) 'covoption' num2str(covoption) '.mat']);
if ( exist(fn3) == 2 ) && ( overwrite_GMM == 0 )
    disp('Existing GMM-struct found, loading...')
    load(fn3,'GMM') % load SNN clustering results
    bestMu = GMM.mu;
    idx = GMM.idx;
else
    
    disp('Run K-means starting from the SNN initial solution...')
    if runKmeansBeforeGMM
        %[idx_kmeans2,centroids_kmeans2] = kmeans(features,[],'Start',Centroids,'EmptyAction','drop','MaxIter',maxIterKM,'OnlinePhase','off','Display','Final');
        [centroids_kmeans,costfunctionvalue,idx_kmeans,inter] = kmeansj(features,size(Centroids,1),Centroids,maxIterKM);
    else
        [centroids_kmeans,costfunctionvalue,idx_kmeans,inter] = kmeansj(features,size(Centroids,1),Centroids,1);        
    end
    if covoption == 0 % full covariance matrices
        Sigmas = zeros(size(centroids_kmeans,2),size(centroids_kmeans,2),...
            size(centroids_kmeans,1)); % d by d by k
    else % diagonal covariance matrices
        Sigmas = zeros(1,size(centroids_kmeans,2),...
            size(centroids_kmeans,1)); % 1 by d by k
    end
    
    p = zeros(1,size(centroids_kmeans,1));
    for m = 1:size(centroids_kmeans,1)
        if covoption == 0
            Sigmas(:,:,m) = cov(features(idx_kmeans==m,:));
        else
            Sigmas(1,:,m) = var(features(idx_kmeans==m,:),[],1);
        end
        p(m) = sum(idx_kmeans==m)/size(features,1);
    end
    
    %initVal.mu = Centroids;
    initVal.mu = centroids_kmeans;
    initVal.Sigma = Sigmas;
    initVal.PComponents = p;
    
    Opt = statset;
    Opt.Display = 'iter';
    Opt.MaxIter = maxIterGMM;
    if covoption == 0
        cv = 'full';
        disp('Estimating GMM with full covariance matrices.')
    else
        disp('Estimating GMM with diagonal covariance matrices.')
        cv = 'diagonal';
    end
    
    disp('Estimate the final GMM using the EM algorithm...')
    if regul_option
        disp('Note: GMM uses regularization if needed.')
    end    
    try
        %gm = gmdistribution.fit(features,size(initVal.mu,1),'Start',initVal,...
        %     'CovType',cv,'Regularize', regVal, 'Options',Opt);
        
        [mu,sigma,prob,idx] = emclustering3(features,size(initVal.mu,1),...
            maxIterGMM,initVal.mu',initVal.Sigma,initVal.PComponents,covoption);
        GMM.Sigmas = sigma;
        GMM.mu = mu';
        GMM.PComponents = prob;
        GMM.idx = idx;
        % get final cluster indices:
        %idx2 = cluster(gm,features);
        %GMM2.Sigmas = gm.Sigma;
        %GMM2.mu = gm.mu;
        %GMM2.PComponents = gm.PComponents;
        %GMM2.idx = idx2;
        disp('Saving GMM-struct...')
        if strcmp(V(1),'7')
            save(fn3,'GMM')
        else
            save(fn3,'GMM','-v7.3')
        end
        bestMu = GMM.mu;
    catch
        warning('GMM estimation failed, returning solution of the previous step as cluster centroids!')
        GMM.Sigmas = initVal.Sigma;
        GMM.mu = initVal.mu;
        GMM.PComponents = initVal.PComponents;
        GMM.idx = idx_kmeans;
        bestMu = centroids_kmeans;
        idx = idx_kmeans;
        disp('Saving GMM-struct...')
        if strcmp(V(1),'7')
            save(fn3,'GMM')
        else
            save(fn3,'GMM','-v7.3')
        end
    end
end
fprintf(1,'\n');
