function X = generateJackKnifeEstimates(Params)
% computing Jackknife estimates and generating variables for FuSeISC clustering
% This script requires ISCJackKnife.m function from ISCtoolbox svn repository:
% https://isc-toolbox.googlecode.com/svn/trunk/FuSe/ISCJackKnife.m
% Juha Pajula 30.10.2014

%path = '/home/pajula2/results/FuSe/ICBManalysis/ICBM_FuSe_Analysis.mat';
%mapPath = '/home/pajula2/results/FuSe/ICBManalysis/memMaps.mat';

Priv = Params.PrivateParams;
Pub = Params.PublicParams;
NrSess = size(Pub.subjectSource,1);
% load memory maps:
load([Pub.dataDestination 'memMaps'])

%compute Jackknife std estimates for each clip
clipStd = cell(1,Params.PrivateParams.nrSessions);
for k = 1:NrSess
    disp(['Processing Session ' num2str(k)])
    [clipStd{k},~,~] = ISCJackKnife(memMaps.cormatMap.whole.band0.([ ...
        Priv.prefixSession num2str(k)]).cor.Data.xyzc, Priv.nrSubjects);
    %nii = make_nii(clipStd, size(clipStd) ,[],[],'ISC Std');
    %save_nii(nii,[path_3mm{k} 'stdmap.nii']);
end

% Load binary map of the ISC analysis
if strcmp(Pub.fileFormat,'nii')
    bmask = load_nii(Priv.brainMask);
    bmask = single(bmask.img);
elseif strcmp(Pub.fileFormat,'mat')
    bmask = load(Priv.brainMask);
    fiel = fields(bmask);
    bmask = bmask.(fiel{1});
    bmask = single(bmask);
else
    error('Mask must be mat- or nii-file!')
end
bmask = logical(bmask);

%find the common brain voxels
brain_voxels = find(bmask == 1);

%std estimates
stdC=cell(1,NrSess);

%mean ISC values
imgC = cell(1,NrSess);

%get the mean ISC and std estimates for each voxel
for k = 1:NrSess
    temp = clipStd{k};
    stdC{k} = temp(brain_voxels);
      
    img = memMaps.resultMap.whole.band0.([ ...
        Priv.prefixSession num2str(k)]).cor.Data.xyz;
    imgC{k} = img(brain_voxels);
    imgC{k}(isnan(imgC{k})) = 0;
    stdC{k}(isnan(stdC{k})) = 0;

    %quality check should newer come:
    if(sum(isnan(imgC{k}))~=0 || sum(isnan(stdC{k}))~=0)
        error(['Features contains NaN values! Set: ' num2str(k)]);
    end

end


%Generate X dimensional features for each voxel:
% X = 2*NrSess
X = zeros(2*NrSess,length(stdC{1}));
for k = 1:NrSess
    X(k*2-1,:) = double(stdC{k}); %voxel vice std estimates from each clip
    X(k*2,:) = double(imgC{k}); %voxel vice mean ISC of each clip
end
X = X'; %transpose
%save for ISCtoolbox results folder should come to here


function [dataStd, dataVar, partData] = ISCJackKnife(fullData,nrSubj)
% Usage: [dataStd, dataVar, partData] = ISCJackKnife(memMapMatpath)
% 
% The function computes the Jackknife estimates of mean correlation of the
% analysis results. To use the function the full correaltion matrixes must
% have been saved during the analysis. 
%
% memMapMatpath is the absolute path to the memMaps.mat file
% dataStd is the Std map (size of the original volume) 
% dataVar is the var map (size of the original volume)
% partData has the jackknife means for each leave one out correlation mean 
%
% Juha Pajula 11.9.2014

%load(path)
%get the correlation matrixes
%fullData = memMaps.cormatMap.whole.band0.Session1.cor.Data.xyzc;
%get the number of subjects
%nrSubj = length(fieldnames(memMaps.origMap.Session1));
%generate the template of matrix

%Check the size
koko=size(fullData);
partData = zeros([koko(1:3),nrSubj]);
for k = 1:nrSubj
    disp(['leaving out subject nr. ' num2str(k)])
    proto = ones(nrSubj); %all subjects selected
    proto(k,:) = 0; %removing subject k from selection vertical
    proto(:,k) = 0; %removing subject k from selection horisontal
    proto = proto(triu(ones(nrSubj),1)==1); %selecting the upper triangular matrix
    loc = proto==1; % get the indexes for the correlations
    partData(:,:,:,k) = mean(squeeze(fullData(:,:,:,loc)),4);
    %generate an binary index for each correlation missing one subject,
    %select the upper triangle from the binary index and create indexes for
    %that.
    
    %use the created index to select all correlations once
    
    %average the matrix and save the result
    
    %repeat the process with all subjects missing from the index (jacknife)
    
    
    
end

dataVar = var(partData,0,4);
dataVar(isnan(dataVar))=0;

dataStd = std(partData,0,4);
dataStd(isnan(dataStd))=0;
