function [colM,DiceVals,clust_ind] = match_colors(colM,clust_ind1,clust_ind2,subclust1,subclust2)

subclust1 = subclust1(clust_ind1);
subclust2 = subclust2(clust_ind2);

D = NaN*zeros(length(subclust1),length(subclust2));
for m = 1:length(subclust1)
    for p = 1:length(subclust2)
        subclust_m_inds = [];
        for mm = 1:length(subclust1{m})
            subclust_m_inds = [subclust_m_inds; subclust1{m}{mm}];
        end
        subclust_p_inds = [];
        for pp = 1:length(subclust2{p})
            subclust_p_inds = [subclust_p_inds; subclust2{p}{pp}];
        end
        D(m,p) = 2*length(intersect(subclust_m_inds,subclust_p_inds))/(length(subclust_m_inds) + length(subclust_p_inds));         
    end
end

% transform into dissimilarity matrix:
c2 = (D-max(D(:)))*-1;

[a1,b1] = assignmentoptimal(c2');

aa = [1:length(a1) ; a1'];
for mm = 1:size(aa,2)
   vals(mm) = D(aa(2,mm),aa(1,mm));
end

V = NaN*zeros(1,length(clust_ind1));
C = clust_ind1(aa(2,:));
for nn = 1:size(aa,2)
    V(find(clust_ind1 == C(nn))) = vals(nn);
end
    
cc3 = clust_ind1(aa(2,:))';
fi = [];
for mm = 1:length(cc3)
    fi = [fi find(clust_ind1 == cc3(mm) )];
end
colM = colM(fi,:);


clear VV
for m = 1:length(V)
    VV{m} = num2str(round(V(m)*100)/100);
    if length(VV{m}) == 3 && ~strcmp(VV{m}(1),'N')
        VV{m} = [VV{m} '0'];
    end
end
DiceVals = VV;       
