function PearsonFilonAcrossSessions(Params,bandNr,sessBlock)
% This function calculates subject-pairwise-ZPF-statistics for paired
% Session comparison and standardized subject-pairwise-ISC-statistics for unpaired
% session comparison.

% See also: RUNANALYSIS, INITPARAMS

% Last modified: 10.2.2017

showTime(1);
doDebug = 0; % This is to prevent problems with the correlation overflows. 
             % It forces the correlation values to be smaller than 1 (in absolute value)
             % It also prints a message urging to check the data.
             % However, this probably slows down the code a bit and these problems have been rare 
             % so this feature can be turned off
epsilon1 = 0.99999999;
epsilon0 = 0.0000001;
dispDebugLim = 5; % this limits the number of debug messages
dispDebug = 0;

Pub = Params.PublicParams;
Priv = Params.PrivateParams;

if Pub.sessionCompOn == 0
    disp('Sum ZPF map computation across sessions not selected...')
    return
end

if ~Pub.corOn
    disp('Correlation coefficient needs to be selected in order to compute sum ZPF maps...')
    return
end

if ~Pub.calcStandard
    disp('Correlation coefficient needs to be selected in order to compute sum ZPF maps...')
    return
end

for xx = 1:Priv.nrSessions
    za(xx) = Priv.dataSize(xx,4);
end
if length(unique(za)) ~= 1
    disp('Each session must have same number of data points in order to compute sum ZPF maps across sessions...')
    return
end

if Priv.nrSessions < 2
    disp('Only one session specified, sumZPF across sessions cannot be computed...')
    return
end

elementWise = 0; % should have the same value in permutationPFAcrossSessions
fullSubjectWise = 0;
limSubjectWise = 0;

if ~Pub.pairedSessionComp  % if paired session comparison; no alternatives w.r.t. permutation type
    if Pub.permutationType == 1 
         elementWise = 1;
    end
	if Pub.permutationType == 2 
         limSubjectWise = 1;
    end
	if Pub.permutationType == 3 
        fullSubjectWise = 1;  % note that this implies heavy memory consumption
    end
end
   
% total number of subject pairs:
nrSubjPairs = ((Priv.nrSubjects)^2-(Priv.nrSubjects))/2;
% total number of session pairs:
nrSesComp = ((Priv.nrSessions)^2-(Priv.nrSessions))/2;

if nargin < 3
    sessBlock = 1:nrSesComp;
end

% load pointers:
load([Pub.dataDestination 'memMaps'])

for h = 1:Priv.nrSessions
    % fMRI-data (source data):
    if bandNr > 0
        mMap.(['sess' num2str(h)]) = memMaps.(Priv.filtMapName).([Priv.prefixSession num2str(h)]);
    else
        mMap.(['sess' num2str(h)]) = memMaps.(Priv.origMapName).([Priv.prefixSession num2str(h)]);
    end
end

% pearson-filon-data (destination data):
%mMapResultWhole = memMaps.(Priv.PFMapSessionName).whole.([Priv.prefixFreqBand num2str(bandNr)]).cor;
mMapmatResultWhole = memMaps.(Priv.PFmatMapSessionName).whole.([Priv.prefixFreqBand num2str(bandNr)]).cor;
clear memMaps

for fr = 1:length(sessBlock)
    %    if ( mMapResultWhole.([Priv.prefixSessComp num2str(sessBlock(fr))]).Writable == false ) || ...
    %            ( mMapmatResultWhole.([Priv.prefixSessComp num2str(sessBlock(fr))]).Writable == false )
    if ( mMapmatResultWhole.([Priv.prefixSessComp num2str(sessBlock(fr))]).Writable == false )
        disp('Session comparison map already computed...')
        save([Pub.dataDestination '/tmp/rerun'],'sessBlock')
        return
    end
end

sessBandTable = createSessBandTable( sessBlock,Priv.nrSessions );

%sessBandTable

if Pub.pairedSessionComp
    if any(Priv.dummies(:) > 0)
        error('In the paired comparison, the numbers of subjects in the groups must be all equal');
    end
    VAL = zeros(1,nrSubjPairs);
else
    % this is for computing the true number of subjects in each group
    % true subjects are coded with zeros in Priv.dummies 
    % if Priv.dummies(ses,i) == 1 it means that the subject i of the
    % group ses is a copy of the first subject created because 
    % groups have distinct numbers of subjects.
    % dummies assumed to be last entries in the group
    trueNrSubjects = zeros(Priv.nrSessions,1);
    for ses = 1:Priv.nrSessions
        trueNrSubjects(ses) = sum(Priv.dummies(ses,:) == 0);
    end
    if elementWise 
        VAL = zeros(1,2*nrSubjPairs);	% includes also zero correlations if there are dummies 
	elseif  limSubjectWise	
	    VAL = zeros(1,2*nrSubjPairs );  								   
	else
        VAL = zeros(1,2*nrSubjPairs + Priv.nrSubjects*Priv.nrSubjects);
    end		
end		

maskfileformat = Pub.fileFormat;
if strcmp(maskfileformat(end-2:end),'nii') || strcmp(maskfileformat,'nii.gz')
    bmask = load_nii(Priv.brainMask);
    bmask = single(bmask.img);
elseif strcmp(maskfileformat(end-2:end),'mat') || strcmp(maskfileformat,'mat')
    bmask = load(Priv.brainMask);
    fiel = fields(bmask);
    bmask = bmask.(fiel{1});
    bmask = single(bmask);
else
    error('Mask must be mat- or nii-file!')
end
bmask = logical(bmask);

INDS = find(triu(ones(Priv.nrSubjects,Priv.nrSubjects),1));

% significance thresholds for pairwise ZPF-statistic:
Th(1) = 1.96;
Th(2) = 2.807;
Th(3) = 3.2905;

% In each spatial x-location, we save time-series to the variable
% cDat(a,b,c,d,e), where:
% a = length of the time-series
% b = spatial y-dimension
% c = spatial z-dimension
% d = number of sessions
% e = number of subjects.
% For instance, if there are 12 subjects, 3 sessions, and 91x109x91x244
% fMRI data, size(cData) = [244 109 91 3 12].
iter = 0;
r1ind = [ 2     3     4     5     7     8     9    10    12    13    14    15]; 
% this for doDebug; it picks non-diagonal entries of the 4 x 4 correlation matrix
for xx = 1:Priv.dataSize(1,1)
    disp(['x: ' num2str(xx) '/' num2str(Priv.dataSize(1,1))])
    % init result matrix for across session data
    % process only non-zero x-slices:
    if sum(sum(squeeze(bmask(xx,:,:)))) > 0
        % init source time-series matrix:
        cDat = zeros([Priv.dataSize(1,[4 2 3]),Priv.nrSessions, Priv.nrSubjects]);
        % read multi-band time-series of the subjects:
        for f = 1:Priv.nrSessions
            if ~isempty(find(sessBandTable(1:2,:)==f))
                %   disp(['load band: ' num2str(f)])
                for k = 1:Priv.nrSubjects
                    if bandNr == 0
                        cDat(:,:,:,f,k) = mMap.(['sess' num2str(f)]).([Priv.prefixSubject num2str(k)]).Data(xx).tyz; % time*y*z*sessions*subjects
                    else
                        cDat(:,:,:,f,k) = mMap.(['sess' num2str(f)]).([Priv.prefixSubjectFilt num2str(k)]).([Priv.prefixFreqBand num2str(bandNr)]).Data(xx).tyz;
                    end
                end
            end
        end
        
        n1 = size(cDat,1);
        N = Priv.dataSize(1,4); % number of time points
		denom = N - 1;
        for yy = 1:Priv.dataSize(1,2)
			if Pub.pairedSessionComp
                Z2 = zeros([Priv.dataSize(1,3),length(sessBlock),nrSubjPairs]);
            else
                if limSubjectWise | elementWise
			        Z2 = zeros([Priv.dataSize(1,3),length(sessBlock),2*nrSubjPairs]);
                else % fullSubjectWise
                    Z2 = zeros([Priv.dataSize(1,3),length(sessBlock),2*nrSubjPairs + Priv.nrSubjects*Priv.nrSubjects]);
                end    
			end
            ziter = 0;
            for zz = 1:Priv.dataSize(1,3)
                if bmask(xx,yy,zz)
                    ziter = ziter + 1;
                    ts = squeeze(cDat(:,yy,zz,:,:)); % time*sessions*subjects
                    
					ts = bsxfun(@minus,ts,sum(ts)/N);  % de-meaning here (JT)
					tsvar = sum(abs(ts).^2) ./ denom;  %  compute time-wise variance
                    tsvar = tsvar + (tsvar == 0); % make sure that no division by zeros
					ts = bsxfun(@rdivide,ts,sqrt(tsvar));
                    % select time-series from different sessions:
                    for sessInd = 1:length(sessBlock)
                        % take time-series from session g and h:
                        g = sessBandTable(1,sessInd);
                        h = sessBandTable(2,sessInd);
                        ts_v1 = squeeze(ts(:,g,:)); % time*subjects, session g
                        ts_v2 = squeeze(ts(:,h,:)); % time*subjects, session h
                        
                        % select subject pairs:
                        subjpairInd = 0;
                        if Pub.pairedSessionComp
                            for m = 1:Priv.nrSubjects
                                for n = 1:Priv.nrSubjects
                                    if n > m
                                        subjpairInd = subjpairInd + 1;
                                        xc = [ts_v1(:,m) ts_v1(:,n) ts_v2(:,m) ts_v2(:,n)];
                                        % speeded up by JT
                                        % calculate 4 by 4 correlation matrix (ref: Matlab corrcoef.m):
                                       % [n1,m1] = size(T); % to speed up (JT)
                                      %  xc = T - repmat(sum(T)/n1,n1,1);  % Remove mean, de-meaned already 
                                        r1 = (xc' * xc) / denom; % calculate inner products
                                       % d1 = sqrt(diag(c1)); % sqrt first to avoid under/overflow
                                       % dd = d1*d1';
                                       % dd(1:4+1:end) = diag(c1); % remove roundoff on diag
                                       % r1 = c1 ./ dd;
                                        if doDebug
                                            if max(abs(r1(r1ind))) > epsilon1
                                                % print some information
                                                if dispDebug < dispDebugLim
                                                    disp([ 'Correlation overflow: Check the data of subjs' num2str(n) 'and' num2str(m) 'at the voxel' num2str(xx) ',' num2str(yy) ',' num2str(zz) '.']);
                                                    dispDebug = dispDebug + 1;
                                                end
                                                % and correct the problem 
                                                tidx = find(abs(r1) > epsilon1); 
                                                r1(tidx) = r1(tidx)./(abs(r1(tidx)) + epsilon0);
                                                r1(1:5:end) = sign(diag(r1));
                                            end
                                        end
                                       
                                        % calculate Fisher's z-transform:
                                        z12 = 0.5*(log((1+r1(1,2))./(1-r1(1,2))));
                                        z34 = 0.5*(log((1+r1(3,4))./(1-r1(3,4))));									
									
                                        % calculate Z-statistic (Pearson-Filon based on Fisher's z-transformation):
                                        Q = 0.5*( ...
                                            ( r1(1,3)-r1(3,2)*r1(1,2) ) * ( r1(4,2)-r1(3,2)*r1(3,4) ) + ...
                                            ( r1(1,4)-r1(1,3)*r1(3,4) ) * ( r1(2,3)-r1(1,3)*r1(1,2) ) + ...
                                            ( r1(1,3)-r1(1,4)*r1(3,4) ) * ( r1(2,4)-r1(1,4)*r1(1,2) ) + ...
                                            ( r1(1,4)-r1(1,2)*r1(2,4) ) * ( r1(2,3)-r1(2,4)*r1(3,4) ) );
                                        Q2 = (1-r1(1,2)^2)*(1-r1(3,4)^2);
                                        if doDebug & (Q > Q2) & (Q > 0) % this check is added to remove possible overflow problems 070816 JT  
                                            VAL(subjpairInd) = 0;
                                        else
                                            VAL(subjpairInd) = ( (z12-z34)*sqrt((N-3)/2) ) / ...
                                            sqrt( 1 - Q / ( Q2 ) );
                                        end
                                    end
                                end
                            end
									% disp('Success')	
                        else
                            for m = 1:trueNrSubjects(g)
                                for n = 1:trueNrSubjects(g)
                                    if n > m
                                        subjpairInd = subjpairInd + 1;  % this could easily be vectorized
                                        r1 = ts_v1(:,m)'*ts_v1(:,n)/denom;
                                        if doDebug
                                            if(abs(r1) > epsilon1)
                                               if dispDebug < dispDebugLim
                                                    disp([ 'Correlation overflow: Check the data of subjs' num2str(n) 'and' num2str(m) 'at the voxel' num2str(xx) ',' num2str(yy) ',' num2str(zz) '.']);
                                                    dispDebug = dispDebug + 1;
                                               end
                                               % disp([ 'Correlation overflow: Check the data of subjs' num2str(n) 'and' num2str(m) 'at the voxel' num2str(xx) ',' num2str(yy) ',' num2str(zz) '.']);
                                               r1 = r1/(abs(r1) + epsilon0);
                                            end
                                        end
                                        z12 = 0.5*(log((1+r1)./(1-r1)));
                                        VAL(subjpairInd) =  z12*sqrt((N-3)); % removed /2 JT 14.3.2017
                                    end
                                end
                            end
                            subjpairInd = 0;
                            for m = 1:trueNrSubjects(h)
                                for n = 1:trueNrSubjects(h)
                                    if n > m
                                        subjpairInd = subjpairInd + 1;
                                        r1 = ts_v2(:,m)'*ts_v2(:,n)/denom;
                                        if doDebug
                                            if(abs(r1) > epsilon1)
                                               if dispDebug < dispDebugLim
                                                    disp([ 'Correlation overflow: Check the data of subjs' num2str(n) 'and' num2str(m) 'at the voxel' num2str(xx) ',' num2str(yy) ',' num2str(zz) '.']);
                                                    dispDebug = dispDebug + 1;
                                               end
                                               % disp([ 'Correlation overflow: Check the data of subjs' num2str(n) 'and' num2str(m) 'at the voxel' num2str(xx) ',' num2str(yy) ',' num2str(zz) '.']);
                                               r1 = r1/(abs(r1) + epsilon0);
                                            end
                                        end
                                        z34 = 0.5*(log((1+r1)./(1-r1)));
                                        % VAL(subjpairInd) =
                                        % z12*sqrt((N-3)/2); 020816 JT this line needs to be commented
                                        % otherwise VAL will be filled with
                                        % wrong values
                                        VAL(subjpairInd + nrSubjPairs) = -z34*sqrt((N-3)); % minus sign   % removed /2 JT 14.3.2017
                                      
										                                                    % to unify the analysis
                                    end
                                end
                            end
                           
                            % for subject-wise permutations we need to compute the lower-right part of the full
                            % correlation matrix  
                            subjpairInd = 2*nrSubjPairs; % corrected 020816 JT
                            if fullSubjectWise 
                                for m = 1:trueNrSubjects(g)
                                    for n = 1:trueNrSubjects(h)
                                        subjpairInd = subjpairInd + 1;
                                        % xc = [ts_v1(:,m) ts_v2(:,n)];

                                        % calculate 2 by 2 correlation matrix (ref: Matlab corrcoef.m):
                                          % Remove mean
                                        % r1 = (xc' * xc) / denom; % calculate inner products
                                        r1 = ts_v1(:,m)'*ts_v2(:,n)/denom;
                                        if doDebug
                                            if(abs(r1) > epsilon1)
                                                if dispDebug < dispDebugLim
                                                    disp([ 'Correlation overflow: Check the data of subjs' num2str(n) 'and' num2str(m) 'at the voxel' num2str(xx) ',' num2str(yy) ',' num2str(zz) '.']);
                                                    dispDebug = dispDebug + 1;
                                                end
                                               % disp([ 'Correlation overflow: Check the data of subjs' num2str(n) 'and' num2str(m) 'at the voxel' num2str(xx) ',' num2str(yy) ',' num2str(zz) '.']);
                                               r1 = r1/(abs(r1) + epsilon0);
                                            end
                                        end
                                        % calculate Fisher's z-transform:
                                        % z12 = 0.5*(log((1+r1(1,2))./(1-r1(1,2))));
                                        z12 = 0.5*(log((1+r1)./(1-r1)));
                                        VAL(subjpairInd) =  z12*sqrt((N-3)); % removed /2 JT 14.3.2017
                                    end
                                end
                            end
                        end
  						fi = find(isnan(VAL));
                        if ~isempty(fi)
                            VAL(fi) = 0;
                           % warning(['NaN-values found for subject pair(s) ' num2str(fi) ' in session comparison sum ZPF statistic, replaced with zero.'])                            
                        end
                        fi = find(imag(VAL)~=0);
                        if ~isreal(VAL)
                            VAL(fi) = 0;
                           % warning(['Complex-values found for subject pair(s) ' num2str(fi) ' in session comparison sum ZPF statistic, replaced with zero.'])                            
                        end
                        VAL = real(VAL);
                        Z2(zz,sessInd,:) = VAL;                        
                        % note that Z2 is organized (in case of not-equal
                        % sized groups) as follows
                        % first: correlations within the first group
                        % (there're trueNrSubjects(g)*(trueNrSubjects(g) -
                        % 1) of these), then zeros until nrSubjPairs
                        % then correlation within the second group, and
                        % then zeros, and then between group correlations.
                        % For example, in the case of three groups of sizes
                        % 2, 3, and 4, Z2 between the groups 1 and 2 are as
                        % [r11(1) 0 0 0 0 0 0 r22(1) r22(2) r22(3) 0 0 0 r12(1), ..., r12(6) 0 0 0 0 0 0 0 0 0 0]                                                                                                
                    end
                end
            end % end z
            for fr = 1:length(sessBlock)
                %                mMapResultWhole.([Priv.prefixSessComp num2str(sessBlock(fr))...
                %                    ]).Data.xyzc(xx,yy,:,:) = single(squeeze(Z1(:,fr,:)));
                
                mMapmatResultWhole.([Priv.prefixSessComp num2str(sessBlock(fr))...
                    ]).Data.xyzc(xx,yy,:,:) = single(squeeze(Z2(:,fr,:)));
                
            end
        end
        
    end % end y
end % end x

% Set data non-writable:
%load([Pub.dataDestination 'memMaps'])
%for fr = 1:length(sessBlock)
%    memMaps.(Priv.PFmatMapSessionName).whole.([Priv.prefixFreqBand num2str(bandNr)]).cor.([Priv.prefixSessComp num2str(sessBlock(fr))]).Writable = false;
%end
%save([Pub.dataDestination 'memMaps'],'memMaps')
%clear memMaps
save([Pub.dataDestination '/tmp/' num2str(bandNr) '_memMaps'],'sessBlock')


showTime(0);
