function Params = initParams(atlasPath,destinationPath)
% This function initializes parameters for intersubject 
% synchronization analysis. User must specify all fields in 
% PublicParams before performing the analysis (see runAnalysis.m).
%
% inputs:
% atlasPath - directory containing templates and  mask
% destinationPath - directory where analysis results will be stored

% Example usage:
% Set fields in runInit and initParams and then call:
% runInit;Params = initParams;
%
% See also: RUNANALYSIS

% Last updated: 5.8.2013 by Jukka-Pekka Kauppi
% University of Helsinki
% Department of Computer Science
% e-mail: jukka-pekka.kauppi@helsinki.fi

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PUBLIC PARAMETERS
% These parameters must be set correctly before running the analysis.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%
% General settings:


% description/tag of the project:
PublicParams.dataDescription = 'Test';

if nargin < 2
    c = cd;
    sl = getSlash;
    c = [c sl];
    path0 = cd;
    path1 = [c 'templates' sl];
    PublicParams.atlasPath = path1;
    if nargin < 1
        path2 = [c 'results' sl];
        PublicParams.dataDestination = path2;
    else
        PublicParam.dataDestination = destinationPath;
    end
end
    if nargin == 2
        PublicParams.atlasPath = atlasPath;
        PublicParams.dataDestination = destinationPath;
    end
    if nargin > 2
        error('Number of inputs must be less than three!')
    end

% Next, set source data file names for subjectSource -field. Full path 
% names must be given inside curly brackets (cell-format), where rows 
% present subjects and columns sessions,
% e.g (2 subjects and 2 scanning sessions):
%  PublicParams.subjectSource = 
%  [ {/fullpathname/subj1_ses1.nii}, {/fullpathname/subj2_ses1.nii}; 
%    {/fullpathname/subj1_ses2.nii}, {/fullpathname/subj2_ses2.nii} ]

PublicParams.subjectSource{1,1}  = 'C:\datasets\fMRI_4D_subject1.mat';
PublicParams.subjectSource{1,2}  = 'C:\datasets\fMRI_4D_subject2.mat';    
PublicParams.subjectSource{1,3}  = 'C:\datasets\fMRI_4D_subject3.mat';    

% set subject source file format either to 'mat' or 'nii':
PublicParams.fileFormatSubj = '';

%%%%%%%%%%%%%%%%%%
% Settings regarding inter-subject synchronization:

% Select intersubject similarity criteria that are calculated:
PublicParams.ssiOn = 0; % sign-similarity index
PublicParams.nmiOn = 0; % mutual information based index
PublicParams.corOn = 1; % Pearson's correlation based index (recommended!)
PublicParams.kenOn = 0; % Kendall's W based index

% Determine parts of the analysis that will be performed:
PublicParams.calcStandard = 1; % standard analysis
PublicParams.calcStats = 0; % median, quartile, t and variance ISC maps
PublicParams.calcCorMatrices = 0; % save full correlation matrices
PublicParams.calcPhase = 0;

% use MNI template (FSL nifti)
PublicParams.useTemplate = 1;

PublicParams.permutSessionComp = 25000;
PublicParams.sessionCompOn = 0;
PublicParams.clusterThreshold = 0; % set to 0 if the cluster based correction is not desired 
PublicParams.clusterCorrType = 1; % 1 cluster extent correction (the only one implemented at the moment)
                                  % 2 cluster mass correction
								  % 3 TFCE correction (not implemented yet)
PublicParams.pairedSessionComp = 1; % Is the comparison paired or not?
PublicParams.permutationType = 3;   % The type of the permutation test for group comparison
                                    % 1 elementWise
                                    % 2 limited Subject wise (dummy correlations ignored)
                                    % 3 full Subject wise comparison Chen et al. NeuroImage 2016

PublicParams.studentize = 0; % Perform or don't perform studentization for group contrast maps
PublicParams.globalCorrCorrection = 0;
PublicParams.GSR = 0;

% FuSe
PublicParams.FuSeOn = 0;            % functional segmentation enabled
PublicParams.FuSe_K = 275;          % value for K
PublicParams.FuSe_minK = 50;        % min value for K when testing multiple k values
PublicParams.FuSe_stepK = 10;       % step for K when testing multiple k values
PublicParams.FuSe_maxK = 275;       % max value for K when testing multiple k values
PublicParams.FuSe_Diag = false;     % use diagonal matrices
PublicParams.FuSe_mask = false;     % use fuse Mask
PublicParams.FuSeMaskPath = 'defaultmask.mat'; % changed 27.3.2017, JPK
PublicParams.FuSe_FSet = 2;         % Fset 1,2,3?
PublicParams.FuSe_reg_opt = true;	% use regularisation
PublicParams.FuSe_multiK = false;   % test multiple K values          
PublicParams.FuSe_remove_temp = false;      % remove fuse temporary files after analysis
%%%%%%%%%%%%%%%%%%
% Frequency settings:

% set data sampling frequency:
% No default here, TR must be always set by to avoid problems!
PublicParams.samplingFrequency = NaN; 
% Set number of frequency subbands:
PublicParams.nrFreqBands = 0;
PublicParams.permutFreqComp = 25000;
PublicParams.freqCompOn = 0;
%%%%%%%%%%%%%%%%%% 
% Time-window settings:

% time-windowing on/off:
PublicParams.winOn = 0;
% Set window size and step size in samples. 
% Note: if windowSize exceeds time-series length,
% windowing is not used.
PublicParams.windowSize = 30;
PublicParams.windowStep = 30;

%%%%%%%%%%%%%%%%%%
% Permutation test settings. 
% To perform the following analysis, corOn must be set to 1.

% Set permutation parameters for frequency-specific ISC.
% To save time and memory, calculation can be done parallel
%  using several CPU:s (nrPermutationSets). Total 
% number of realizations in the "null distribution"
% will be: nrPermutationSets * nrPermutations (e.g. 10e7).
PublicParams.nrPermutationSets = 1;
PublicParams.nrPermutations = 10e6; % changed bt JT 10.02.2016

% Set permutation parameters for frequency-band comparison statistic. 
% Total number of realization in the "null distribution" will be
% nrPermutationsZPF * numberOfBrainVoxels
%PublicParams.nrPermutationsZPF = 25000; % e.g. 25000

%%%%%%%%%%%%%%%%
% Default grid computation settings:
PublicParams.disableGrid = true;
PublicParams.gridParams = '';
PublicParams.mainProcessGrid = false; 
PublicParams.noParallelization = false;
Gtypes = testGrid;
PublicParams.gridType = Gtypes{1};
%grid = testGrid
grid = PublicParams.gridType; %select the first type as default
if strcmp(grid,'sge')
    PublicParams.gridParams = '-l arch=lx24-amd64,h_rt=48:0:0,mf=8G';
    PublicParams.disableGrid = false;     
end
if strcmp(grid,'slurm')
    PublicParams.gridParams = '--partition=normal --mem=8096 --time=2-0';
    PublicParams.disableGrid = false;   
end
if strcmp(grid,'torque')
    PublicParams.gridParams = '-q long -l arch=lx24-amd64,walltime=2:0:0,mem=8G';
    PublicParams.disableGrid = false;    
end

%%%%%%%%%%%%%%%%
% Memmap removal after analysis settings:
PublicParams.removeMemmaps = false;
PublicParams.removeFiltermaps = false;

Params.PublicParams = PublicParams;
