function handles = setParamFields(handles,PublicParams)

if PublicParams.nrFreqBands > 0;
    set(handles.checkboxFreq,'Value',1)
else
    set(handles.checkboxFreq,'Value',0)
end

if (PublicParams.calcStandard == 1)
    set(handles.checkboxCor,'Enable','inactive')
    set(handles.checkboxCor,'Value',1)
end
set(handles.editTR,'Enable','on')
    
% set frequency band setting:
if get(handles.checkboxFreq,'Value') == 1
%    set(handles.pushbuttonFreqSett,'Enable','on')
    set(handles.editBands,'Enable','on')
    set(handles.checkboxFreqComp, 'Enable','on')
    if get(handles.checkboxFreqComp,'Value')
        set(handles.editFreqPerm,'Enable','on')
    else
        set(handles.editFreqPerm,'Enable','off')        
    end
%    PublicParams.nrFreqBands = 3;
    set(handles.checkboxPhase,'Enable','on')
else
%    set(handles.pushbuttonFreqSett,'Enable','off') %this is not used anymore! -JP
    set(handles.editFreqPerm,'Enable','off')
   % set(handles.editTR,'Enable','off')
    set(handles.editBands,'Enable','off')
    set(handles.checkboxFreqComp,'Enable','off')
    set(handles.checkboxPhase,'Enable','off')
%    PublicParams.nrFreqBands = 0;
end


set(handles.editBands,'String',num2str(PublicParams.nrFreqBands));
checkLen(PublicParams.nrFreqBands);

set(handles.editFreqPerm,'String',num2str(PublicParams.permutFreqComp));
set(handles.checkboxFreqComp,'Value',PublicParams.freqCompOn);


set(handles.checkboxSessionComp,'Value',PublicParams.sessionCompOn);

set(handles.checkboxRemoveMaps,'Value',PublicParams.removeMemmaps)
set(handles.removeFilterMaps,'Value',PublicParams.removeFiltermaps)
set(handles.checkboxdisableGrid,'Value',PublicParams.disableGrid)

if get(handles.checkboxFreqComp,'Value')
    set(handles.editFreqPerm,'Enable','on')
    set(handles.removeFilterMaps,'Enable','on')
else
    set(handles.editFreqPerm,'Enable','off')
    set(handles.removeFilterMaps,'Enable','off')
end


set(handles.editTR,'String',num2str(1/PublicParams.samplingFrequency));

% set time window settings:

set(handles.checkboxTime,'Value',PublicParams.winOn)
set(handles.editWinLen,'String',num2str(PublicParams.windowSize));
set(handles.editWinStep,'String',num2str(PublicParams.windowStep));
if get(handles.checkboxTime,'Value') == 1
    set(handles.editWinLen,'Enable','on')
    set(handles.editWinStep,'Enable','on')
else
    set(handles.editWinLen,'Enable','off')
    set(handles.editWinStep,'Enable','off')
end

% set template settings:
set(handles.radiobuttonTemplateMNI,'Value',1)
if handles.Pub.useTemplate == 1
    set(handles.checkboxTemplate,'Value',1)
    set(handles.radiobuttonTemplateMNI,'Enable','on')
else
    set(handles.checkboxTemplate,'Value',0)
    set(handles.radiobuttonTemplateMNI,'Enable','off')    
end


% set similarity metric settings:

set(handles.checkboxCor,'Value',PublicParams.corOn)
set(handles.checkboxKen,'Value',PublicParams.kenOn,'Visible','off')
set(handles.checkboxMI,'Value',PublicParams.nmiOn,'Visible','off')
set(handles.checkboxSSI,'Value',PublicParams.ssiOn,'Visible','off')

set(handles.pushbuttonCorSett,'Enable','off') 

if get(handles.checkboxCor,'Value') == 1
    set(handles.pushbuttonCorSett,'Enable','on')
else
    set(handles.pushbuttonCorSett,'Enable','off')    
end

set(handles.pushbuttonDifSettings,'Enable','off') 

if get(handles.checkboxSessionComp,'Value') == 1
    set(handles.pushbuttonDifSettings,'Enable','on')
else
    set(handles.pushbuttonDifSettings,'Enable','off')    
end

set(handles.pushbuttonFuSeSettings,'Enable','off') 
if get(handles.checkboxFuSe,'Value') || PublicParams.FuSeOn
    set(handles.pushbuttonFuSeSettings,'Enable','on')
    set(handles.checkboxFuSe,'Value', true);
else
    set(handles.pushbuttonFuSeSettings,'Enable','off')    
end

set(handles.checkboxPhase,'Value',PublicParams.calcPhase)

% Set grid computation parameters:
set(handles.checkboxdisableGrid,'Value',PublicParams.disableGrid)
set(handles.gridParams,'String', PublicParams.gridParams)
set(handles.checkbox_mainProcessGrid,'Value', PublicParams.mainProcessGrid);
if PublicParams.mainProcessGrid
    set(handles.chekcbox_noParallelization, 'Enable','on');
    set(handles.chekcbox_noParallelization,'Value',PublicParams.noParallelization)
else
    set(handles.chekcbox_noParallelization, 'Enable','off');
    set(handles.chekcbox_noParallelization,'Value',false)
end
set(handles.popupmenu_gridType,'String', testGrid)
% set subject source files:

set(handles.popupmenuSession,'String','Session 1','Value',1)
for k1 = 1:size(PublicParams.subjectSource,2)
    D{k1} = PublicParams.subjectSource{1,k1};
end
set(handles.editSubj,'String',D)
handles = setSubjectBox(handles);
%handles = validateParams(handles,'subj'); % not needed here -JP
% check if source fMRI files exist and print note if some of them does not:
for k1 = 1:size(handles.Pub.subjectSource,1)
    for k2 = 1:size(handles.Pub.subjectSource,2)
        if ~isempty(handles.Pub.subjectSource{k1,k2})
            if exist(handles.Pub.subjectSource{k1,k2},'file') ~= 2
                warning(['  File "' handles.Pub.subjectSource{k1,k2} '" not found.'])
            end
        end
    end
end
% set paths:

set(handles.editDestin,'String',PublicParams.dataDestination);
set(handles.editTemplates,'String',PublicParams.atlasPath);
set(handles.editProject,'String',PublicParams.dataDescription);
set(handles.editTemplates,'Visible','off');
set(handles.textTemplates,'Visible','off');

%handles = validateParams(handles,'template');

if PublicParams.useTemplate
    set(handles.checkboxTemplate,'Value',1)
    set(handles.radiobuttonTemplateMNI,'Value',1,'Enable','on')
    set(handles.editMask,'Enable','on','String',PublicParams.atlasPath)
    set(handles.textMask,'Enable','on','String','Directory of standard templates')
%    set(handles.editTemplates,'Visible','on');
%    set(handles.textTemplates,'Visible','on');
else
    set(handles.checkboxTemplate,'Value',0)
    set(handles.radiobuttonTemplateMNI,'Value',0,'Enable','off')
    set(handles.editMask,'Enable','on','String',PublicParams.atlasPath)
    set(handles.textMask,'Enable','on','String','Binary mask file name (extension .nii or .mat)')
%    set(handles.editTemplates,'Visible','off');
%    set(handles.textTemplates,'Visible','off');
end

% set source file type:

if strcmp(PublicParams.fileFormatSubj,'nii')
    set(handles.popupmenuFormat,'Value',1);
elseif strcmp(PublicParams.fileFormatSubj,'mat')
    set(handles.popupmenuFormat,'Value',2);
else
    warning('Unknown file format!!')
end

