function handles = validateDataAndParams(handles)

failedTests = zeros(1,7);

if ~strcmp(handles.Pub.dataDestination(end),getSlash)
    handles.validFlag = false;
    disp(' ')
    disp('Destination directory must end with "slash".')
    disp('Validation failed.')
    failedTests(1) = 1;
    return
end    

handles.validFlag = true;

disp(' ')
disp('Searching and validating fMRI data...')

handles = validateParams(handles,'subj');
if ~handles.validFlag
    disp(' ')
    disp('Validation failed.')
    failedTests(2) = 1;
    return
end

if ( strcmp(handles.Pub.fileFormatSubj,'nii') || handles.Pub.useTemplate == 1 )
    disp(' ')
    disp('Searching nifti-package...')
    if ~( ( exist('load_nii_hdr.m','file') == 2 ) && ...
            ( exist('load_nii_img.m','file') == 2 ) && ...
            ( exist('load_nii.m','file') == 2 ) )
        handles.validFlag = false;
        disp(' ')
        disp('Package to read Nifti-files to Matlab not found.')
        disp('Package can be loaded from: http://www.rotman-baycrest.on.ca/~jimmy/NIFTI/')
        disp('Validation failed.')
        failedTests(4) = 1;
        return
    end

end
if failedTests(4) == 0
    disp('Ok!')
end

disp(' ')
disp('Set private parameters...')
try
    [handles.Priv,handles.Pub] = setPrivParams(handles.Pub);
    %handles.Priv
catch
    handles.validFlag = false;
    disp(' ')
    disp(lasterr)
    disp('Validation failed.')
    failedTests(3) = 1;
    return
end

if sum(handles.Priv.dummies(:)) > 0 && handles.Pub.FuSeOn
        handles.validFlag = false;
        disp(' ')
        disp('FuSeISC can only be run for sessions having equal number of subjects!')
        disp('Validation failed.')
        failedTests(3) = 1;
        return    
end

% Check the matrix denoting dummy subjects created due to difference in group sizes:
for m1 = 1:size(handles.Priv.dummies,1)
    dum = handles.Priv.dummies(m1,:);
    if min(diff(dum)) < 0
        handles.validFlag = false;
        disp(' ')
        disp('Replicated (dummy) subjects can only be last subjects in the group!')
        disp('Validation failed.')
        failedTests(3) = 1;
        return
    end
    if sum(handles.Priv.dummies(m1,:)) > 0
        disp(['Note: some of the subjects in group ' num2str(m1) ' temporarily replicated to handle ISC group comparison with unequal group sizes!'])
    end
end

if failedTests(3) == 0
    disp('Ok!')
end

if handles.Pub.nrFreqBands > 0
    disp(' ')
    disp('Checking frequency parameters...')
    handles = validateParams(handles,'freqBands');
    if ~handles.validFlag
        disp(' ')
        disp('Validation failed.')
        failedTests(5) = 1;
        return
    end
end

if handles.Pub.useTemplate == 1
    disp(' ')
    disp('Searching standard templates...')
    
    handles = validateParams(handles,'template');
    if ~handles.validFlag
        disp(' ')
        disp('Validation failed.')
        failedTests(6) = 1;
        return
    end
end

disp(' ')
disp('Checking TR...')
handles = validateParams(handles,'TR');
if ~handles.validFlag
    disp(' ')
    disp('Validation failed.')
    failedTests(7) = 1;
    return
end

if sum(failedTests) == 0
    disp(' ')
    disp('Validation successful!!')
    disp(' ')
    Params.PublicParams = handles.Pub;
    Params.PrivateParams = handles.Priv;
    save([handles.Pub.dataDestination handles.Pub.dataDescription '_params'],'Params')
    disp(['Parameter file ''' handles.Pub.dataDescription '_params.mat'' saved to directory ' handles.Pub.dataDestination '.'])
    handles.Params = Params;
    handles.ParamsValid = Params;
    cleanResultFolders(Params); %clean the folders so that new results are computed if parameters are changed
else
    disp(' ')
    disp('Failed tests:')
    if failedTests(1)
        disp('Destination directory')
    end
    if failedTests(2)
        disp('Subject directories')
    end
    if failedTests(3)
        disp('Setting Private parameters')
    end
    if failedTests(4)
        disp('Nifti-file package')
    end
    if failedTests(5)
        disp('Frequency band settings')
    end
    if failedTests(6)
        disp('Template settings')
    end
    
    
end
