/* $Revision: 1.1.6.3 $  $Date: 2004/01/24 09:36:23 $ */

#include "mex.h"
#include <math.h>
#include <string.h>

/* Euclidean distance */

void  sparsifyGraph(double *c, double *d,int numPoints,int numNeighbors,double *a)
{
    
    int i,j,k,val;
    double *D0,*D1,*C0,*C1,*C2,*A1;
    
    C0 = c; /* pointer to the index matrix possibly containing zeros */
    D0 = d; /* pointer to the data points to be sparsified: [1 0 0 1 0 1 1 1 ...] */
    D1 = d;
    
    for (i = 0; i < numPoints ; i++, D1++) {
        C1 = C0 + i*numNeighbors;
/*        printf("Point A: %i\n",i+1);*/
        
        if ( *D1 == 1 ) { /* sparsify links connected to (i+1)th data point */
/*            printf("Will be sparsified %i\n");*/

            for (j = 0; j < numNeighbors ; j++, C1++) { /* browse neighbors of (i+1)th data point */
                val = (int)*C1;
        /*        printf("Point B: %i\n",val);*/

                if (val != 0) { /* if the neighbor index is not zero, remove a link by making the index zero */
                    *C1 = 0;
                    C2 = C0 + numNeighbors*(val-1); /* SNN matrix is symmetrix so the link must be removed also from another location */
                    for (k = 0; k < numNeighbors ; k++, C2++) {
/*                        printf("Check symm. points: %i\n",(int)*C2);*/

                        if ( (int)*C2 == i+1 ) {
/*                            printf("Sparsify point: %i\n",(int)*C2);*/
                            *C2 = 0;
                            break;
                        }
                        
                    }
                    
                }
                
            }
        }
    }

    
    /* copy values to the output matrix */
    C1 = C0;
    A1 = a;
    for (i = 0; i < numPoints ; i++) {
        for (j = 0; j < numNeighbors ; j++, A1++, C1++) {
    /*        printf("Copy: %i\n",(int)*C1);*/
           *A1 = *C1; 
        }
    }    
}

/* the gateway function */
void mexFunction( int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    
    
    int numNeighbors,numPoints,cols,rows;
    
    
    
  /*  check for proper number of arguments */
  /* NOTE: You do not need an else statement when using mexErrMsgTxt
     within an if statement, because it will never get to the else
     statement if mexErrMsgTxt is executed. (mexErrMsgTxt breaks you out of
     the MEX-file) */
    if (nrhs<2) {
        mexErrMsgIdAndTxt("sparsifyGraph.c:TooFewInputs",
        "Two input arguments required.");
    } else if (nrhs>2) {
        mexErrMsgIdAndTxt("sparsifyGraph.c:TooManyInputs",
        "Two input argument2 required.");
    } else if(nlhs>1) {
        mexErrMsgIdAndTxt("sparsifyGraph.c:TooManyOutputs",
        "Too many output arguments.");
    }
    
  /* Check the type of the input array */
    if (mxIsDouble(prhs[0]) && mxIsDouble(prhs[1])) {
        double *d,*c,*a;
        
  /*  create a pointer to the input matrix y */
        c = mxGetPr(prhs[0]);
        d = mxGetPr(prhs[1]);
        
  /*  get the dimensions of the matrix input y */
        numPoints = mxGetN(prhs[0]);
        numNeighbors = mxGetM(prhs[0]);
        rows = mxGetN(prhs[1]);
        cols = mxGetM(prhs[1]);
        
        if ( rows != numPoints || cols != 1 || numNeighbors > numPoints ) {
            mexErrMsgIdAndTxt("sparsifyGraph.c","incompatible inputs.");
        }
        
        plhs[0] = mxCreateDoubleMatrix(numNeighbors,numPoints,mxREAL);
        a = mxGetPr(plhs[0]);
        
        sparsifyGraph(c,d,numPoints,numNeighbors,a);
        
    } else {
        mexErrMsgIdAndTxt("sparsifyGraph.c:BadInputType",
        "sparsifyGraph.c only supports real DOUBLE data.");
    }
    
}
