#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include <itkLabelStatisticsImageFilter.h>
#include <itkLabelImageToShapeLabelMapFilter.h>
#include "itkHistogramMatchingImageFilter.h"

int main( int argc, char ** argv )
{

	// Verify the number of parameters in the command line
	if( argc < 4 )
	{
		std::cerr << "Usage: " << std::endl;
		std::cerr << argv[0] << " InputImage ReferenceImage OutputImage" << std::endl;
		return EXIT_FAILURE;
	}

	typedef float	InputPixelType;
	typedef itk::Image< InputPixelType,  3 >    InputImageType;

	typedef itk::ImageFileReader< InputImageType>  ReaderType;
	typedef itk::HistogramMatchingImageFilter<InputImageType,InputImageType> HistogramMatchingImageFilterType;
	typedef itk::ImageFileWriter<InputImageType> WriterType;
	
	ReaderType::Pointer reader = ReaderType::New();
	WriterType::Pointer writer = WriterType::New();
	HistogramMatchingImageFilterType::Pointer filter = HistogramMatchingImageFilterType::New();
	
	std::cout << "Reading input image..." << std::endl;
	reader->SetFileName(argv[1]);
	reader->Update();
	InputImageType::Pointer inputImage = reader->GetOutput();
	std::cout << "Reading reference image..." << std::endl;
	reader = ReaderType::New();
	reader->SetFileName(argv[2]);
	reader->Update();
	InputImageType::Pointer referenceImage = reader->GetOutput();
	
	filter->SetSourceImage(inputImage);
	filter->SetReferenceImage(referenceImage);
	filter->SetNumberOfHistogramLevels(256);
	filter->SetNumberOfMatchPoints(32);
	std::cout << "Matching histograms..." << std::endl;
	filter->Update();
	
	std::cout << "Writing output image..." << std::endl;	
	writer->SetInput(filter->GetOutput());
	writer->SetFileName(argv[3]);
	
	writer->Update();
	
	return EXIT_SUCCESS;
}


