#!/bin/bash

if [ -z $1 ]||[ -z $2 ]||[ -z $3 ]; then
	echo -e "\nUsage: $0 <in_4dfile> <out_atlas> <out_stdev> [option(intermediatedir)]\n"
	echo -e "option (must be at the end of the command):"
	echo -e "       -r  0|1  outlier rejection (1, default) or not (0).\n"
	echo -e "dependency: FSL"
	exit 1
fi
intdir=""
outlierrejection=1;  # default
file4D=$1
outmean=$2
outstd=$3
intdir=$4

while [ -n "$4" ]; do
	case $4 in
		-r) 
			outlierrejection=$5;
			shift;;
		*)
			break;;
	esac
done
while [ -n "$5" ]; do
        case $5 in
                -r)
                        outlierrejection=$6;
                        shift;;
                *)
                        break;;
        esac
done

if [ "${intdir}" == "-r" ]; then
	intdir=""
fi
echo ""
echo "input arguments:"
echo "	file4D=${file4D}"
echo "	outmean=${outmean}"
echo "	outstd=${outstd}"
echo "	intdir=$intdir"
echo "	outlierrejection=$outlierrejection"
if [ ${outlierrejection} -ne 1 ]&&[ ${outlierrejection} -ne 0 ]; then
	echo -e "\nError: -r argument must be followed by 0 or 1. See instruction by calling the command with no arguments.\n"
	exit 1	
fi 


#########################################
# Program starts
#########################################

# count the total number of images
nT=`fslinfo $file4D |grep dim4 | sed -n 1p | awk '{print $2}'`
if [ -z "${intdir}" ]; then
	tmpdir=`mktemp -d /tmp/myTmeanTstd-"XXXX"`
	if [ ! -d ${tmpdir} ]; then
		echo -e "\nFailed to create a temp directory. Program exits.\n"
		exit 1
	fi
else
	tmpdir=${intdir}
	if [ ! -d ${tmpdir} ]; then
		mkdir -p ${tmpdir}
	fi
fi
echo "totally ${nT} images."
echo "construct atlas in the temp dir ${tmpdir}"

# split the 4D file
echo -e "\nSplit the 4D file\n"
fslsplit ${file4D} ${tmpdir}/vol

# remove outlier (added 07/08/2015)
if [ ${outlierrejection} -eq 1 ]; then
	echo -e "\nRemove outliers at each voxel (iteratively)\n"
	for iter in {1..2}; do
		echo "iteration ${iter}"
		echo "step 1. compute median image"
		preiter=$(( ${iter} - 1 ))
		medianimage=${tmpdir}/median_iter${iter}.nii.gz
		vol4D=${tmpdir}/allimages4D.nii.gz
		fslmerge -t ${vol4D} ${tmpdir}/vol????.nii.gz
		3dTstat -nzmedian -prefix ${medianimage} ${vol4D}

		echo "step 2. compute difference from median"
		for ((n=0; n<${nT}; n=n+1)); do
	        	echo "   progress ${n}/${nT}..."
	        	if [ $n -lt 10 ]; then
        	        	num=000${n}
	        	elif [ $n -lt 100 ]; then
        	        	num=00${n}
		        elif [ $n -lt 1000 ]; then
        		        num=0${n}
	        	else
        	        	num=$n
		        fi
        		image=${tmpdir}/vol${num}.nii.gz
	        	mask0=${tmpdir}/mask${num}_iter0.nii.gz
			if [ -s ${image} ]&&[ ! -f ${mask0} ]; then
        	        	fslmaths ${image} -abs -bin ${mask0}
	        	fi
	        	if [ ! -s ${mask0} ]; then
        	        	echo -e "\nError: mask ${mask0} was not generated. Program exits.\n"
	        	        exit 1
	        	fi
			mask=${tmpdir}/mask${num}_iter${preiter}.nii.gz
			difffrommedian=${tmpdir}/vol${num}_difffrommedian.nii.gz
			fslmaths ${image} -sub ${medianimage} -mul ${mask} ${difffrommedian}
		done

		echo "step 3. compute median absolute difference (MAD)"
		diff4D=${tmpdir}/difffrommedian4D_iter${iter}.nii.gz
		diff4Dabs=${tmpdir}/absdifffrommedian4D_iter${iter}.nii.gz
		MADimage=${tmpdir}/MAD_iter${iter}.nii.gz
		fslmerge -t ${diff4D} ${tmpdir}/vol*difffrommedian.nii.gz
		fslmaths ${diff4D} -abs ${diff4Dabs}
		3dTstat -nzmedian -prefix ${MADimage} ${diff4Dabs}

		echo "step 4. detect outlier by modified Z-score (modifiedZ=0.6745*(x-median)/MAD): a voxel is an outlier if |modifiedZ|>3.5"
		for ((n=0; n<${nT}; n=n+1)); do
        	        echo "   progress ${n}/${nT}..."
                	if [ $n -lt 10 ]; then
                        	num=000${n}
	                elif [ $n -lt 100 ]; then
        	                num=00${n}
                	elif [ $n -lt 1000 ]; then
                        	num=0${n}
	                else
        	                num=$n
                	fi
			image=${tmpdir}/vol${num}.nii.gz
			mask=${tmpdir}/mask${num}_iter${preiter}.nii.gz
			difffrommedian=${tmpdir}/vol${num}_difffrommedian.nii.gz
			absmodifiedZmap=${tmpdir}/absmodifiedZmap${num}.nii.gz
			updatedmask=${tmpdir}/mask${num}_iter${iter}.nii.gz
			fslmaths ${difffrommedian} -mul 0.6745 -div ${MADimage} -mul ${mask} -nan -abs ${absmodifiedZmap}
			3dmerge -1blur_fwhm 5 -doall -prefix ${absmodifiedZmap%.nii.gz}2.nii.gz ${absmodifiedZmap}
			mv ${absmodifiedZmap%.nii.gz}2.nii.gz ${absmodifiedZmap}
			fslmaths ${absmodifiedZmap} -mul ${mask} ${absmodifiedZmap}
			3dcalc -a ${absmodifiedZmap} -b ${mask} -expr 'b-ispositive(a-3.5)' -prefix ${updatedmask}
			fslmaths ${image} -mul ${updatedmask} ${image}
		done
	done
# if outlier rejection
else
	for image in ${tmpdir}/vol????.nii.gz; do
		fslmaths ${image} -abs -bin ${tmpdir}/mask`basename ${image} |cut -c4-7`_iter2.nii.gz
	done
fi

# construct the atlas (the mean)
echo -e "\nConstruct the atlas (mean)\n"
#for ((n=0; n<${nT}; n=n+1)); do
#	echo "   progress ${n}/${nT}..."
#	if [ $n -lt 10 ]; then
#		num=000${n}
#	elif [ $n -lt 100 ]; then
#		num=00${n}
#	elif [ $n -lt 1000 ]; then
#		num=0${n}
#	else
#		num=$n
#	fi
#	image=${tmpdir}/vol${num}.nii.gz
#	mask=${tmpdir}/mask${num}.nii.gz
#
#	if [ -s ${image} ]&&[ ! -f ${mask} ]; then
#		fslmaths ${image} -abs -bin ${mask}
#	fi
#	if [ ! -s ${mask} ]; then
#		echo -e "\nError: mask ${mask} was not generated. Program exits.\n"
#		exit 1
#	fi
#done
image4D=${tmpdir}/f4dimage.nii.gz
mask4D=${tmpdir}/f4dmask.nii.gz
meanimage=${tmpdir}/imageTmean.nii.gz
meanmask=${tmpdir}/maskTmean.nii.gz
meanmask2=${tmpdir}/maskTmean2.nii.gz
echo checkpoint0
fslmerge -t ${image4D} ${tmpdir}/vol????.nii.gz
fslmerge -t ${mask4D} ${tmpdir}/mask*_iter2.nii.gz
fslmaths ${image4D} -Tmean ${meanimage}
fslmaths ${mask4D} -Tmean ${meanmask}
echo checkpoint1
3dcalc -a ${meanmask} -expr 'a+iszero(a)' -prefix ${meanmask2}
if [ -f ${outmean} ]; then
	\rm ${outmean}
fi
fslmaths ${meanimage} -div ${meanmask2} ${outmean}
if [ ! -f ${outmean} ]; then
	echo -e "/nFailed to create atlas ${outmean}. Program exits./n"
	exit 1
fi 


# calculate the stdev
echo -e "\nConstruct the atlas (stdev)\n"
sumdiffsq=${tmpdir}/sumdiffsquared.nii.gz
sumdiffsqtmp=${tmpdir}/sumdiffsquaredtmp.nii.gz
meandiffsq=${tmpdir}/meandiffsquared.nii.gz
if [ -f ${sumdiffsq} ]; then
	\rm ${sumdiffsq}
fi
if [ -f ${sumdiffsqtmp} ]; then
	\rm ${sumdiffsqtmp}
fi
if [ -f ${meandiffsq} ]; then
	\rm ${meandiffsq}
fi
for ((n=0; n<$nT; n++)); do
	echo "  progress ${n}/${nT}..."
	if [ $n -lt 10 ]; then
		num=000${n}
	elif [ $n -lt 100 ]; then
		num=00${n}
	elif [ $n -lt 1000 ]; then
		num=0${n}
	else
		num=$n
	fi
	image=${tmpdir}/vol${num}.nii.gz
	mask=${tmpdir}/vol${num}_mask.nii.gz
	diff=${tmpdir}/diff.nii.gz
	diffsquared=${tmpdir}/diffsquared.nii.gz
	if [ -f ${diff} ]; then
		\rm $diff
	fi
	if [ -f ${diffsquared} ]; then
		\rm ${diffsquared}
	fi
	fslmaths ${image} -sub ${outmean} ${diff}
	fslmaths ${image} -abs -bin ${mask}
	fslmaths ${diff} -mul ${diff} -mul ${mask} ${diffsquared}
	if [ $n == 0 ]; then
		cp ${diffsquared} ${sumdiffsq}
	else
		fslmaths ${sumdiffsq} -add ${diffsquared} ${sumdiffsqtmp}
		\mv ${sumdiffsqtmp} ${sumdiffsq}
	fi
done
echo "checkpoint a"
fslmaths ${sumdiffsq} -div ${meanmask2} -div ${nT} ${meandiffsq}
echo "checkpoint b"
fslmaths ${meandiffsq} -sqrt ${outstd}
if [ -f ${outstd} ]; then
	echo -e "\nThe stdev image has been saved to ${outstd}\n"
	if [ -z "${intdir}" ]; then
		\rm -rf ${tmpdir}
	fi
else
	echo -e "\nError: Failed to generate the stdev image.\n"
fi


