/*=========================================================================

 Program:   BRAINS (Brain Research: Analysis of Images, Networks, and Systems)
 Module:    $RCSfile: $
 Language:  C++
 Date:      $Date: 2006/03/29 14:53:40 $
 Version:   $Revision: 1.9 $

   Copyright (c) Iowa Mental Health Clinical Research Center. All rights reserved.
   See BRAINSCopyright.txt or http://www.psychiatry.uiowa.edu/HTML/Copyright.html
   for details.

      This software is distributed WITHOUT ANY WARRANTY; without even
      the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
      PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#include "itkLabelStatisticsImageFilter.h"
#include "itkImageRandomNonRepeatingConstIteratorWithIndex.h"


ImageType::Pointer BRAINSRandomClassSamplePlugsCSI(ImageType::Pointer);

ImageType::Pointer BRAINSRandomClassSamplePlugsCSI(ImageType::Pointer labelImage)
{
  int plugScarcityOnePartPer = 1;
  int numberOfPlugs = 100;

	typedef itk::LabelStatisticsImageFilter< ImageType, ImageType >		LabelStatisticsFilterType;
  LabelStatisticsFilterType::Pointer statisticsFilter = LabelStatisticsFilterType::New();
  statisticsFilter->SetInput( labelImage );
  statisticsFilter->SetLabelInput( labelImage );
  statisticsFilter->Update();

  ImageType::Pointer plugLabelImage = ImageType::New();
  plugLabelImage->SetRegions( labelImage->GetLargestPossibleRegion() );
  plugLabelImage->SetSpacing( labelImage->GetSpacing() );
  plugLabelImage->SetDirection( labelImage->GetDirection() );
  plugLabelImage->SetOrigin( labelImage->GetOrigin() );
  plugLabelImage->Allocate( );
  plugLabelImage->FillBuffer( 0 );

  for (int i=1; i<7; i++)
  {
    ImageType::RegionType labelRegion = statisticsFilter->GetRegion( static_cast<unsigned char> ( i ) );
    itk::ImageRandomNonRepeatingConstIteratorWithIndex<ImageType> it( labelImage, labelRegion );

    int tissuePlugs = 0;
    it.SetNumberOfSamples(numberOfPlugs*plugScarcityOnePartPer);
    it.GoToBegin();
    while( !it.IsAtEnd() )
    {
      if ( it.Get() == i )  // The labelRegion was a bounding box, so test the label pixel each time.
      {
        // Set Output Image
        plugLabelImage->SetPixel(it.GetIndex(), static_cast<unsigned char> ( i ));
        if ( tissuePlugs == numberOfPlugs ) break;
        tissuePlugs++;
      }
      ++it;  // here it jumps to another random position inside the region
    }
    if (tissuePlugs < numberOfPlugs)
    {
      std::cerr << "Malfunction:  Sampling label " << i << ", found only " << tissuePlugs;
      std::cerr << " plugs when seeking " << numberOfPlugs << " plugs." << std::endl;
      std::cerr << "^^^^^^^^^^^   Perhaps the label has too few voxels for an expectation";
      std::cerr << " of greater than one part per " << plugScarcityOnePartPer << "." << std::endl;
    }
  }

  return plugLabelImage;
}



