/*=========================================================================

 Program:   BRAINS (Brain Research: Analysis of Images, Networks, and Systems)
 Module:    $RCSfile: $
 Language:  C++
 Date:      $Date: 2006/03/29 14:53:40 $
 Version:   $Revision: 1.9 $
 
   Copyright (c) Iowa Mental Health Clinical Research Center. All rights reserved.
   See BRAINSCopyright.txt or http://www.psychiatry.uiowa.edu/HTML/Copyright.html 
   for details.
 
      This software is distributed WITHOUT ANY WARRANTY; without even 
      the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
      PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#include "BayesianClassifierBrainCSI.h"
#include "itkImageToVectorImageFilter.h"
#include "itkLabelStatisticsImageFilter.h"
#include "itkThresholdImageFilter.h"
#include "itkSmoothingRecursiveGaussianImageFilter.h"
#include "itkMaskImageFilter.h"
#include "itkMeanCalculator.h"
#include "itkCovarianceCalculator.h"
#include "itkGaussianDensityFunction.h"
#include "BayesianClassifierInitializationVectorImageFilter.h"
#include "itkBayesianClassifierUIImageFilter.h"
#include "itkImageFileWriter.h"
#include "itkImageRandomNonRepeatingConstIteratorWithIndex.h"
#include "itkOrientImageFilter.h"
#include <iostream>
#include <fstream>

vtkKWImage * BayesianClassifierBrainCSI( vtkKWImage * T1ImageKW, vtkKWImage * T2ImageKW, 
							   vtkKWImage * KMeansImageKW, vtkKWImage * brainMaskKW, 
							   vtkKWImage * plugLabelImageKW)
{ 
	std::ofstream debugStream;
	debugStream.open("E:\\Development\\output\\bayesian.txt");
	clock_t time[20];
	time[0] = clock();

	ImageType::Pointer T1Image = GetITK(T1ImageKW);
	ImageType::Pointer T2Image = GetITK(T2ImageKW);
	ImageType::Pointer KMeansImage = GetITK(KMeansImageKW);
	ImageType::Pointer brainMask = GetITK(brainMaskKW);
	ImageType::Pointer plugLabelImage = GetITK(plugLabelImageKW);

	//typedef itk::ImageFileWriter<ImageType>											WriterType;
 //   WriterType::Pointer writer1 = WriterType::New();
	//writer1->SetInput(T1Image); //bayesianclassifier->GetOutput(0));
	//writer1->SetFileName( "E:\\Development\\output\\T1bayesian.nii" );
	//try
	//{
	//	writer1->Update();
	//}	
	//catch(itk::ExceptionObject exp)
	//{
	//	debugStream <<exp<<std::endl;
	//	debugStream << "Failed" <<std::endl;
	//}
	  
	//WriterType::Pointer writer2 = WriterType::New();
	//writer2->SetInput(T2Image); //bayesianclassifier->GetOutput(0));
	//writer2->SetFileName( "E:\\Development\\output\\T2bayesian.nii" );
	//try
	//{
	//	writer2->Update();
	//}	
	//catch(itk::ExceptionObject exp)
	//{
	//	debugStream <<exp<<std::endl;
	//	debugStream << "Failed" <<std::endl;
	//}
	//
	//WriterType::Pointer writer3 = WriterType::New();
	//writer3->SetInput(brainMask); //bayesianclassifier->GetOutput(0));
	//writer3->SetFileName( "E:\\Development\\output\\BrainMaskbayesian.nii" );
	//try
	//{
	//	writer3->Update();
	//}	
	//catch(itk::ExceptionObject exp)
	//{
	//	debugStream <<exp<<std::endl;
	//	debugStream << "Failed" <<std::endl;
	//}

	int smoothingSigma = 1;
	int numberOfClasses = 4;  // includes background 
    int InputClassValues[4]; // does not include background

	for (int i=0;i<numberOfClasses;i++)
    {
		InputClassValues[i] = i;  // Does not include background
    }

  //------------------------------------------------------------------------------------
  //Load Images

	itk::ImageToVectorImageFilter<ImageType>::Pointer 
			image2vectorimagefilter = itk::ImageToVectorImageFilter<ImageType>::New();		
	// Look at ImageInput and Add to CLP Parameters 

	typedef itk::MaskImageFilter<ImageType, ImageType >				MaskFilterType;
    MaskFilterType::Pointer T1clippedFilter = MaskFilterType::New();

    T1clippedFilter->SetInput1( T1Image  );
    T1clippedFilter->SetInput2( brainMask );
    T1clippedFilter->SetOutsideValue(0);
	T1clippedFilter->Update();
		
	ImageType::Pointer T1ImageClipped = ImageType::New();
	T1ImageClipped = T1clippedFilter->GetOutput();
	          
	MaskFilterType::Pointer T2clippedFilter = MaskFilterType::New();

    T2clippedFilter->SetInput1( T2Image );
    T2clippedFilter->SetInput2(  brainMask );
    T2clippedFilter->SetOutsideValue(0);
	T2clippedFilter->Update();

	ImageType::Pointer T2ImageClipped = ImageType::New();
	T2ImageClipped = T2clippedFilter->GetOutput();

	int numberOfImages = 2;
	image2vectorimagefilter->SetNthInput( 0, T1ImageClipped );
	image2vectorimagefilter->SetNthInput( 1, T2ImageClipped );						

	image2vectorimagefilter->Update();

	VectorImageType::Pointer anatImages = VectorImageType::New();
	
	anatImages = image2vectorimagefilter->GetOutput();		
	
	//End of Loading Images
	//------------------------------------------------------------------------------------
	// Load Prior Image and Put Into Vector Image

	 itk::ImageToVectorImageFilter<ImageType>::Pointer 
				image2vectorimagefilter2 = itk::ImageToVectorImageFilter<ImageType>::New();

	 VectorImageType::Pointer classImages = VectorImageType::New();

     typedef itk::LabelStatisticsImageFilter< ImageType, ImageType >		LabelStatisticsFilterType;
     LabelStatisticsFilterType::Pointer statisticsFilter = LabelStatisticsFilterType::New();
     statisticsFilter->SetInput( KMeansImage );
     statisticsFilter->SetLabelInput( KMeansImage );
     statisticsFilter->Update();

	for (short int i = 0; i < numberOfClasses; i++) 
	{
		//Create new image and iterate through KMeans image to make a mask for each class
		//Do not do class = 0 which is outside the brain.
		ImageType::Pointer currentPriorImage = ImageType::New();
		currentPriorImage->SetRegions( KMeansImage->GetLargestPossibleRegion() );
		currentPriorImage->SetSpacing( KMeansImage->GetSpacing() );
		currentPriorImage->SetDirection( KMeansImage->GetDirection() );
		currentPriorImage->SetOrigin( KMeansImage->GetOrigin() );
		currentPriorImage->Allocate();
		currentPriorImage->FillBuffer(0);

		ImageType::RegionType labelRegion = statisticsFilter->GetRegion( static_cast<signed short>(InputClassValues[i]) );
		itk::ImageRegionIterator<ImageType> it1( KMeansImage, labelRegion );
		itk::ImageRegionIterator<ImageType> it2( currentPriorImage, labelRegion );

		it1.GoToBegin();
		it2.GoToBegin();
		while( !it1.IsAtEnd() ) 
		{
		   if (it1.Get() == static_cast<signed short>(InputClassValues[i])) 
		   {
			   it2.Set(1);
		   }
		   ++it1;
		   ++it2;
		}

		typedef itk::SmoothingRecursiveGaussianImageFilter<ImageType,ImageType>				SmoothingFilterType;
		SmoothingFilterType::Pointer smoothingFilter = SmoothingFilterType::New();
		smoothingFilter->SetInput(currentPriorImage);
		smoothingFilter->SetSigma(smoothingSigma);
		try
		{
			 smoothingFilter->Update();
		}
		catch( itk::ExceptionObject exp )
		{
		   std::cerr << "Exception caught !" << std::endl;
		   std::cerr << exp << std::endl;

		}

		currentPriorImage = smoothingFilter->GetOutput();

		
		typedef itk::MaskImageFilter<ImageType, ImageType >				MaskFilterType;
		MaskFilterType::Pointer clippedBrainPriorFilter = MaskFilterType::New();

		clippedBrainPriorFilter->SetInput1( currentPriorImage );
		clippedBrainPriorFilter->SetInput2( brainMask );
		clippedBrainPriorFilter->SetOutsideValue(0);
		clippedBrainPriorFilter->Update();


		ImageType::Pointer clippedBrain = ImageType::New();
		clippedBrain = clippedBrainPriorFilter->GetOutput();

		image2vectorimagefilter2->SetNthInput( i, clippedBrain );
	}
	
	try
	{
		image2vectorimagefilter2->Update();
	}
	catch( itk::ExceptionObject exp )
	{
		debugStream << "Exception caught !" << std::endl;
		debugStream << exp << std::endl;
	}

	time[1] = clock() - time[0];
	debugStream <<"Image 2 Vector Image Time elapsed: "<<time[1]/CLOCKS_PER_SEC << std::endl;

	classImages = image2vectorimagefilter2->GetOutput();

	std::vector<PointSetType::Pointer> classExemplars;
	
	for (int i=0; i<numberOfClasses; i++) 
	{
		classExemplars.push_back(CreateTrainingPoints(plugLabelImage, InputClassValues[i]));
		//debugStream <<"Exemplars: " << classExemplars[i] << std::endl;
	}

  // End of Class Plug Label Image
  //------------------------------------------------------------------------------------
	time[2] = clock() - time[1];
	debugStream <<"Label Image Time elapsed: "<<time[2]/CLOCKS_PER_SEC << std::endl;

  //------------------------------------------------------------------------------------
  // Create Class Samples Using Images and Exemplar Points

	std::vector<SampleType::Pointer> training;
	for (int i=0; i<numberOfClasses; i++) 
    {
		training.push_back(SampleType::New());
		training[i]->SetMeasurementVectorSize( numberOfImages );
	}

	std::vector< ClassSampleType::Pointer > classSamples;
	for (int i=0 ; i < numberOfClasses ; i++ ) 
    {
		classSamples.push_back( ClassSampleType::New() );
		classSamples[i]->SetSample( training[i] );
	}

	for (int i=0; i<numberOfClasses; i++) 
    {
		GetClassTraining(classExemplars[i], anatImages, training[i], classSamples, i, numberOfImages);
		//debugStream <<"training: " << training[i] << std::endl;
		//debugStream <<"classSamples: " << classSamples[i] << std::endl;
	}
  
	
	// End of Creating Class Samples
  //--------------------------------------------------------------------------------------
	time[3] = clock() - time[2];
	debugStream <<"Class Training Time elapsed: "<<time[3]/CLOCKS_PER_SEC << std::endl;

  //--------------------------------------------------------------------------------------
  //Calculate Estimated Class Means and Covariances

	typedef itk::Statistics::MeanCalculator< ClassSampleType >						MeanEstimatorType;
	typedef itk::Statistics::CovarianceCalculator< ClassSampleType >				CovarianceEstimatorType;

	std::vector< MeanEstimatorType::Pointer > meanEstimators;
	std::vector< CovarianceEstimatorType::Pointer > covarianceEstimators;

	for (int i= 0 ; i<numberOfClasses ; i++ )
	{
		meanEstimators.push_back( MeanEstimatorType::New() );
		meanEstimators[i]->SetInputSample( classSamples[i] );
		meanEstimators[i]->Update();

		//debugStream<<"mean "<<i<<": "<<meanEstimators[i]<<std::endl;
    
		covarianceEstimators.push_back( CovarianceEstimatorType::New() );
		covarianceEstimators[i]->SetInputSample( classSamples[i] );
		covarianceEstimators[i]->SetMean( meanEstimators[i]->GetOutput() );
		covarianceEstimators[i]->Update();
	}

  // End of Calculating Estimated Class Means and Covariances
  //--------------------------------------------------------------------------------------

  //--------------------------------------------------------------------------------------
  // Create Gaussian Membership Functions.

	typedef itk::Statistics::GaussianDensityFunction<MeasurementVectorType>			GaussianMembershipFunctionType;
	typedef itk::VectorContainer< PixelType, 
						GaussianMembershipFunctionType::MeanType* >					MeanEstimatorsContainerType;
	typedef itk::VectorContainer< unsigned short, 
						GaussianMembershipFunctionType::CovarianceType* >			CovarianceEstimatorsContainerType;

  MeanEstimatorsContainerType::Pointer meanEstimatorsContainer = MeanEstimatorsContainerType::New();
  CovarianceEstimatorsContainerType::Pointer covarianceEstimatorsContainer = CovarianceEstimatorsContainerType::New();

  meanEstimatorsContainer->Reserve( numberOfClasses );
  covarianceEstimatorsContainer->Reserve( numberOfClasses );
	
	typedef itk::Statistics::DensityFunction<MeasurementVectorType>					MembershipFunctionType;
	typedef itk::VectorContainer< unsigned int, MembershipFunctionType::Pointer> 			MembershipFunctionContainerType;

  MembershipFunctionContainerType::Pointer MembershipFunctionContainer = MembershipFunctionContainerType::New();
  MembershipFunctionContainer->Initialize(); // Clear elements
  MembershipFunctionContainer->Reserve( numberOfClasses );
  

  for (int i= 0; i<numberOfClasses; i++ )
  {
    meanEstimatorsContainer->InsertElement( i, new GaussianMembershipFunctionType::MeanType(1) );
    covarianceEstimatorsContainer->InsertElement( i, new GaussianMembershipFunctionType::CovarianceType() );
    GaussianMembershipFunctionType::MeanType *means = 
          dynamic_cast< GaussianMembershipFunctionType::MeanType * > ((meanEstimators[i]->GetOutput()));
    GaussianMembershipFunctionType::CovarianceType* covariances = 
          const_cast< GaussianMembershipFunctionType::CovarianceType * > ((covarianceEstimators[i]->GetOutput()));  
    means->SetSize( numberOfImages );
    covariances->SetSize( numberOfImages, numberOfImages );


    GaussianMembershipFunctionType::Pointer gaussianDensityFunction = GaussianMembershipFunctionType::New();
    gaussianDensityFunction->SetMean( meanEstimators[i]->GetOutput());
    gaussianDensityFunction->SetCovariance( covarianceEstimators[i]->GetOutput());
    	 try
	{
		gaussianDensityFunction->SetMeasurementVectorSize( numberOfImages );
	}
	catch( itk::ExceptionObject exp )
	{
		debugStream << "Exception caught !" << std::endl;
		debugStream << exp << std::endl;
	}
	
    MembershipFunctionContainer->InsertElement(i, dynamic_cast< MembershipFunctionType * >( gaussianDensityFunction.GetPointer()));
  }

  // End of Creating Gaussian Membership Functions.
  //------------------------------------------------------------------------------------  

	time[4] = clock() - time[3];
	debugStream <<"Membership Function Time elapsed: "<<time[4]/CLOCKS_PER_SEC << std::endl;


  //------------------------------------------------------------------------------------  
  // Send to Bayesian Classifier 
	typedef itk::BayesianClassifierInitializationVectorImageFilter<VectorImageType, 
						FloatPixelType>													BayesianClassifierInitializationType;

  BayesianClassifierInitializationType::Pointer initclassifier = BayesianClassifierInitializationType::New();
  initclassifier->SetNumberOfClasses( numberOfClasses );
  initclassifier->SetMembershipFunctions( MembershipFunctionContainer );
  initclassifier->SetInput( anatImages );
  try
  {
    initclassifier->Update();
  }
  catch( itk::ExceptionObject exp )
  {
    std::cerr << "Exception caught !" << std::endl;
    std::cerr << exp << std::endl;
  }

	time[5] = clock() - time[4];
	debugStream <<"Initial Bayesian Classifier Update Time elapsed: "<<time[5]/CLOCKS_PER_SEC << std::endl;


  FloatVectorImageType::Pointer gvectorimage = FloatVectorImageType::New();
  gvectorimage = initclassifier->GetOutput();
  //debugStream << "gvectorimage"<<std::endl;
  //gvectorimage->Print(debugStream);

 


 typedef itk::BayesianClassifierUIImageFilter< FloatVectorImageType, 
						FloatPixelType, FloatPixelType, FloatPixelType >							BayesianImageClassifierType;

  BayesianImageClassifierType::Pointer bayesianclassifier = BayesianImageClassifierType::New();
  bayesianclassifier->SetInput(0, gvectorimage);
 
	/*bayesianclassifier->SetInput(1, classImages);
	bayesianclassifier->SetUserProvidedPriors(true);*/
 
  try
  {
		bayesianclassifier->Update();
  }
  catch( itk::ExceptionObject exp )
  {
		std::cerr << "Exception caught !" << std::endl;
		std::cerr << exp << std::endl;
  }
	time[6] = clock() - time[5];
	debugStream <<"Bayesian Classifier Update Time elapsed: "<<time[6]/CLOCKS_PER_SEC << std::endl;
  //debugStream << "Bayesian Classifier Filter" <<std::endl;
  //bayesianclassifier->Print(debugStream);
  // End of Sending to Bayesian Classifier
  //------------------------------------------------------------------------------------
  typedef itk::Image<FloatPixelType,3>			RegImageType;
  typedef itk::OrientImageFilter<RegImageType, ImageType>  OrientFilterType;
 
  typedef itk::CastImageFilter<RegImageType, ImageType>  RegFilterType;

  RegFilterType::Pointer castFilter = RegFilterType::New();
  castFilter->SetInput(bayesianclassifier->GetOutput(0));
  castFilter->Update();

 // OrientFilterType::Pointer orientFilter = OrientFilterType::New();
 // 
	//debugStream << "*" <<std::endl;
	//orientFilter->SetInput(bayesianclassifier->GetOutput(0));
	//orientFilter->SetDesiredCoordinateDirection(brainMask->GetDirection());
	//debugStream << "*" <<std::endl;
	//
	//try{
	//orientFilter->Update();
	//}
	//catch(itk::ExceptionObject exp)
	//{
	//	debugStream <<exp<<std::endl;
	//}

	ImageType::Pointer temp = ImageType::New();
	temp = castFilter->GetOutput(); //bayesianclassifier->GetOutput(0); //orientFilter->GetOutput();
	debugStream << "Temp Image" <<std::endl;
	temp->Print(debugStream);

  //------------------------------------------------------------------------------------
  // Output the Classification  

  typedef itk::ImageFileWriter<ImageType>											WriterType;
  typedef itk::ImageFileWriter<RegImageType>										RegWriterType;
 // 
  //WriterType::Pointer writer = WriterType::New();
  //writer->SetInput(temp); //bayesianclassifier->GetOutput(0));
  //writer->SetFileName( "E:\\Development\\output\\bayesianClassifiedImageOriented.nii" );
  //debugStream << "Attempting to Write Oriented Classified Image" << std::endl;  
  //try
  //{
  //  writer->Update();
  //
  //}	
  //catch(itk::ExceptionObject exp)
  //{
		//debugStream <<exp<<std::endl;
		//debugStream << "Failed" <<std::endl;
  //}

	vtkKWImage * outputImage = vtkKWImage::New();
	outputImage->SetITKImageBase(temp);
	debugStream << "output Image" <<std::endl;
	outputImage->Print(debugStream);

	ImageType::Pointer temp2= ImageType::New();
	temp2=GetITK(outputImage);
	temp2->Print(debugStream);

		
	//RegWriterType::Pointer writerreg = RegWriterType::New();
	//writerreg->SetInput(bayesianclassifier->GetOutput(0)); 
	//writerreg->SetFileName( "E:\\Development\\output\\bayesianClassifiedImage.nii" );
	//debugStream << "Attempting to Write Classified Image" << std::endl;  
	//
	//try
	//{
	//	writerreg->Update();
 //    	}
	//catch(itk::ExceptionObject exp)
	//{
	//	debugStream <<exp<<std::endl;
	//	debugStream << "Failed" <<std::endl;
	//}
    debugStream << "done" <<std::endl;
    debugStream.close();

	time[7] = clock() - time[0];
	debugStream <<"Total Time elapsed: "<<time[7]/CLOCKS_PER_SEC << std::endl;
	return outputImage;

  // End of Output Classification
  //------------------------------------------------------------------------------------
  }	
 
PointSetType::Pointer CreateTrainingPoints ( ImageType::Pointer maskImage, PixelType labelValue )
{
	/*std::ofstream debugStream;
    debugStream.open(".\\output\\trainingpoints.txt");
	debugStream << "*"<<std::endl;*/

	PointSetType::Pointer  points = PointSetType::New();
	PointSetType::PointType readPoint;
	
	typedef itk::ImageRegionConstIteratorWithIndex<ImageType>					ConstIteratorType;

	ConstIteratorType maskIt( maskImage, maskImage->GetRequestedRegion() );
        maskIt.GoToBegin();
        int indexPoint = 0;

        while ( !maskIt.IsAtEnd() )
        {
			
                if ( maskIt.Value() == labelValue )
                {
					//debugStream <<"Index #"<<indexPoint<<": ";
					ImageType::IndexType index = maskIt.GetIndex();    
					readPoint[0] = index[0];
					//debugStream << index[0] << " ";
  	                readPoint[1] = index[1];
					//debugStream << index[1] << " ";
  	                readPoint[2] = index[2];
					//debugStream << index[2] << std::endl;
  	                points->SetPoint( indexPoint , readPoint );
  	                ++indexPoint;
                }
                ++maskIt;
        }

	//debugStream << "done" <<std::endl;
	//debugStream.close();
	return points;
}


void GetClassTraining (PointSetType::Pointer points, VectorImageType::Pointer initialimages, 
			SampleType::Pointer training, std::vector< ClassSampleType::Pointer > classSamples, 
                        int classType, int numberofimages)
{
		typedef PointSetType::PointsContainer											PointsContainer;
	PointsContainer::Pointer  pointsCon = points->GetPoints(); 

		typedef PointsContainer::Iterator												PointsIterator;
	PointsIterator  conIterator = pointsCon->Begin(); 
	PointsIterator endCon = pointsCon->End();
	
	PointSetType::PointType pp;

		typedef itk::VariableLengthVector<PixelType>									MeasurementVectorType;
	MeasurementVectorType mv;
	mv.SetSize(numberofimages);
	
	ImageType::IndexType index;

	SampleType::InstanceIdentifier id = 0UL;
	int iter = 0;

	while( conIterator != endCon ) 
	{
		bool pointExists = points->GetPoint( iter , & pp );
		if (pointExists)
		{
			index[0] = static_cast<int> (pp[0]);
			index[1] = static_cast<int> (pp[1]);
			index[2] = static_cast<int> (pp[2]);

			mv = initialimages->GetPixel( index );
			training->SetMeasurementVectorSize(numberofimages);
			training->PushBack(mv);
			training->SetMeasurementVector( id, mv);
			classSamples[classType]->AddInstance( id );
			++id;
			++iter;
		}
		++conIterator; 
        }
}

ImageType::Pointer BRAINSRandomPlugsCSI(ImageType::Pointer labelImage)
{

    std::ofstream debugStream;
	debugStream.open("E:\\Development\\output\\randomplugs.txt");
	debugStream <<"*"<<std::endl;

  int plugScarcityOnePartPer = 10000;
  int numberOfPlugs = 100;

	typedef itk::LabelStatisticsImageFilter< ImageType, ImageType >		LabelStatisticsFilterType;
  LabelStatisticsFilterType::Pointer statisticsFilter = LabelStatisticsFilterType::New();

  statisticsFilter->SetInput( labelImage );
  statisticsFilter->SetLabelInput( labelImage );
  statisticsFilter->Update();

  ImageType::Pointer plugLabelImage = ImageType::New();
  plugLabelImage->SetRegions( labelImage->GetLargestPossibleRegion() );
  plugLabelImage->SetSpacing( labelImage->GetSpacing() );
  plugLabelImage->SetDirection( labelImage->GetDirection() );
  plugLabelImage->SetOrigin( labelImage->GetOrigin() );
  plugLabelImage->Allocate();
  plugLabelImage->FillBuffer( 0 );

  for (int i=1; i<4; i++)
  {
	ImageType::RegionType labelRegion = statisticsFilter->GetRegion( static_cast<signed short> ( i ) );

	itk::ImageRandomNonRepeatingConstIteratorWithIndex<ImageType> it( labelImage, labelRegion );

	debugStream <<"Region Size: "<<labelRegion.GetSize()<<std::endl;

	int tissuePlugs = 0;
	it.SetNumberOfSamples(numberOfPlugs*plugScarcityOnePartPer);
	it.GoToBegin();

    while( !it.IsAtEnd() )
    {
      if ( it.Get() == i )  // The labelRegion was a bounding box, so test the label pixel each time.
      {
        // Set Output Image
		debugStream<<"Tissue plug: "<<tissuePlugs<<" Index:"<<it.GetIndex()<<std::endl;
        plugLabelImage->SetPixel(it.GetIndex(), static_cast<unsigned char> (i));
        if ( tissuePlugs == numberOfPlugs ) break;
        tissuePlugs++;
      }
      ++it;  // here it jumps to another random position inside the region
    }
    if (tissuePlugs < numberOfPlugs)
    {
      debugStream  << "Malfunction:  Sampling label " << i << ", found only " << tissuePlugs;
	  debugStream << " plugs when seeking " << numberOfPlugs << " plugs." << std::endl;
      debugStream  << "^^^^^^^^^^^   Perhaps the label has too few voxels for an expectation";
      debugStream  << " of greater than one part per " << plugScarcityOnePartPer << "." << std::endl;
    }
  }

	debugStream <<"*"<<std::endl;
	debugStream.close();

  return plugLabelImage;
}


/**************************************************************************************************************************/
ImageType::Pointer GetITK(vtkKWImage * image)
{	
	ImageType::Pointer output = ImageType::New();

	const ImageType * testImage = static_cast< const ImageType * >(image->GetITKImageBase() );
	output = const_cast<ImageType *>(testImage);
	
	return output;
}
/**************************************************************************************************************************/