#ifndef CSIDisplay_h
#define CSIDisplay_h

#define _CRT_SECURE_NO_WARNINGS

#include "vtkKWRenderWidget.h"
#include "itkImage.h"

#include "ImageProcessing.h"
#include "vtkStructuredGrid.h"
//#include "itkImageToVTKImageFilterSpect.h"

#include "vtkKWImage.h"
#include "vtkImagePlaneWidget.h"
#include "vtkKWCheckButton.h"

#include "vtkCellPicker.h"
#include "PickCellCallBack.h"

#include "CSIgrid.h"

#include <vtkCollectionIterator.h>

typedef signed short															PixelType;
typedef itk::Image<PixelType, 3>												ImageType;


class CSIDisplay
{
public:

	CSIDisplay();
	~CSIDisplay();

	void DisplayGrids();
	void DisplayMasks();
	void DisplayImage();
	void DisplayMetabolites();

	void CalcMetabRange();
	void CalcCRLBRange();

	void DisplayPickedCells(int);

	void SetImage( vtkImageData *);
	void SetImage( vtkKWImage * );

	void SetMetabolite( const char *);
	void SetRatioState( int);

	double * GetMetabWholeRange();
	double * GetMetabRange();
	double * GetCRLBRange();
	void SetMetabWholeRange(double *);
	void SetMetabRange(double *);
	void SetCRLBRange(double,double);
	void SetMask( vtkKWImage * );
	void SetGrid( vtkStructuredGrid *);
	void SetCellPickerCallback( PickCellCallBack * );
	void PickingOn();
	void PickingOff();

	void SetComponent(int);
	int GetComponent();

	void AddSpectroscopy( CSIgrid *);
	void RemoveSpectroscopy(char *);
	std::vector<int> GetPickedCells();

	double Median(std::vector<double> *);
	double STDev(std::vector<double> *);

	void Update();

	vtkKWRenderWidget						*RenderWidget;
//itkImageToVTKImageFilterSpect			*ITKImagetoVTK;

	vtkImagePlaneWidget						*PlaneX;			
	vtkImagePlaneWidget						*PlaneY;
	vtkImagePlaneWidget						*PlaneZ;
	CSIgrid									*Spectroscopy;

	vtkActor *								GridActor;
	
private:

	//void ImageViewer( ImageType::Pointer );
	void ImageViewer( vtkImageData * );
	ImageType::Pointer GetITK(vtkKWImage *);
	void PickEvent();

	ImageType::Pointer						Image;
	vtkImageData *							Mask;
	vtkStructuredGrid*						Grid;
	vtkImageData *							vtkImage;
	vtkKWImage *							KWImage;
	char *									Metabolite;
	int										UseRatio;
	double									*MetabWholeRange;
	double									*MetabRange;
	double									*CRLBRange;

	int										Component;
	vtkKWCheckButton						*RatioButton;
	vtkCellPicker							*Picker;
	vtkCellPicker							*SpectPicker;

	std::vector<vtkStructuredGrid *>		PickedCells;
	std::vector<int>						PickedCellIDs;

	PickCellCallBack *						Pickcallback;

	vtkActorCollection						*PickActorCollection;

};

#endif