#ifndef __CSIgrid_h
#define __CSIgrid_h

#include "SiemensRdaReader.h"
#include "vtkPoints.h"
#include "itkMatrix.h"
#include "itkImage.h"
#include "vtkStructuredGrid.h"
#include "vtkTransformFilter.h"
#include "vtkTransform.h"
#include "vtkActorCollection.h"
#include "vtkIdList.h"
#include "vtkCell.h"
#include "vtkGeometryFilter.h"
#include "vtkPolyDataMapper.h"
#include "vtkProperty.h"
#include "vtkTransform.h"
#include "vtkTransformPolyDataFilter.h"
#include "vtkActor.h"
#include "itkVersorRigid3DTransform.h"
//#include "vtkUnstructuredGridToPolyDataFilter.h"
//#include "vtkMatrix4x4.h"


typedef itk::Matrix<double>													MatrixType;
typedef signed short														PixelType;
typedef itk::Image<PixelType, 3>											ImageType;

//typedef itk::VersorRigid3DTransform<double>										TransformType;
//typedef TransformType::Pointer			TransformTypePointer;
//typedef vtkTransformFilter<

class CSIgrid
{
public:

	CSIgrid();
	~CSIgrid();

	void SetFileName(char *);
	void SetDisplayName(char *);
	char *GetName();
	void ReadHeader();
	void Update();

	void CreateActors();
	vtkActorCollection * GetActorCollection();

	void AddPickedCell( int );
	void AddPickedCells( std::vector<int> );
	void RemovePickedCell( int );

	//void SetSpacing();
	//void SetPosition();
	//void SetRowVector();
	//void SetColVector();

	double * GetSpacing();
	double * GetPosition();
	double * GetRowVector();
	double * GetColVector();
	double * GetGridCenter();
	double * GetFOV();

	std::vector<int>	GetPickedCells();

	MatrixType GetDirCos();

	vtkStructuredGrid * GetOutput();

	vtkActor * GenerateCell(int);

	void Shift(double);
	//void RigidMotion(TransformTypePointer);

	vtkMatrix4x4 * GetTransformMatrix();

private:

	char *											DisplayName;
	
	double											*spacing;
	double											*position;
	double											*rowVector;
	double											*colVector;
	double											*q;
	double											*FOV;
	double											*VOI;
	double											*positionVector;
	vtkStructuredGrid								*OutputGrid;
	double											*VoiPosition;

	int												*dimensions;

	MatrixType										GridDirCos;

	double											*GridOrigin;

	SiemensRdaReader								*rdaHdr;

	vtkTransform									*ChemicalShift;
	vtkMatrix4x4									*GridMatrix;

	std::vector<int>								PickedCellIDs;

	vtkActorCollection								*CellCollection;

};

#endif
