#ifndef GridCalculation_cxx
#define GridCalculation_cxx

#include "GridCalculation.h"
#include "vtkCellData.h"
#include "itkImageRegionConstIterator.h"
#include "vtkDoubleArray.h"
#include "itkImageFileWriter.h"
#include "vtkXMLStructuredGridWriter.h"

#include "time.h"

GridCalculation::GridCalculation()
{
	//Set Initial Conditions here
	this->Image = NULL;
	this->T1Map = NULL;
	this->T2Map = NULL;
	this->WhiteMap = NULL;
	this->CSFMap = NULL;
	this->GreyMap = NULL;
	this->BGMap = NULL;

}

void GridCalculation::SetImage(vtkKWImage * image)
{
	// get the image:
	this->Image = ImageType::New();
	if (image)
	{
		this->Image = GetITK(image);
		
		ImageType::SpacingType imageSpacing;
		imageSpacing = this->Image->GetSpacing();
		this->VoxelVolume = imageSpacing[0] * imageSpacing[1] * imageSpacing[2];
	}
}
void GridCalculation::SetT1Map(vtkKWImage * image)
{
	// get the image:
	this->T1Map = ImageType::New();
	this->T1Map = GetITK(image); 
	
		ImageType::SpacingType imageSpacing;
		imageSpacing = this->T1Map->GetSpacing();
		this->VoxelVolume = imageSpacing[0] * imageSpacing[1] * imageSpacing[2];
}
void GridCalculation::SetT2Map(vtkKWImage * image)
{
	// get the image:
	this->T2Map = ImageType::New();
	this->T2Map = GetITK(image);
}
void GridCalculation::SetWhiteMap(vtkKWImage * image)
{
	// get the image:
	this->WhiteMap = ImageType::New();
	this->WhiteMap = GetITK(image);

}
void GridCalculation::SetGreyMap(vtkKWImage * image)
{
	// get the image:
	this->GreyMap = ImageType::New();
	this->GreyMap = GetITK(image);
	
		ImageType::SpacingType imageSpacing;
		imageSpacing = this->GreyMap->GetSpacing();
		this->VoxelVolume = imageSpacing[0] * imageSpacing[1] * imageSpacing[2];
	

}
void GridCalculation::SetBGMap(vtkKWImage * image)
{
	// get the image:
	this->BGMap = ImageType::New();
	this->BGMap = GetITK(image);

}
void GridCalculation::SetCSFMap(vtkKWImage * image)
{
	// get the image:
	this->CSFMap = ImageType::New();
	this->CSFMap = GetITK(image);

}
void GridCalculation::SetGrid(vtkStructuredGrid * grid)
{

	this->Grid = grid;
	this->numCells = this->Grid->GetNumberOfCells();
	
}
void GridCalculation::SetName(char * name)
{
	this->Name = "";
	if (name) this->Name = name;
}
vtkDataArray * GridCalculation::GetOutput()
{
	return this->Grid->GetCellData()->GetArray(this->Name);
}

vtkStructuredGrid * GridCalculation::GetOutputGrid()
{
	return this->Grid; 
}

void GridCalculation::Calculate()
{
	std::ofstream percentStream;
	percentStream.open("E:\\Development\\output\\voxelPercent.txt");
	clock_t time, time0;
	time = clock();
	time0 = clock();

	int outside = 0;
	int subId = 0;
	double  pcoords[3];
	double tol2=0;
	double weights[8];
	double x[3];

	vtkIdType cellId = 0;
	double whiteValue = 0;
	double greyValue = 0;
	double CSFValue = 0;
	double BGValue = 0;
	double T1Value = 0;
	double T2Value = 0;

	double cellValue = 0;

	for (int j=0; j < 8; j++)
	{
        weights[j] = 0.5;
	}

	int *volume = new int[this->numCells];	
	
	for (int i = 0; i < this->numCells; i++)
	{
		volume[i]=0;
	}
	/****************************************************************/
	//Create array and set to 0.

	int numTissueClasses = 7; //T1,T2,BG,W,G,CSF,Volume

	vtkDoubleArray * partialVolume = vtkDoubleArray::New();
	partialVolume->SetNumberOfComponents(numTissueClasses);
	partialVolume->SetNumberOfTuples(numCells);
	partialVolume->SetName(this->Name);
	
	for (int a = 0; a < numTissueClasses; a++)
	{
		partialVolume->FillComponent(a,0);
	}


	ImageType::RegionType			imageRegion = this->Image->GetLargestPossibleRegion();
	typedef itk::ImageRegionConstIterator<ImageType >						ConstIteratorType;
	ConstIteratorType tissueIt (this->Image, imageRegion);

	//typedef itk::ImageFileWriter<ImageType> WriterType;
	//WriterType::Pointer writer = WriterType::New();
	//writer->SetFileName("E://Development/output/calcTest.nii");
	//writer->SetInput(this->Image);
	//writer->Update();

	ImageType::IndexType index;
	ImageType::PointType point;

	time0 = clock();
	/****************************************************************/
	signed short tissueClass = 0;

	for ( tissueIt.GoToBegin(); !tissueIt.IsAtEnd(); ++tissueIt)
	{
		index = tissueIt.GetIndex();
		tissueClass = tissueIt.Get();  //Gets value [0,3] based on what tissue it is.
	
		this->Image->TransformIndexToPhysicalPoint(index, point);
		x[0] = static_cast<double>(point[0]);
		x[1] = -static_cast<double>(point[1]);
		x[2] = static_cast<double>(point[2]);

		cellId = this->Grid->FindCell( x, NULL , cellId, tol2, subId, pcoords, &weights[0]);
		double * tuple;
		
		if (cellId >= 0 )
		{
			tuple = partialVolume->GetTuple(cellId);
			tuple[tissueClass]++;
			partialVolume->SetTuple(cellId, tuple);
			volume[static_cast<int>(cellId)]++;
		}
		else
		{
			outside++;
		}
	}
	time = clock();
	//percentStream <<"FindCell Time elapsed: "<<(time-time0)*1000/CLOCKS_PER_SEC << std::endl;
	percentStream <<"CellID BG Grey White CSF Volume"<<endl;
	double * tupleOUT;
	for ( cellId = 0; cellId < numCells; cellId++ )
	{
		tupleOUT = partialVolume->GetTuple(cellId);
		percentStream <<cellId <<" "<<tupleOUT[0]<<" "<<tupleOUT[1]<<" "<<tupleOUT[2]<<" "<<tupleOUT[3]<<" "<< volume[static_cast<int>(cellId)] << endl;
	}
	
	this->Grid->GetCellData()->AddArray(partialVolume);
	/****************************************************************
	vtkXMLStructuredGridWriter * vtkWriter = vtkXMLStructuredGridWriter::New();
	vtkWriter->SetInput(this->Grid);
	vtkWriter->SetFileName("E:\\Development\\output\\PVGrid2.vts");
	vtkWriter->Update(); 
	/****************************************************************/
	percentStream.close();
}
/**************************************************************************************************************************/

void GridCalculation::ParameterCalculate()
{
	std::ofstream percentStream;
	percentStream.open("E:/Development/output/partialVolume.csv");
	
	int outside = 0;
	int subId = 0;
	double  pcoords[3];
	double tol2=0;
	double weights[8];
	double x[3];

	vtkIdType cellId = 0;
	ImageType::PixelType whiteValue = 0;
	ImageType::PixelType greyValue = 0;
	ImageType::PixelType CSFValue = 0;
	ImageType::PixelType BGValue = 0;
//	ImageType::PixelType t1Value = 0;
//	ImageType::PixelType t2Value = 0;

	double cellValue = 0;

	for (int j=0; j < 8; j++)
	{
        weights[j] = 0.5;
	}

	int *volume = new int[this->numCells];	
	
	for (int i = 0; i < this->numCells; i++)
	{
		volume[i]=0;
	}
	/****************************************************************/
	//Create array and set to 0.

	int numTissueClasses = 7; //T1,T2,BG,White,Grey,CSF, Volume

	vtkDoubleArray * partialVolume = vtkDoubleArray::New();
	partialVolume->SetNumberOfComponents(numTissueClasses);
	partialVolume->SetNumberOfTuples(numCells);
	partialVolume->SetName(this->Name);
	
	for (int a = 0; a < numTissueClasses; a++)
	{
		partialVolume->FillComponent(a,0);
	}

	if (this->GreyMap)
	{

		ImageType::RegionType			imageRegion = this->GreyMap->GetLargestPossibleRegion();

		typedef itk::ImageRegionConstIterator<ImageType >						ConstIteratorType;
		ConstIteratorType bgIt (this->BGMap, imageRegion);
		ConstIteratorType whiteIt (this->WhiteMap, imageRegion);
		ConstIteratorType greyIt (this->GreyMap, imageRegion);
		ConstIteratorType csfIt (this->CSFMap, imageRegion);
		
		whiteIt.GoToBegin();
		csfIt.GoToBegin();
		bgIt.GoToBegin();

		//ConstIteratorType t1It(this->T1Map, imageRegion);
		//ConstIteratorType t2It(this->T2Map, imageRegion);	
		//
		//t1It.GoToBegin();
		//t2It.GoToBegin();
		

		ImageType::IndexType index;
		ImageType::PointType point;

		/****************************************************************/
		signed short tissueClass = 0;

		vtkCell * cell = NULL;

		for ( greyIt.GoToBegin(); !greyIt.IsAtEnd(); ++greyIt, ++whiteIt, ++csfIt, ++bgIt)
		{
			index = greyIt.GetIndex();
			
			whiteValue= 0;  
			greyValue= 0;
			CSFValue= 0;  
			BGValue= 0;
			//t1Value=0;
			//t2Value=0;

			whiteValue= whiteIt.Get();  //Get Parameters
			greyValue= greyIt.Get();
			CSFValue= csfIt.Get();  //Get Parameters
			BGValue= bgIt.Get();

			//if (this->T1Map)
			//{
			//	t1Value= t1It.Get();  //Get Parameters
			//	t2Value= t2It.Get();
			//	++t1It;
			//	++t2It;
			//}	

			this->GreyMap->TransformIndexToPhysicalPoint(index, point);

			x[0] = static_cast<double>(point[0]);
			x[1] = static_cast<double>(point[1]);
			x[2] = static_cast<double>(point[2]);

			cellId = this->Grid->FindCell( x, cell , cellId, tol2, subId, pcoords, &weights[0]);
			
			double * tuple;
			
			if (cellId >= 0 )
			{
				tuple = partialVolume->GetTuple(cellId);
				//tuple[0]= tuple[0]+t1Value;
				//tuple[1]= tuple[1]+t2Value;
				tuple[0]= tuple[0]+BGValue;
				tuple[1]= tuple[1]+CSFValue;
				tuple[2]= tuple[2]+greyValue;
				tuple[3]= tuple[3]+whiteValue;
				volume[static_cast<int>(cellId)]++;
				tuple[4]= volume[static_cast<int>(cellId)];
				
				cell = this->Grid->GetCell(cellId);
				partialVolume->SetTuple(cellId, tuple);
			
			}
			else
			{
				outside++;
			}

		}
	}
	

	percentStream <<"CellID, BG, CSF, Grey, White, Volume"<<endl;
	double * tupleOUT;
	
	for ( cellId = 0; cellId < numCells; cellId++ )
	{
		tupleOUT = partialVolume->GetTuple(cellId);
		percentStream <<cellId <<","<<tupleOUT[0]<<","<<tupleOUT[1]<<","<<tupleOUT[2]<<","<<tupleOUT[3]<<","<<tupleOUT[4]<< endl;
	}
	
	this->Grid->GetCellData()->AddArray(partialVolume);
	/****************************************************************/
	vtkXMLStructuredGridWriter * vtkWriter = vtkXMLStructuredGridWriter::New();
	vtkWriter->SetInput(this->Grid);
	vtkWriter->SetFileName("E:\\Development\\output\\PVGrid2.vts");
	vtkWriter->Update(); 
	/****************************************************************/
	percentStream.close();
}
/**************************************************************************************************************************/
ImageType::Pointer GridCalculation::GetITK(vtkKWImage * image)
{	
	ImageType::Pointer output = ImageType::New();

	const ImageType * testImage = static_cast< const ImageType * >(image->GetITKImageBase() );
	if (testImage)
	{
		output = const_cast<ImageType *>(testImage);
	}
	else 
	{
		output = NULL;
	}
	return output;
}
/**************************************************************************************************************************/
#endif