#include "LCModelReader.h"
#include <iostream>
using namespace std;
#include <sstream>
#include <fstream>
#include <string.h>
#include "vtkFieldData.h"

#include "vtkSmartPointer.h"

/****************************************************************************/
LCModelReader::LCModelReader()
{
	this->numCells = 0;
	this->Size = new int[3];
	this->MetaboliteData = vtkDoubleArray::New();
	this->MetaboliteNames = vtkStringArray::New();
}
/****************************************************************************/
LCModelReader::~LCModelReader()
{
	delete [] this->Size;
	//Deconstructor
}
/****************************************************************************/
void LCModelReader::Print()
{
	std::ofstream print;
	print.open("E:\\Development\\output\\lcmodel.txt");
	for (int i = 0; i < this->numCells; i++)
	{
		double * tuple = this->MetaboliteData->GetTuple(i);
		print <<tuple[0]<<" "<<tuple[1]<<" "<<tuple[2]<<std::endl;
	}

	print.close();
}
/****************************************************************************/
void LCModelReader::SetGridSize(int * size)
{
	this->Size[0] = size[0];
	this->Size[1] = size[1];
	this->Size[2] = size[2];
	this->numCells = this->Size[0]*this->Size[1]*this->Size[2];

	//std::cout <<size[0]<<" "<<size[1]<<" "<<size[2]<<std::endl;
	//std::cout<<"numCells: "<<this->numCells<<std::endl;
}
/****************************************************************************/
vtkDoubleArray * LCModelReader::GetOutputArray(string name)
{
	vtkDoubleArray * output = vtkDoubleArray::New();
	output->SetNumberOfComponents(4);
	output->SetNumberOfTuples(this->numCells);
	output->SetName(name.c_str());
		
	int numNames = this->MetaboliteNames->GetNumberOfValues();
	
	vtkIdType column = this->MetaboliteNames->LookupValue(name);
	
	double * tuple;
	for (int i = 0; i < this->numCells; i++)
	{
		tuple = new double[3];

		for (int j = 0; j < 3; j++)
		{
			tuple[j] =this->MetaboliteData->GetComponent(i,column*3+2+j);	
		}
		output->SetTuple(i,tuple);		
	}
	delete[] tuple;
 	return output;
}
/****************************************************************************/
vtkStringArray * LCModelReader::GetMetaboliteNames()
{
 	return this->MetaboliteNames;
}
/****************************************************************************/
void LCModelReader::Read(std::string filename)
{
	/****************************************************************************/
	std::ifstream filestr;
    filestr.open(filename.c_str(), std::ifstream::in ); 
	/****************************************************************************/
	if(!filestr.is_open())
    {
        std::cerr << "Could not open file "
            << filename << std::endl;
        return;
    }
	
	int currentColumn = 0;	
	int row = 0;
	int col = 0;
	
	string csvLine, csvElement, csvElement2;
	
	getline(filestr, csvLine);
	stringstream csvStream(csvLine);
	/****************************************************************************/

	//this->MetaboliteNames->SetNumberOfTuples(this->numCells);
	/****************************************************************************/
	while( getline(csvStream, csvElement, ',') )
	{
		//Remove leading whitespace;
		while(isspace(csvElement[0]))
		{
			csvElement.erase(0,1);
		}
		//this->MetaboliteNames->InsertNextValue(csvElement);
		if ( col % 3 == 2 ){this->MetaboliteNames->InsertNextValue(csvElement);}
		col++;	
	}
	/****************************************************************************/
	row++;

	int numMetaboliteFields = col;

	this->MetaboliteData->SetNumberOfComponents(numMetaboliteFields ); 
	this->MetaboliteData->SetNumberOfTuples(this->numCells);  //Make an input variable
		
	for (int a = 0; a < numMetaboliteFields; a++)
	{
		//this->MetaboliteConc->SetName(names->GetValue(a));
		this->MetaboliteData->FillComponent(a,0);
	}
	
	/****************************************************************************/
	vtkIdType cellId;
	
	while( getline(filestr, csvLine) )
	{
		
		stringstream csvStream(csvLine);
		col = 0;
		
		vtkSmartPointer<vtkDoubleArray> line = vtkSmartPointer<vtkDoubleArray>::New();
		line->SetNumberOfValues(numMetaboliteFields);
		while( getline(csvStream, csvElement, ',') )
		{
			line->SetValue(col,atof(csvElement.c_str()));
			col++;
		}
		
		cellId = (line->GetValue(1) - 1) * this->Size[0] + (line->GetValue(0) -1);
		
		double * tuple = new double[col];

		for (int i = 0; i < col; i++)
		{
			tuple[i] = line->GetValue(i) ;	
		}
			
		this->MetaboliteData->SetTuple(cellId, tuple);
		
		row++;
		delete[] tuple;
		
	}
	/***************************************************************************/
	filestr.close();
	
}
/****************************************************************************/
