#ifndef LCModelReader_h
#define LCModelReader_h
#include <fstream>
using std::string;
#include "vtkStringArray.h"
#include "vtkDoubleArray.h"
#include "string.h"


class LCModelReader
{
public:

	LCModelReader();
	~LCModelReader();

	void Read(string);
	void Print();
	vtkDoubleArray * GetOutputArray(string);
	void SetGridSize(int*);
	vtkStringArray * GetMetaboliteNames();
	
	//vtkStringArray* GetFieldNames();

private:
	vtkStringArray						*MetaboliteNames;
	vtkDoubleArray						*MetaboliteData;
	vtkIdType							numCells;
	int *								Size;
	//int maxRow, maxCol;
};

#endif
