#ifndef __LoadSEMCImages_h
#define __LoadSEMCImages_h
#define _CRT_SECURE_NO_WARNINGS

#include <string>
#include <vector>

#include "itkImageFileWriter.h"
#include "itkImage.h"
#include <itkDICOMSeriesFileNames.h>
#include "itkImageSeriesReader.h"
#include "itkGDCMImageIO.h"
#include "itkGDCMSeriesFileNames.h"
#include "itkThresholdImageFilter.h"
#include "itkMRT2ParameterMap3DImageFilter.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkCastImageFilter.h"
#include "vtkKWImage.h"

typedef itk::Image<signed short, 3> ImageType;

typedef itk::Image< signed short, 3 > ImageType;
//typedef itk::Image< float, 3> FloatImageType;

typedef itk::ThresholdImageFilter<ImageType >    ThresholdImageFilterType;
//typedef itk::CastImageFilter<ImageType,FloatImageType> CastImageFilterType;
typedef itk::ImageFileWriter< ImageType >     WriterType;
typedef itk::MRT2ParameterMap3DImageFilter< ImageType::PixelType > MRT2ParameterMap3DImageFilterType;

typedef itk::VectorIndexSelectionCastImageFilter< MRT2ParameterMap3DImageFilterType::OutputImageType, ImageType >  
	VectorIndexSelectionCastImageFilterType;  
  
class LoadSEMCImages 
{
	public:
		LoadSEMCImages();
		~LoadSEMCImages();		

		void SetDirectory( const std::string );
		std::string GetDirectory();

		int GetNumberOfEchoes();
		void SetNumberOfEchoes(int);
		
		vtkKWImage * GetImage(int);
		std::vector<vtkKWImage *> GetAllImages();
		std::vector<double> GetEchoTimes();

		void SetThreshold(short);
		void SetMaxT2Time(double);
		void SetAlgorithm(int);

		vtkKWImage * GetT2Map();
		vtkKWImage * GetAMap();
		vtkKWImage * GetCMap();
		vtkKWImage * GetErrorMap();

		
		void WriteEchoImage(int);

		void Update();
		void Load();

	private:
		std::vector<std::string>			ReadDirectoryFileNames(std::string);
		std::string							dirName;
		std::vector<ImageType::Pointer>		EchoImages;
		ImageType::Pointer					OutputImage;
		int									NumEchoes;
		std::vector<double>					EchoTimes;
		ImageType::Pointer					T2Map;
		ImageType::Pointer					AMap;
		ImageType::Pointer					CMap;
		ImageType::Pointer					ErrorMap;
		short								Threshold;
		double								MaxT2Time;
		int									Algorithm;

};

#endif