#ifndef SiemensRdaReader_h
#define SiemensRdaReader_h

#include <map>
#include <string>
#include <exception>
using std::exception;
#include <vector>
using std::string;

const int MAX_LINE_SIZE=4096;

typedef std::map< std::string , std::vector<std::string> > RdaHeader;
typedef std::vector<string>  hdrValue;
//typedef SiemensRdaReader Self;



const char *const RDA_HEADER_BEGIN = ">>> Begin of header <<<";
const char *const RDA_HEADER_END = ">>> End of header <<<";

//Edited 2007-03-07 to allow for RDA_VOI_READ_FOV change from RDA_VOI_READ_VOV 
const char RDAFields[84][32]=  {
  "PatientName:",
  "PatientID:",
  "PatientSex:", 
  "PatientBirthDate:", 
  "StudyDate:", 
  "StudyTime:", 
  "StudyDescription:", 
  "PatientAge:", 
  "PatientWeight:", 
  "SeriesDate:", 
  "SeriesTime:", 
  "SeriesDescription:", 
  "ProtocolName:", 
  "PatientPosition:", 
  "SeriesNumber:", 
  "InstitutionName:", 
  "StationName:", 
  "ModelName:", 
  "DeviceSerialNumber:", 
  "SoftwareVersion[0]:", 
  "InstanceDate:", 
  "InstanceTime:", 
  "InstanceNumber:", 
  "InstanceComments:", 
  "AcquisitionNumber:", 
  "SequenceName:", 
  "SequenceDescription:", 
  "TR:", 
  "TE:", 
  "TM:", 
  "TI:", 
  "DwellTime:", 
  "NumberOfEchoes:", 
  "NumberOfAverages:", 
  "MRFrequency:", 
  "Nucleus:", 
  "MagneticFieldStrength:", 
  "NumOfPhaseEncodingSteps:", 
  "FlipAngle:", 
  "VectorSize:", 
  "CSIMatrixSize[0]:", 
  "CSIMatrixSize[1]:", 
  "CSIMatrixSize[2]:", 
  "CSIMatrixSizeOfScan[0]:", 
  "CSIMatrixSizeOfScan[1]:", 
  "CSIMatrixSizeOfScan[2]:", 
  "CSIGridShift[0]:", 
  "CSIGridShift[1]:", 
  "CSIGridShift[2]:",
  "HammingFilter:",
  "HammingFilterWidth:",
  "TransmitCoil:",
  "TransmitRefAmplitude[1H]:",
  "SliceThickness:",
  "PositionVector[0]:",
  "PositionVector[1]:",
  "PositionVector[2]:",
  "RowVector[0]:",
  "RowVector[1]:",
  "RowVector[2]:",
  "ColumnVector[0]:",
  "ColumnVector[1]:",
  "ColumnVector[2]:",
  "VOIPositionSag:",
  "VOIPositionCor:",
  "VOIPositionTra:",
  "VOIThickness:",
  "VOIPhaseFOV:",
  "VOIReadoutFOV:",
  "VOINormalSag:",
  "VOINormalCor:",
  "VOINormalTra:",
  "VOIRotationInPlane:",
  "FoVHeight:",
  "FoVWidth:",
  "FoV3D:",
  "PercentOfRectFoV:",
  "NumberOfRows:",
  "NumberOfColumns:",
  "NumberOf3DParts:",
  "PixelSpacingRow:",
  "PixelSpacingCol:",
  "PixelSpacing3D:",
  "VOIReadoutVOV:"
};

typedef enum  {
   RDA_PATIENT_NAME = 0,
   RDA_PATIENT_ID = 1,
   RDA_PATIENT_SEX = 2,
   RDA_PATIENT_BIRTHDATE = 3,
   RDA_STUDY_DATE = 4,
   RDA_STUDY_TIME = 5,
   RDA_STUDY_DESCRIPTION = 6,
   RDA_PATIENT_AGE = 7,
   RDA_PATIENT_WEIGHT = 8,
   RDA_SERIES_DATE = 9,
   RDA_SERIES_TIME = 10,
   RDA_SERIES_DESCRIPTION = 11,
   RDA_PROTOCOL_NAME = 12,
   RDA_PATIENT_POSITION = 13,
   RDA_SERIES_NUMBER = 14,
   RDA_INSITUTION_NAME = 15,
   RDA_STATION_NAME = 16,
   RDA_MODEL_NAME = 17,
   RDA_DEV_SN = 18,
   RDA_SOFTWARE_REV = 19,
   RDA_INSTANCE_DATE = 20,
   RDA_INSTANCE_TIME = 21,
   RDA_INSTANCE_NUMBER = 22,
   RDA_INSTANCE_COMMENTS = 23,
   RDA_ACQ_NUMBER = 24,
   RDA_SEQUENCE_NAME = 25,
   RDA_SEQUENCE_DESCRIPTION = 26,
   RDA_TR = 27,
   RDA_TE = 28,
   RDA_TM = 29,
   RDA_TI = 30,
   RDA_DWELL_TIME = 31,
   RDA_NUM_ECHOES = 32,
   RDA_NUM_AVGS = 33,
   RDA_MR_FREQUENCY = 34,
   RDA_NUCLEUS = 35,
   RDA_MR_FIELD = 36,
   RDA_NUM_PHASE = 37,
   RDA_FLIP_ANGLE = 38,
   RDA_VECTOR_SIZE = 39,
   RDA_MATRIX_XSIZE = 40,
   RDA_MATRIX_YSIZE = 41,
   RDA_MATRIX_ZSIZE = 42,
   RDA_SCANMATRIX_XSIZE = 43,
   RDA_SCANMATRIX_YSIZE = 44,
   RDA_SCANMATRIX_ZSIZE = 45,
   RDA_GRID_X_SHIFT = 46,
   RDA_GRID_Y_SHIFT = 47,
   RDA_GRID_Z_SHIFT = 48,
   RDA_HAM_FILTER = 49,
   RDA_HAM_FILTER_WIDTH = 50,
   RDA_TRANS_COIL = 51,
   RDA_TRANS_REF = 52,
   RDA_SLICE_THICK = 53,
   RDA_POS_X_VECTOR = 54,
   RDA_POS_Y_VECTOR = 55,
   RDA_POS_Z_VECTOR = 56,
   RDA_ROW_X_VECTOR = 57,
   RDA_ROW_Y_VECTOR = 58,
   RDA_ROW_Z_VECTOR = 59,
   RDA_COL_X_VECTOR = 60,
   RDA_COL_Y_VECTOR = 61,
   RDA_COL_Z_VECTOR = 62,
   RDA_VOI_POS_SAG = 63,
   RDA_VOI_POS_COR = 64,
   RDA_VOI_POS_AXI = 65,
   RDA_VOI_THICK = 66,
   RDA_VOI_PHASE_FOV = 67,
   RDA_VOI_READ_FOV = 68,
   RDA_VOI_NORM_SAG = 69,
   RDA_VOI_NORM_COR = 70,
   RDA_VOI_NORM_AXI = 71,
   RDA_VOI_ROTATION = 72,
   RDA_FOV_HEIGHT = 73,
   RDA_FOV_WIDTH = 74,
   RDA_FOV_3D = 75,
   RDA_FOV_RECT = 76,
   RDA_FOV_NUM_ROWS = 77,
   RDA_FOV_NUM_COLS = 78,
   RDA_FOV_NUM_3D = 79,
   RDA_PIXEL_SIZE_ROW = 80,
   RDA_PIXEL_SIZE_COL = 81,
   RDA_PIXEL_SIZE_SLICE = 82,
   RDA_VOI_READ_VOV = 83
} RdaFieldsNames;


class SiemensRdaReader
{
public:
 
    bool ReadRdaHeader(string filename);
    int GetNumberHeaderValues(RdaFieldsNames tag);
    string GetHeaderTag(RdaFieldsNames tag);
    string GetHeaderTag(RdaFieldsNames tag, int index);

	RdaHeader siemensHdrMap;	
	
};



#endif
