/*=========================================================================

Program:   BRAINS (Brain Research: Analysis of Images, Networks, and Systems)
Module:    $RCSfile: $
Language:  TCL
Date:      $Date: 2006/03/29 14:53:40 $
Version:   $Revision: 1.9 $

Copyright (c) Iowa Mental Health Clinical Research Center. All rights reserved.
See BRAINSCopyright.txt or http://www.psychiatry.uiowa.edu/HTML/Copyright.html
for details.

This software is distributed WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#ifndef __BrainMUSH_h__
#define __BrainMUSH_h__


//#include <iostream>
//#include <fstream>
//#include <sstream>
//#include <stdlib.h>


//
//#include "itkImage.h"
//
//#include "itkImageFileReader.h"
//
//#include <itkLabelStatisticsImageFilter.h>
//#include "itkMatrix.h"
//#include "itkImageFileWriter.h"
//
//#include "itkImageIterator.h"
//#include "itkImageRegionIterator.h"
//#include "itkImageRegionConstIterator.h"
//#include "itkImageRegionConstIteratorWithIndex.h"
//#include "itkNumericTraits.h"
//#include "itkProgressReporter.h"
#include "itkBinaryBallStructuringElement.h"
//

//#include "itkOrientedImage.h"

const int Dimension = 3;
//typedef unsigned char InputPixelType;
	typedef float FloatPixelType;
	typedef itk::Image< FloatPixelType, 3 > FloatImageType;
	typedef signed short MushPixelType;
	typedef itk::Image< MushPixelType, 3 > MushImageType;
//typedef MaskImageType::IndexType MaskIndexType;
//
//typedef itk::ImageFileWriter<MaskImageType> MaskImageWriterType;
//
//

//typedef itk::ImageRegionIterator<MaskImageType> MaskIteratorType;
//typedef itk::ImageRegionConstIterator<MaskImageType> ConstMaskIteratorType;
//
	typedef itk::BinaryBallStructuringElement < MushPixelType, Dimension > StructuringElementType;
	typedef itk::Image<MushPixelType,3>												MaskType;
//
//
//typedef FloatImageType::Pointer FloatImageTypePointer;
//
//typedef MaskImageType::Pointer MaskImageTypePointer;

MushImageType::Pointer BRAINSMushPrimary(FloatImageType::Pointer, FloatImageType::Pointer );

MushImageType::Pointer GenerateInitializerRegion( FloatImageType::Pointer &referenceImage);

FloatImageType::Pointer MixtureOptimizer(FloatImageType::Pointer &firstImage,
  FloatImageType::Pointer &secondImage,
  MaskType::Pointer &maskImage,
  double desiredMean,
  double desiredVariance);


void GenerateBrainVolume(FloatImageType::Pointer &firstImage,
  FloatImageType::Pointer &secondImage,
  MaskType::Pointer &maskImage,
  double lowerThresholdFactor, 
  double upperThresholdFactor,
  MushImageType::Pointer &resultImage);

#endif /* __BrainMUSH_h__ */
