#ifndef GridCalculation_h
#define GridCalculation_h

#include "itkImage.h"
#include "vtkStructuredGrid.h"
#include "vtkDataArray.h"
#include "vtkKWImage.h"

typedef signed short									PixelType;
typedef itk::Image<PixelType, 3>						ImageType;

class GridCalculation
{
public:
	
	GridCalculation();

	void Calculate();
	void ParameterCalculate();
	void SetImage( vtkKWImage *);
	
	void SetT1Map( vtkKWImage *);
	void SetT2Map( vtkKWImage *);
	
	void SetWhiteMap( vtkKWImage *);
	void SetGreyMap( vtkKWImage *);
	void SetBGMap( vtkKWImage *);
	void SetCSFMap( vtkKWImage *);
	
	void SetGrid(vtkStructuredGrid *);
	void SetName(char *);
	vtkDataArray * GetOutput();
	vtkStructuredGrid * GetOutputGrid();
	ImageType::Pointer GetITK( vtkKWImage *);

private:

	ImageType::Pointer				Image;
	ImageType::Pointer				T1Map;
	ImageType::Pointer				T2Map;
	ImageType::Pointer				GreyMap;
	ImageType::Pointer				WhiteMap;
	ImageType::Pointer				BGMap;
	ImageType::Pointer				CSFMap;
	vtkStructuredGrid*				Grid;
	char *							Name;
	double							VoxelVolume;
	vtkIdType						numCells;
	
};

#endif
