#ifndef ImageProcessing_h
#define ImageProcessing_h

#include "itkMatrix.h"
//#include "itkOrientedImage.h"
#include "itkImage.h"
#include "vtkStructuredGrid.h"
//#include "itkFFTConvolutionImageFilter.h"
#include "itkImageFileWriter.h"
#include "vtkKWImage.h"
#include "vtkKWImageIO.h"
#include "itkResampleImageFilter.h"
#include "itkMaskImageFilter.h"
//Image Registration
#include "itkImageRegistrationMethod.h"
#include "itkEuler3DTransform.h"
#include "itkMeanSquaresImageToImageMetric.h"
#include "itkRegularStepGradientDescentOptimizer.h"
#include "itkLinearInterpolateImageFunction.h"
#include "itkVersorRigid3DTransform.h"
#include "itkCenteredTransformInitializer.h"
#include "itkVersorRigid3DTransformOptimizer.h"
#include "itkRigid3DTransform.h"
#include "itkMattesMutualInformationImageToImageMetric.h"



typedef signed short															PixelType;
typedef double																	DoublePixelType;
typedef itk::Image<PixelType, 3>												ImageType;
typedef itk::Image<DoublePixelType, 3>											DoubleImageType;
typedef itk::Matrix<double>														MatrixType;
typedef itk::Image<unsigned short, 3>											RegImageType;
typedef itk::ResampleImageFilter<ImageType, ImageType>							ResampleFilterType;	
typedef itk::AffineTransform<double,3>											AffineTransformType;
typedef itk::MaskImageFilter<ImageType,ImageType,ImageType>						MaskFilterType;

typedef std::complex<double>													ComplexPixelType;
typedef itk::Image< ComplexPixelType,3>											ComplexImageType;
	
//typedef itk::AffineTransform<double,3>											TransformType;
typedef itk::VersorRigid3DTransform<double>										TransformType;
typedef itk::VersorRigid3DTransformOptimizer									OptimizerType;
//typedef itk::Rigid3DTransform<double>											TransformType;
//typedef itk::RegularStepGradientDescentOptimizer								OptimizerType;
//typedef itk::MeanSquaresImageToImageMetric< ImageType, ImageType >				MetricType;
typedef itk::MattesMutualInformationImageToImageMetric<ImageType,ImageType>		MetricType;
typedef itk::LinearInterpolateImageFunction< ImageType, double  >				InterpolatorType;
typedef itk::ImageRegistrationMethod< ImageType, ImageType >					RegistrationType;
typedef itk::CenteredTransformInitializer<TransformType,ImageType,ImageType>	TransformInitializerType;


class ImageProcessing
{
public:
	
	ImageProcessing();

	void Threshold();
	void ExtractGridVoxels();
	//void SubsampleImage(int);
	
	void ResampleImage();
   
	void SetImage(vtkKWImage *);
	void SetMask(vtkKWImage *);
	void SetImage(ImageType::Pointer);
	void SetSpacing(ImageType::SpacingType);
	void SetSize(ImageType::SizeType);
	//void SetOrigin(ImageType::PointType);

	void SetGrid(vtkStructuredGrid *);
	void SetGridSpacing(double *);
	void SetGridDirCos( MatrixType );
	void SetGridFOV(double *);
	void SetGridCenter(double *);
	
	void RegisterImages(ImageType::Pointer,ImageType::Pointer);

	TransformType::Pointer GetRegistrationTransform();

	void WriteImage();

	void FFT();
	
	void Separate(int);
	//ImageType::Pointer GetClassImage(int);
	void MaskFilter();


	vtkKWImage * GetOutput();
	ImageType::Pointer GetITKOutput();
	//DoubleImageType::Pointer GetConvolvedImage();
	ImageType::Pointer GetITK(vtkKWImage *);

private:

	ImageType::Pointer					Image;
	ImageType::Pointer					Mask;
	ImageType::Pointer					ITKImage;
	vtkKWImage *						OutputImage;
	DoubleImageType::Pointer			KernelImage;
	DoubleImageType::Pointer			ConvolvedImage;

	vtkStructuredGrid*					Grid;
	double								VoxelVolume;
	vtkIdType							numCells;

	//Image parameters
	ImageType::SpacingType				ImageSpacing;
	ImageType::SizeType					ImageSize;

	double								GridSpacing[3];
	MatrixType							DirCos;
	double								GridFOV[3];
	double								GridCenter[3];

	//Set Transform	
	AffineTransformType::Pointer		transform; 
	TransformType::Pointer  RegTransform;

};

#endif
