
#ifndef __KMeansTissueClassifier_cxx__
#define __KMeansTissueClassifier_cxx__

#include "KMeansTissueClassifier.h"
#include "itkThresholdImageFilter.h"
#include "itkNotImageFilter.h"
#include "itkLabelStatisticsImageFilter.h"
#include "itkMaskImageFilter.h"
#include "itkScalarImageKmeansImageFilter.h"
#include "itkImageFileWriter.h"
//#include <itkOrientImageFilter.h>
#include "itkCastImageFilter.h"
#include "itkBinaryThresholdImageFilter.h"

#include <fstream>
#include <iostream>

#include "time.h"

KMeansTissueClassifier::KMeansTissueClassifier()
{
	//Constructor
	this->Image = ImageType::New();
	this->BrainMask = ImageType::New();
	this->ImageClassified = ImageType::New();

}

void KMeansTissueClassifier::SetImage(ImageType::Pointer inputImage)
{
	this->Image = inputImage;
}

void KMeansTissueClassifier::SetBrainMask(ImageType::Pointer inputMask)
{
	this->BrainMask = inputMask;
}

ImageType::Pointer KMeansTissueClassifier::GetOutput()
{
	return this->ImageClassified;
}

void KMeansTissueClassifier::Classify()
{
	std::ofstream debugStream;
	debugStream.open("E:\\Development\\output\\KMeans.txt");
	clock_t time[100];
	time[0] = clock();
	debugStream <<"*"<<std::endl;
	
	this->BrainMask->Print(debugStream);
	this->Image->Print(debugStream);

	int brain= 1;
	int nonbrain = 0;

	int numberOfStdDeviations = 1;

	PixelType imageExclusion = 0; //-32000;
	PixelType maskThresholdBelow = 1;     // someday with more generality?

	/* The Threshold Image Filter is used to produce the brain clipping mask. */
	typedef itk::ThresholdImageFilter<ImageType >			ThresholdFilterType;
	ThresholdFilterType::Pointer brainMaskFilter = ThresholdFilterType::New();
	brainMaskFilter->SetInput( this->BrainMask );
	brainMaskFilter->ThresholdBelow( maskThresholdBelow );
	brainMaskFilter->Update();

	 //typedef itk::BinaryThresholdImageFilter <ImageType, ImageType> BinaryThresholdFilterType;
	 // BinaryThresholdFilterType::Pointer maskfilter = BinaryThresholdFilterType::New();
	 // maskfilter->SetInput(this->BrainMask);
	 // maskfilter->SetLowerThreshold(0);
	 // maskfilter->SetInsideValue(255);
	 // maskfilter->SetOutsideValue(0);
	 // maskfilter->Update();
	
	time[1] = clock();

	/* The Not Image Filter is used to produce the other clipping mask. */
	typedef itk::NotImageFilter< ImageType, ImageType >					NotFilterType;
	NotFilterType::Pointer nonBrainMaskFilter = NotFilterType::New();
	nonBrainMaskFilter->SetInput( this->BrainMask );
	nonBrainMaskFilter->Update();

	/* The Statistics Image Filter lets us find the initial cluster means.
	Should this be limited to the excluded region of the clipped T1 image?  */
	typedef itk::LabelStatisticsImageFilter< ImageType, ImageType >		LabelStatisticsFilterType;
	typedef LabelStatisticsFilterType::RealType		StatisticRealType;
	
	LabelStatisticsFilterType::Pointer statisticsFilter = LabelStatisticsFilterType::New();
	statisticsFilter->SetInput( this->Image );
	statisticsFilter->SetLabelInput( brainMaskFilter->GetOutput() ); //this->BrainMask ); this->BrainMask );
	statisticsFilter->Update();

	debugStream <<"*"<<std::endl;

	time[2] = clock();

	const PixelType imageMin = static_cast<PixelType> ( statisticsFilter->GetMinimum(maskThresholdBelow) );
	const PixelType imageMax = static_cast<PixelType> ( statisticsFilter->GetMaximum(maskThresholdBelow) );
	const StatisticRealType imageMean = statisticsFilter->GetMean(maskThresholdBelow);
	const StatisticRealType imageSigma = statisticsFilter->GetSigma(maskThresholdBelow);

	debugStream << "T1 Brain Minimum == " << imageMin << std::endl;
	debugStream << "T1 Brain Maximum == " << imageMax << std::endl;
	debugStream << "T1 Brain Mean == " << imageMean << std::endl;
	debugStream << "T1 Brain Sigma == " << imageSigma << std::endl;
	
	/* The Statistics Image Filter lets us find the initial cluster means.
	 Should this be limited to the excluded region of the clipped T1 image?  */
	LabelStatisticsFilterType::Pointer nonBrainStatisticsFilter = LabelStatisticsFilterType::New();
	nonBrainStatisticsFilter->SetInput( this->Image );
	nonBrainStatisticsFilter->SetLabelInput( nonBrainMaskFilter->GetOutput() );
	nonBrainStatisticsFilter->Update();
	
	time[3] = clock();

	const PixelType         nonBrainImageMin = static_cast<PixelType>( nonBrainStatisticsFilter->GetMinimum(1) );
	const PixelType         nonBrainImageMax = static_cast<PixelType>( nonBrainStatisticsFilter->GetMaximum(1) );
	const StatisticRealType nonBrainImageMean = nonBrainStatisticsFilter->GetMean(1);
	const StatisticRealType nonBrainImageSigma = nonBrainStatisticsFilter->GetSigma(1);

	// std::cout << "Background Minimum == " << nonBrainImageMin << std::endl;
	debugStream << "Background Maximum == " << nonBrainImageMax << std::endl;
	debugStream << "Background Minimum == " << nonBrainImageMin << std::endl;
	debugStream << "Background Mean == " << nonBrainImageMean << std::endl;
	debugStream << "Background Sigma == " << nonBrainImageSigma << std::endl;
    
	/* The Mask Image Filter applies the clipping mask by stepping
	 on the excluded region with the imageExclusion value. */
	typedef itk::MaskImageFilter<ImageType, ImageType> MaskFilterType;
	MaskFilterType::Pointer clippedBrainT1Filter = MaskFilterType::New();
	clippedBrainT1Filter->SetInput1( this->Image );
	clippedBrainT1Filter->SetInput2( brainMaskFilter->GetOutput() );
	clippedBrainT1Filter->SetOutsideValue( imageExclusion );
	
	clippedBrainT1Filter->Update();
	
	
	/*
	ImageType::Pointer clippedBrainT1Pointer;

	if ( numberOfStdDeviations > 0.0 )
	{
		ThresholdFilterType::Pointer clipArterialBloodFilter = ThresholdFilterType::New();
		clipArterialBloodFilter->SetInput( clippedBrainT1Filter->GetOutput() );
		clipArterialBloodFilter->ThresholdAbove( static_cast<ImageType::PixelType>( imageMean + numberOfStdDeviations
																					* imageSigma ) );
		clipArterialBloodFilter->SetOutsideValue( imageExclusion );
		clipArterialBloodFilter->Update();
		clippedBrainT1Pointer = clipArterialBloodFilter->GetOutput();
	}
	else
	{
		clippedBrainT1Pointer = clippedBrainT1Filter->GetOutput();
	}*/

	

	time[4] = clock();

	/* The Mask Image Filter applies the clipping mask by stepping
	 on the excluded region with the imageExclusion value. */
	MaskFilterType::Pointer clippedNonBrainT1Filter = MaskFilterType::New();
	clippedNonBrainT1Filter->SetInput1( this->Image );
	clippedNonBrainT1Filter->SetInput2( nonBrainMaskFilter->GetOutput() );
	clippedNonBrainT1Filter->SetOutsideValue( imageExclusion );
	clippedNonBrainT1Filter->Update();

 
	typedef itk::ImageFileWriter<ImageType>  WriterType;
	WriterType::Pointer writer = WriterType::New();
	writer->SetFileName("E:\\Development\\output\\kmeans.nii");
	writer->SetInput(clippedBrainT1Filter->GetOutput());
	writer->Update();
	/***********************************************
	vtkKWImageIO * KMeanswriter = vtkKWImageIO::New();
	KMeanswriter->SetFileName("E:\\Development\\output\\kmeans.nii");
	KMeanswriter->SetImageToBeWritten(kmeans);
	try
	{
		KMeanswriter->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
	/***********************************************/

	typedef itk::ScalarImageKmeansImageFilter< ImageType >					KMeansFilterType;
	KMeansFilterType::Pointer kmeansFilter = KMeansFilterType::New();
	kmeansFilter->SetInput( clippedBrainT1Filter->GetOutput() );

	unsigned int numberOfInitialClasses = 4;
	const unsigned int useNonContiguousLabels = 1;

	typedef KMeansFilterType::RealPixelType  RealPixelType;

	RealPixelType backgroundInitialMean = imageExclusion;
//	RealPixelType bloodInitialMean = imageMax;    // ARTERIAL blood.
	const RealPixelType csfInitialMean = imageMean - 2*imageSigma;
	const RealPixelType whiteInitialMean = imageMean + imageSigma;
	const RealPixelType grayInitialMean = imageMean - imageSigma/5;

	
	kmeansFilter->AddClassWithInitialMean( backgroundInitialMean );
	kmeansFilter->AddClassWithInitialMean( csfInitialMean );
	kmeansFilter->AddClassWithInitialMean( grayInitialMean );
	kmeansFilter->AddClassWithInitialMean( whiteInitialMean );
	//kmeansFilter->AddClassWithInitialMean( bloodInitialMean );

	kmeansFilter->SetUseNonContiguousLabels( useNonContiguousLabels );


	time[5] = clock();
	
	try
	{
		kmeansFilter->Update();
	}
	catch( itk::ExceptionObject & excp )
	{
		debugStream << "Problem encountered while running K-means segmentation ";
		debugStream << excp << std::endl;
		return ;
	}

	time[6] = clock();

	KMeansFilterType::ParametersType estimatedMeans = kmeansFilter->GetFinalMeans();

	unsigned int numberOfClasses = estimatedMeans.Size();

	for ( unsigned int i = 0 ; i < numberOfClasses ; ++i )
	{
		debugStream << "Brain cluster[" << i << "] ";
		debugStream << "    estimated mean : " << estimatedMeans[i] << std::endl;
	}

	/* The Scalar Image Kmeans Image Filter will find a code image in 3 classes
	 for the interior of the mask, plus a code for the exterior of the mask. 
	KMeansFilterType::Pointer kmeansNonBrainFilter = KMeansFilterType::New();
	kmeansNonBrainFilter->SetInput( clippedNonBrainT1Filter->GetOutput() );

	numberOfInitialClasses = 4;

	backgroundInitialMean = imageExclusion;
	const RealPixelType airInitialMean = imageMin;
	const RealPixelType fatInitialMean = imageMax;
	const RealPixelType muscleInitialMean = imageMean;
	
	// Why are these the brain region versions, and not the background region
	// versions?  Seems to work, though.
	debugStream << "kmeansNonBrainFilter InitialMeans  " << backgroundInitialMean << ";  " << airInitialMean << ";  "
			<< muscleInitialMean << ";  " << fatInitialMean << std::endl;
	kmeansNonBrainFilter->AddClassWithInitialMean( backgroundInitialMean );
	kmeansNonBrainFilter->AddClassWithInitialMean( airInitialMean );
	kmeansNonBrainFilter->AddClassWithInitialMean( muscleInitialMean );
	kmeansNonBrainFilter->AddClassWithInitialMean( fatInitialMean );
	kmeansNonBrainFilter->SetUseNonContiguousLabels( useNonContiguousLabels );

	time[7] = clock();
	
	debugStream << "kmeansNonBrainFilter->Update " << std::endl;
	try
	{
		kmeansNonBrainFilter->Update();
	}
	catch ( itk::ExceptionObject & excp )
	{
		debugStream << "Problem encountered while Background K-Means segmentation ";
		debugStream << excp << std::endl;
	}
	
	time[8] = clock();

	estimatedMeans = kmeansNonBrainFilter->GetFinalMeans();
	numberOfClasses = estimatedMeans.Size();

	for ( unsigned int i = 0; i < numberOfClasses; ++i )
	{
		debugStream << "Background cluster[" << i << "] ";
		debugStream << "    estimated mean : " << estimatedMeans[i] << std::endl;
	}

	/*******************************************************************************************/

	typedef KMeansFilterType::OutputImageType				KMeansImageType;
	KMeansImageType::Pointer kmeansLabelImage = KMeansImageType::New();
	kmeansLabelImage->SetRegions( this->BrainMask->GetLargestPossibleRegion() );
	kmeansLabelImage->SetSpacing( this->BrainMask->GetSpacing() );
	kmeansLabelImage->SetDirection( this->BrainMask->GetDirection() );
	kmeansLabelImage->SetOrigin( this->BrainMask->GetOrigin() );
	kmeansLabelImage->Allocate( );
	kmeansLabelImage->FillBuffer( 0 );
	
	unsigned char currentLabel = 0;

	/*******************************************************************************************
	// Background Tissues are Lower Label values 

	typedef itk::LabelStatisticsImageFilter<KMeansImageType, KMeansImageType> LabelMapStatisticsFilterType;
	LabelMapStatisticsFilterType::Pointer statisticsNonBrainFilter = LabelMapStatisticsFilterType::New();
	statisticsNonBrainFilter->SetInput( kmeansNonBrainFilter->GetOutput() );
	statisticsNonBrainFilter->SetLabelInput( kmeansNonBrainFilter->GetOutput() );
	statisticsNonBrainFilter->Update();

	for ( unsigned int i = 1; i < 256; i++ )
	{
		if ( statisticsNonBrainFilter->HasLabel( static_cast<unsigned char>( i ) ) )
		{
			currentLabel++;
			KMeansImageType::RegionType labelRegion = statisticsNonBrainFilter->GetRegion( static_cast<unsigned char>( i ) );
			itk::ImageRegionIterator<KMeansImageType> it( kmeansNonBrainFilter->GetOutput(), labelRegion );

			it.GoToBegin();
		
			while ( !it.IsAtEnd() )
			{
				if ( it.Get() == static_cast<unsigned char>( i ) )
				{
					// Set Output Image
					kmeansLabelImage->SetPixel(it.GetIndex(), currentLabel);
				}
				++it;
			}

		}
	}
	/*******************************************************************************************/

	time[9] = clock();

	/*******************************************************************************************/
	/* Brain Tissues are Higher Label values */
	typedef itk::LabelStatisticsImageFilter< KMeansImageType, KMeansImageType >		LabelMapStatisticsFilterType;
	LabelMapStatisticsFilterType::Pointer statisticsBrainFilter = LabelMapStatisticsFilterType::New();
	statisticsBrainFilter->SetInput( kmeansFilter->GetOutput() );
	statisticsBrainFilter->SetLabelInput( kmeansFilter->GetOutput() );
	statisticsBrainFilter->Update();

	
	for (unsigned int i=1; i<256; i++)
	{
		if ( statisticsBrainFilter->HasLabel( static_cast<unsigned char> ( i ) ) )
		{
			currentLabel++;
			KMeansImageType::RegionType labelRegion = statisticsBrainFilter->GetRegion( static_cast<unsigned char> ( i ) );
			itk::ImageRegionIterator<KMeansImageType> it( kmeansFilter->GetOutput(), labelRegion );

			it.GoToBegin();
			while( !it.IsAtEnd() )
			{
				if ( it.Get() == static_cast<unsigned char> ( i ) ) 
				{
					// Set Output Image
					kmeansLabelImage->SetPixel(it.GetIndex(), currentLabel);
				}
				++it;
			} 
		}
	}
/*******************************************************************************************/
	time[10] = clock();

	typedef itk::CastImageFilter<KMeansImageType, ImageType> CastImageFilterType;
	CastImageFilterType::Pointer orientFilter = CastImageFilterType::New();

	orientFilter->SetInput(kmeansLabelImage);
	orientFilter->Update();

	this->ImageClassified = orientFilter->GetOutput();

	time[11] = clock();
	//debugStream <<"Time elapsed: "<<(time[1]-time[0])/CLOCKS_PER_SEC << std::endl;
	//debugStream <<"Time elapsed: "<<(time[2]-time[1])/CLOCKS_PER_SEC << std::endl;
	//debugStream <<"Time elapsed: "<<(time[3]-time[2])/CLOCKS_PER_SEC << std::endl;
	//debugStream <<"Time elapsed: "<<(time[4]-time[3])/CLOCKS_PER_SEC << std::endl;
	//debugStream <<"Time elapsed: "<<(time[5]-time[4])/CLOCKS_PER_SEC << std::endl;
	//debugStream <<"Time elapsed: "<<(time[6]-time[5])/CLOCKS_PER_SEC << std::endl;
	//debugStream <<"Time elapsed: "<<(time[7]-time[6])/CLOCKS_PER_SEC << std::endl;
	//debugStream <<"Time elapsed: "<<(time[8]-time[7])/CLOCKS_PER_SEC << std::endl;
	//debugStream <<"Time elapsed: "<<(time[9]-time[8])/CLOCKS_PER_SEC << std::endl;
	//debugStream <<"Time elapsed: "<<(time[10]-time[9])/CLOCKS_PER_SEC << std::endl;
	//debugStream <<"Time elapsed: "<<(time[11]-time[10])/CLOCKS_PER_SEC << std::endl;

	debugStream <<"end"<<std::endl;
	debugStream.close();
	return;
}

#endif