/*=========================================================================

 Program:   BRAINS (Brain Research: Analysis of Images, Networks, and Systems)
 Module:    $RCSfile: $
 Language:  TCL
 Date:      $Date: 2006/03/29 14:53:40 $
 Version:   $Revision: 1.9 $
 
   Copyright (c) Iowa Mental Health Clinical Research Center. All rights reserved.
   See BRAINSCopyright.txt or http://www.psychiatry.uiowa.edu/HTML/Copyright.html 
   for details.
 
      This software is distributed WITHOUT ANY WARRANTY; without even 
      the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
      PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#ifndef __KMeansTissueClassifier_h__
#define __KMeansTissueClassifier_h__

#include "itkImage.h"

typedef signed short													PixelType;
typedef itk::Image<PixelType, 3>										ImageType;


class KMeansTissueClassifier
{
public:
	KMeansTissueClassifier();

	void SetImage(ImageType::Pointer);
	void SetBrainMask(ImageType::Pointer);

	void Classify();

	ImageType::Pointer		GetOutput();
    
private:
	ImageType::Pointer		Image;
	ImageType::Pointer		BrainMask;
	ImageType::Pointer		ImageClassified;

	int brainMask, nonBrainMask;
    
};

#endif