#ifndef __LoadSEMCImages_cxx
#define __LoadSEMCImages_cxx

#include "LoadSEMCImages.h"
#include <stdio.h>
#include <stdlib.h>
#define _CRT_SECURE_NO_WARNINGS

//----------------------------------------------------------------------------
LoadSEMCImages::LoadSEMCImages()
{
	this->OutputImage = ImageType::New();
	this->NumEchoes = 1;
	this->T2Map = ImageType::New();
	this->MaxT2Time = 5000.0;
	this->Threshold = 0;
	this->Algorithm = MRT2ParameterMap3DImageFilterType::LINEAR;
}

//----------------------------------------------------------------------------
LoadSEMCImages::~LoadSEMCImages()
{

}

void LoadSEMCImages::SetDirectory( const std::string name )
{
	this->dirName = name;
}
		
std::string LoadSEMCImages::GetDirectory()
{
	return this->dirName;
}

int LoadSEMCImages::GetNumberOfEchoes()
{
	return this->NumEchoes;
}

std::vector<double> LoadSEMCImages::GetEchoTimes()
{
	return this->EchoTimes;
}
	
void LoadSEMCImages::SetNumberOfEchoes( int echoes)
{
	this->NumEchoes = echoes;
}

vtkKWImage * LoadSEMCImages::GetImage(int echo)
{
	vtkKWImage * tempImage = vtkKWImage::New();
	tempImage->SetITKImageBase(this->EchoImages[echo]);
	return tempImage;
}

vtkKWImage * LoadSEMCImages::GetT2Map()
{
	vtkKWImage * tempImage = vtkKWImage::New();
	tempImage->SetITKImageBase(this->T2Map);
	return tempImage; //this->T2Map;
}
vtkKWImage *LoadSEMCImages::GetAMap()
{	
	vtkKWImage * tempImage = vtkKWImage::New();
	tempImage->SetITKImageBase(this->AMap);
	return tempImage;

}
vtkKWImage * LoadSEMCImages::GetCMap()
{
	vtkKWImage * tempImage = vtkKWImage::New();
	tempImage->SetITKImageBase(this->CMap);
	return tempImage;
}
vtkKWImage * LoadSEMCImages::GetErrorMap()
{
	vtkKWImage * tempImage = vtkKWImage::New();
	tempImage->SetITKImageBase(this->ErrorMap);
	return tempImage;
}

std::vector<vtkKWImage *> LoadSEMCImages::GetAllImages()
{
	std::vector<vtkKWImage *> tempImageVector;

	for (int i =0; i < this->EchoImages.size(); i++)
	{
		vtkKWImage * tempImage = vtkKWImage::New();
		tempImage->SetITKImageBase(this->EchoImages.at(i));
		tempImageVector.push_back(tempImage);
	}

	return tempImageVector; //this->EchoImages;
}

void LoadSEMCImages::SetMaxT2Time(double max)
{
	this->MaxT2Time = max;
}

void LoadSEMCImages::SetThreshold(short threshold)
{
	this->Threshold = threshold;
}

void LoadSEMCImages::SetAlgorithm(int algorithm)
{
	this->Algorithm = algorithm;
}

void LoadSEMCImages::Load()
{

	std::vector<std::string> fileList;
	fileList = ReadDirectoryFileNames(this->dirName);

	typedef itk::ImageSeriesReader< ImageType >     ReaderType;
	ReaderType::Pointer reader = ReaderType::New();
	typedef itk::GDCMImageIO       ImageIOType;
	
	ImageIOType::Pointer dicomIO = ImageIOType::New();
	dicomIO->SetLoadPrivateTags(true);
	reader->SetImageIO(dicomIO );
	
	std::string entryId = "0018|0081"; //TE times in DICOM header

	typedef itk::GDCMSeriesFileNames     NamesGeneratorType;
	NamesGeneratorType::Pointer nameGenerator = NamesGeneratorType::New();

	nameGenerator->SetLoadPrivateTags(true);
	nameGenerator->SetUseSeriesDetails(true);
	nameGenerator->AddSeriesRestriction(entryId);
	nameGenerator->SetDirectory( this->dirName);

	typedef const std::vector<std::string> ContainerType;
    const ContainerType & seriesUIDs = nameGenerator->GetSeriesUIDs();

	typedef std::vector< std::string >    SeriesIdContainer;
    const SeriesIdContainer & seriesUID = nameGenerator->GetSeriesUIDs();
    
    SeriesIdContainer::const_iterator seriesItr = seriesUID.begin();
    SeriesIdContainer::const_iterator seriesEnd = seriesUID.end();

	SetNumberOfEchoes(seriesUID.size() );
	
	while( seriesItr != seriesUID.end() )
    {
		//std::cout << seriesItr->c_str() << std::endl;
		ContainerType names = nameGenerator->GetFileNames(seriesItr->c_str() );
		ContainerType::const_iterator nameItr;

		nameItr = names.begin();

		reader->SetFileNames( nameGenerator->GetFileNames(seriesItr->c_str() ) );
	
		try
		{
			reader->Update();
			this->OutputImage = reader->GetOutput();

			typedef itk::MetaDataDictionary   DictionaryType;
			const  DictionaryType & dictionary = dicomIO->GetMetaDataDictionary();
			typedef itk::MetaDataObject< std::string > MetaDataStringType;
			DictionaryType::ConstIterator tagItr = dictionary.Find( entryId );

			MetaDataStringType::ConstPointer entryvalue = dynamic_cast<const MetaDataStringType *>( tagItr->second.GetPointer() );
			std::string tagvalue = entryvalue->GetMetaDataObjectValue();
			double value = atof(tagvalue.c_str());
			
			ImageType::Pointer temp = ImageType::New();
			temp = reader->GetOutput();
			this->EchoImages.push_back(temp);
			this->EchoTimes.push_back(value);

			temp->DisconnectPipeline();
			//std::cout<<tagvalue<<std::endl;
		}
		catch (itk::ExceptionObject &ex)
		{
			std::cout << ex << std::endl;
		} 
		seriesItr++;
	}
}

void LoadSEMCImages::Update()
{
	Load();
	
	MRT2ParameterMap3DImageFilterType::Pointer t2map = MRT2ParameterMap3DImageFilterType::New();

	unsigned int numberOfEchoTimes = this->EchoTimes.size();

	std::vector<ImageType::Pointer> outputImages;

	for (int i = 0; i < numberOfEchoTimes; i++)
	{
		ThresholdImageFilterType::Pointer thresholdFilter = ThresholdImageFilterType::New();
		thresholdFilter->SetInput( this->EchoImages.at(i) );
		thresholdFilter->SetOutsideValue(0);
		thresholdFilter->ThresholdBelow(this->Threshold);
		thresholdFilter->Update();

		ImageType::Pointer temp = ImageType::New();
		temp = thresholdFilter->GetOutput();
		outputImages.push_back(temp);
		temp->DisconnectPipeline();
	}

	for (int i = 1; i < numberOfEchoTimes; i++)
	{
		t2map->AddMREchoImage( this->EchoTimes.at(i), outputImages.at(i));
	}

	t2map->SetAlgorithm(this->Algorithm);
	t2map->SetMaxT2Time(this->MaxT2Time);
	t2map->Update();

	// Extract each output component and write to disk.
	VectorIndexSelectionCastImageFilterType::Pointer extractComp = VectorIndexSelectionCastImageFilterType::New();
	extractComp->SetInput(t2map->GetOutput());
	extractComp->SetIndex(0);
	extractComp->Update();
	this->T2Map = extractComp->GetOutput();
	this->T2Map->DisconnectPipeline();
	extractComp->SetIndex(1);
	extractComp->Update();
	this->AMap = extractComp->GetOutput();
	this->AMap->DisconnectPipeline();
	extractComp->SetIndex(2);
	extractComp->Update();
	this->CMap = extractComp->GetOutput();
	this->CMap->DisconnectPipeline();
	extractComp->SetIndex(3);
	extractComp->Update();
	this->ErrorMap = extractComp->GetOutput();
	this->ErrorMap->DisconnectPipeline();

}

std::vector<std::string> LoadSEMCImages::ReadDirectoryFileNames(std::string name)
{
	itk::DICOMSeriesFileNames::Pointer fileNames = itk::DICOMSeriesFileNames::New();
	typedef itk::DICOMSeriesFileNames::FileNamesArrayType  FileNamesListType;
	FileNamesListType fileList;

	fileNames->SetDirectory(name);
	fileList = fileNames->GetFileNames();
	return fileList;
}

void LoadSEMCImages::WriteEchoImage(int num)
{
	char i[33];  
	//itoa(num,i,10);
	sprintf(i,"%d",num);
	std::string fileName = this->dirName + i + "testImage.nii";
	typedef itk::ImageFileWriter<ImageType>			WriterType;
	
	WriterType::Pointer	writer = WriterType::New();
	writer->SetInput(this->EchoImages[num]);
	writer->SetFileName(fileName);
	writer->Update();
}

#endif