#ifndef PICKCELLCALLBACK_CXX
#define PICKCELLCALLBACK_CXX

#include "PickCellCallBack.h"

PickCellCallBack::PickCellCallBack()
{
		
	cellid = -1;
	this->Spectroscopy = new CSIgrid();
	this->TransformMatrix = vtkMatrix4x4::New();
	this->Grid = vtkStructuredGrid::New();

	this->Widget = NULL;

}

PickCellCallBack::~PickCellCallBack()
{

}

void PickCellCallBack::SetGrid(vtkStructuredGrid * grid )
{
	this->Grid = grid;
}

void PickCellCallBack::SetCSI(CSIgrid * grid )
{
	this->Spectroscopy = grid;
	this->Grid = this->Spectroscopy->GetOutput();
	this->TransformMatrix = this->Spectroscopy->GetTransformMatrix();
}

void PickCellCallBack::SetWidget(vtkKWListBoxWithScrollbars * widget)
{
	this->Widget = widget;
}

std::vector<vtkStructuredGrid *> PickCellCallBack::GetCellCollection( )
{
	return this->Cells;
}

std::vector<int> PickCellCallBack::GetCellIDs()
{
	return this->CellIDs;
}

void PickCellCallBack::SetTransform( vtkMatrix4x4 *transform)
{
	this->TransformMatrix = transform;
}

void PickCellCallBack::Execute(vtkObject *caller, unsigned long, void* calldata)
{
	std::ofstream debugStream;
	debugStream.open("E:\\Development\\output\\pickEvent.txt", ofstream::in | ofstream::out | ofstream::app);

	int dim[3];
	this->Grid->GetDimensions(dim);
	vtkCellPicker * picker = vtkCellPicker::SafeDownCast(caller);	
	int surfacePicked = picker->GetCellId();
	double pos[3];
	//picker->GetCellIJK(pos);
	picker->GetPickPosition(pos);
	
	int * point= new int[3];
	picker->GetPointIJK(point[0], point[1], point[2]);

	int cellID;
	if (surfacePicked > 0)
	{
		cellID = GetCellID(surfacePicked, dim);

		bool flag = 0;

		for (int i = 0; i < this->CellIDs.size(); i++)
		{
			if (this->CellIDs[i] == cellID)
			{
				flag = 1;
			}
		}
		if (flag == 0)
		{
			this->CellIDs.push_back(cellID);
			char pickID[100];
			sprintf(pickID,"%d",cellID);
			this->Widget->GetWidget()->AppendUnique(pickID);
		}
	}
	debugStream.close();

}
vtkStructuredGrid * PickCellCallBack::GenerateCell(int cellID, int* cellIJK)
{
	
	vtkIdList *pointids = vtkIdList::New();
	this->Grid->GetCellPoints(cellID, pointids);

	int Ids[8],temp;
	for(int i=0; i < pointids->GetNumberOfIds(); i++)
	{
		Ids[i] = pointids->GetId(i);
	}

	temp = Ids[0];
	Ids[0] = Ids[1];
	Ids[1] = temp;

	temp = Ids[4];
	Ids[4] =Ids[5];
	Ids[5] = temp;

	vtkFloatingPointType v[3];
	vtkPoints *newCellPoints = vtkPoints::New();
	newCellPoints->SetNumberOfPoints(pointids->GetNumberOfIds());

	
	for (int i=0; i<pointids->GetNumberOfIds(); i++)
	{
		this->Grid->GetPoint(Ids[i], v);
		newCellPoints->InsertPoint(i, v[0], v[1], v[2]);
		
	}

	int dimension[3];
	dimension[0] = 2;
	dimension[1] = 2;
	dimension[2] = 2;

	/**********		Build Hexahedron and Transformation		***********/
	vtkStructuredGrid *newCell = vtkStructuredGrid::New();
	newCell->SetDimensions(dimension);
	newCell->SetPoints(newCellPoints);

	//vtkGeometryFilter *geometryfilter = vtkGeometryFilter::New();
	//geometryfilter->SetInput(newCell);  

	//vtkTransform *newTransform = vtkTransform::New();
	//newTransform->SetMatrix(this->TransformMatrix);

	//vtkTransformPolyDataFilter *polyData = vtkTransformPolyDataFilter::New();
	//polyData->SetTransform(newTransform);
	//polyData->SetInput(geometryfilter->GetOutput());
	//polyData->Update();

	//vtkPolyDataMapper *mapper = vtkPolyDataMapper::New();
	//mapper->SetInput(polyData->GetOutput());


	//Keep track of 

	//m_CellActors[index] = vtkActor::New();
	//m_CellActors[index]->SetMapper(mapper);
	//m_CellActors[index]->GetProperty()->SetColor(1,0,0);
	//m_CellActors[index]->GetProperty()->SetOpacity(0.4);

	/**********		Visualization.		***********/
	/*m_Renderer->AddActor(m_CellActors[index]);	*/

	return newCell;
	
}

void PickCellCallBack::RemoveCell(int cellID)
{
	//implement the removal of cells
}

int PickCellCallBack::GetCellID(int surface, int *dim)
{

	dim[0] = dim[0]-1;
	dim[1] = dim[1]-1;
	dim[2] = dim[2]-1;

	int total, totalfaces;
	total = dim[0] * dim[1] * dim[2];
	totalfaces = 2*total + 2*(dim[0]+dim[1]);

	int *LookUpTable;
	LookUpTable = new int[totalfaces];

	//Initialize the LookUpTable
	for (int i=0; i<totalfaces; i++)
	{
		LookUpTable[i] = 0;	
	}

	//Create LookUpTable
	//First row
	int index=0;
	int Hindex=0;
	for (int i=0; i<dim[0]; i++)
	{
		if (Hindex==0)
			for (int j=0; j<4; j++){
				LookUpTable[index] = Hindex;
				index++;
			}//end of for

		if (Hindex==dim[0]-1)
			for (int j=0; j<4; j++){
				LookUpTable[index] = Hindex;
				index++;
			}//end of for

		if ((Hindex!=0)&&(Hindex!=dim[0]-1))
			for (int j=0; j<3; j++){
				LookUpTable[index] = Hindex;
				index++;
			}//end of for

		Hindex++;

	}//end of for

	//2nd row to last 2nd row
	for (int row=1; row<dim[1]-1; row++){

		for (int column=0; column<dim[0]; column++){
		
			if (column==0)
				for (int j=0; j<3; j++){
					LookUpTable[index] = Hindex;
					index++;
				}//end of for

			if (column==dim[0]-1)
				for (int j=0; j<3; j++){
					LookUpTable[index] = Hindex;
					index++;
				}//end of for

			if ((column!=0)&&(column!=dim[0]-1))
				for (int j=0; j<2; j++){
					LookUpTable[index] = Hindex;
					index++;
				}//end of for

			Hindex++;
		
		}//end of for

	}//end of for

	//Last row
	for (int i=0; i<dim[0]; i++){
	
		if (Hindex==dim[0]*(dim[1]-1))
			for (int j=0; j<4; j++){
				LookUpTable[index] = Hindex;
				index++;
			}//end of for

		if (Hindex==dim[0]*dim[1]-1)
			for (int j=0; j<4; j++){
				LookUpTable[index] = Hindex;
				index++;
			}//end of for

		if ((Hindex!=dim[0]*(dim[1]-1))&&(Hindex!=dim[0]*dim[1]-1))
			for (int j=0; j<3; j++){
				LookUpTable[index] = Hindex;
				index++;
			}//end of for

		Hindex++;

	}//end of for
	
	//Return HexahedronID
	for (int id=0; id<totalfaces; id++)
	{
		if (id==surface)
		{
			return LookUpTable[id];
			break;
		}//end of if
	}//end of for id

}//end of GetHexahedronID

#endif