#include "SiemensRdaReader.h"
#include <iostream>
#include <sstream>
#include <fstream>

#include <string.h>

int SiemensRdaReader::GetNumberHeaderValues(RdaFieldsNames tag)
{
	hdrValue curValue = this->siemensHdrMap[RDAFields[tag]];
	
	return (curValue.size()-1);
}

std::string SiemensRdaReader::GetHeaderTag(RdaFieldsNames tag)
{
	RdaFieldsNames tmpTag = tag;
	std::ofstream debugStream;
   // debugStream.open(".\\output\\GetHeaderTagDebug.txt");

	//debugStream <<tag<< std::endl;
	hdrValue curValue;

	try 
	{
		//debugStream <<"enter try"<< std::endl;
		curValue = this->siemensHdrMap[RDAFields[tag]];
		//debugStream <<"before throw "<<curValue[0]<<" "<<curValue[1]<< std::endl;
		if (curValue.empty())
			throw exception();
	//	debugStream <<"after throw"<< std::endl;
	}
	catch ( exception &)
	{
	//	debugStream <<"enter catch"<< std::endl;
        if ( tag ==  RDA_VOI_READ_FOV )
		{tmpTag = RDA_VOI_READ_VOV;}
	//	debugStream <<tmpTag<< std::endl;
		curValue = this->siemensHdrMap[RDAFields[tmpTag]];
	//	debugStream <<"leave catch "<<curValue[0]<<" "<<curValue[1]<< std::endl;
	}

//	debugStream <<curValue[1]<<std::endl;

	
	return (curValue[1]);
}

std::string SiemensRdaReader::GetHeaderTag(RdaFieldsNames tag, int index)
{
	hdrValue curValue = this->siemensHdrMap[RDAFields[tag]];
	
	return (curValue[index]);
}

bool SiemensRdaReader::ReadRdaHeader(std::string filename)
{
	//std::ofstream debugStream;
   // debugStream.open(".\\output\\rdaReaderDebug.txt");

    std::ifstream filestr;
    filestr.open(filename.c_str(), std::ios::in );
    if(!filestr.is_open())
        {
        std::cerr << "Could not open file "
            << filename << std::endl;
        return false;
        }
	
	int currentlinenumber = 0;
    
	char currentline[MAX_LINE_SIZE];
	char test[MAX_LINE_SIZE];
    filestr.getline(currentline,MAX_LINE_SIZE-1);
    currentlinenumber++;
	//std::cout << "LINE (" << currentlinenumber << "): " << currentline << std::endl;
			
    while( strstr(currentline, RDA_HEADER_END) == NULL )
        {
        
        strcpy(test, currentline);
		
		if (strstr(currentline, RDA_HEADER_BEGIN) == NULL )
		{
			char *curArg = strtok(test, " ");
			std::string curTag = curArg;

			while (curArg != NULL)
				{
            	siemensHdrMap[curTag].push_back(curArg);
				//debugStream << "TOKEN: " << curArg <<" TAG:"<<curTag<<std::endl;
				curArg = strtok(NULL, " ");
				}
		}	
		//std::cout << "LINE (" << currentlinenumber << "): " << currentline << std::endl;
        filestr.getline(currentline,MAX_LINE_SIZE-1);
        currentlinenumber++;
		
				
        }
    filestr.close();
	
	
    return true;
}
