/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: itkImageToVTKImageFilter.h,v $
  Language:  C++
  Date:      $Date: 2007/03/05 22:11:57 $
  Version:   $Revision: 1.1 $

  Copyright (c) 2002 Insight Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#ifndef __itkImageToVTKImageFilterSpect_h
#define __itkImageToVTKImageFilterSpect_h

#include "itkVTKImageExport.h"
#include "vtkImageImport.h"
#include "vtkImageData.h"
#include "itkOrientedImage.h"
#include "itkImage.h"
#include "itkImageToVTKImageFilter.h"
//namespace itk
//{
  
/** \class ImageToVTKImageFilter
 * \brief Converts an ITK image into a VTK image and plugs a 
 *  itk data pipeline to a VTK datapipeline.   
 *
 *  This class puts together an itkVTKImageExporter and a vtkImageImporter.
 *  It takes care of the details related to the connection of ITK and VTK
 *  pipelines. The User will perceive this filter as an adaptor to which
 *  an itk::Image can be plugged as input and a vtkImage is produced as 
 *  output.
 * 
 * \ingroup   ImageFilters     
 */
   

class itkImageToVTKImageFilterSpect
{
public:
	
	typedef signed short										PixelType;
    typedef itk::OrientedImage< PixelType, 3 >					OrientedImageType;
    typedef itk::ImageToVTKImageFilter<OrientedImageType>		itk2vtkOrientFilterType;
	typedef itk::Image< PixelType, 3 >							InputImageType;
    typedef itk::ImageToVTKImageFilter<InputImageType>			itk2vtkFilterType;
	
	itkImageToVTKImageFilterSpect()
	{
		itk2vtkFilter = itk2vtkFilterType::New();
		itk2vtkOrientFilter = itk2vtkOrientFilterType::New();
	}; 
  
  ~itkImageToVTKImageFilterSpect();
  
  /** Get the output in the form of a vtkImage. 
      This call is delegated to the internal vtkImageImporter filter  */
  void SetInput( const InputImageType *inputImage )
  {
	   itk2vtkFilter->SetInput( inputImage );
  };

  void SetInput( const OrientedImageType *inputImage )
  {
	   itk2vtkOrientFilter->SetInput( inputImage );
  };
  /** Set the input in the form of an itk::Image */
  vtkImageData * GetOutputNormal()
  {
		return itk2vtkFilter->GetOutput();	  
  };

  vtkImageData * GetOutput()
  {
//	  vtkImageData * output;
	 
		return itk2vtkOrientFilter->GetOutput();	  
  };

  /** This call delegate the update to the importer */
  void Update()
  {
	  itk2vtkOrientFilter->Update();
  };
  void UpdateNormal()
  {
	  itk2vtkFilter->Update();
  };
  

private:
 
	itk2vtkFilterType::Pointer itk2vtkFilter;
	itk2vtkOrientFilterType::Pointer itk2vtkOrientFilter;
};

//} // end namespace itk


#endif



