#ifndef __vtkKWMyWindow_cxx
#define __vtkKWMyWindow_cxx

#define _CRT_SECURE_NO_WARNINGS

#include "vtkKWMyWindow.h"
#include "vtkObjectFactory.h"
#include "vtkDoubleArray.h"
#include "vtkKWMenu.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkKWApplication.h"
#include "vtkKWFrameWithLabel.h"
#include "itkGDCMImageIO.h"
#include "vtkKWFileBrowserDialog.h"
#include "itkImageSeriesReader.h"
#include "itkGDCMSeriesFileNames.h"
#include "SiemensRdaReader.h"
#include "GridCalculation.h"
#include "vtkCellData.h"
#include "KMeansTissueClassifier.h"
#include "BayesianClassifierBrainCSI.h"
#include "LCModelReader.h"
#include "vtkKWMenuButtonWithSpinButtons.h"
#include "itkImageFileWriter.h"
#include "vtkKWMenuButton.h"
#include "itkCastImageFilter.h"
#include "BRAINSMushPrimary.h"
#include "itkBinaryThresholdImageFilter.h"
#include "itkComplexToRealImageFilter.h"
#include "vtkKWMenuButtonWithLabel.h"
#include "vtkSmartPointer.h"
#include "vtkGeometryFilter.h"
#include "vtkPolyDataWriter.h"
#include "vtkPolyData.h"
#include "vtkXMLStructuredGridWriter.h"
#include "vtkXMLStructuredGridReader.h"
#include "vtkKWMessageDialog.h"
#include <itkMaskImageFilter.h>
#include "vtkCellData.h"
#include "itkNormalizeToConstantImageFilter.h"
//#include "itkFFTPadImageFilter.h"

//#include "itkLabelStatisticsImageFilter.h"
//#include "itkImageFileReader.h"

#include "itkCastImageFilter.h"

#include "vtkCellPicker.h"
#include "vtkKWIcon.h"

#include <sstream>

/**************************************************************************************************************************/
vtkStandardNewMacro( vtkKWMyWindow );
vtkCxxRevisionMacro(vtkKWMyWindow, "$Revision: 1.3 $");
/**************************************************************************************************************************/
vtkKWMyWindow::vtkKWMyWindow()
{
	/*this->testDir = "E:\\Development\\braincsi\\Testing\\";
	this->T1folder = "T1-MPRAGE\\";
	this->T2folder = "T2-TSE\\";
	this->T1file = "MR_0004_0001.dcm";
	this->T2file = "MR_0003_0001.dcm";
	this->RDAfile = "CSI-WS.rda";*/

	//this->CSScale = vtkKWScale::New();
	this->ChemicalShift = vtkTransform::New();
	this->deltaR = 0;
	//this->SGrid = vtkStructuredGrid::New();
	//this->PVGrid = vtkStructuredGrid::New();

//	this->GridOrigin = new double[3];

	this->SGridSpacing = new double[3]; 

//	m_Shift = 0;
	this->RefChemShift = 2.01;  //Assume we start at NAA
	this->CurrentMetabolite = this->RefChemShift;


	this->Viewer = new CSIDisplay();
	this->FileManager = vtkKWTree::New();
	
	this->Names = vtkStringArray::New();
	
	this->MetaboliteList = NULL; //vtkKWComboBox::New();
	this->MetabMapChoice = NULL;
	this->ComponentChoice = NULL;
	this->MetabRange = NULL;
	
	this->CurrentGrid = NULL;
	this->CurrentImage = vtkKWImage::New();
	this->KMeansImage = vtkKWImage::New();
	this->SamplePlugImage = vtkKWImage::New();
	this->ClassifiedImage = vtkKWImage::New();
	this->T1Map = vtkKWImage::New();
	this->T2Map = vtkKWImage::New();
	
	this->PickListBox = NULL; //vtkKWListBoxWithScrollbars::New();
	this->PickButton = vtkKWCheckButton::New();
	this->DrawButton = vtkKWCheckButton::New();

	this->Pickcallback = PickCellCallBack::New();
	
	this->CurrentCSI = new CSIgrid();

}//end Constructor
/**************************************************************************************************************************/
vtkKWMyWindow::~vtkKWMyWindow()
{
		
}//end Destructor
/**************************************************************************************************************************/
void vtkKWMyWindow::CreateWidget()
{

	// Check if already created
	if (this->IsCreated())
	{
		vtkErrorMacro("class already created");
		return;
	}

	// Call the superclass to create the whole widget
	this->Superclass::CreateWidget();
	vtkKWApplication *app = this->GetApplication();

	//Not using Main Panel, so hiding it for now.
	this->SetMainPanelVisibility(1);

	/**********************************************************/
	//Add Menu Commands
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "Load Series Image...", this, "LoadSeriesFile" );	
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "Load Image...", this, "LoadFile" );
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "Load RDA...", this, "LoadRDA" );
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "Load T1 Image...", this, "LoadT1Image" );
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "Load T2 Image...", this, "LoadT2Image" );	
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "Load Mask...", this, "LoadMask" );
	
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "Load LCModel Data...", this, "LoadLCModel" );
//	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "Display Picked Cells...", this, "DisplayPickedCells" );
	
//	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "Test...", this, "Test" );
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "Calculate...", this, "Calculate" );
	//this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "Load T2 Map...", this, "LoadT2Map" );
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "Load Classified Image...", this, "LoadClassifiedImage" );
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "Classify...", this, "Classify" );
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "CreateMask...", this, "CreateMask" );
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "LoadTransform...", this, "LoadTransform" );
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "RotateGrid...", this, "RotateGrid" );
	this->GetFileMenu()->InsertCommand( this->GetFileMenuInsertPosition(), "ClassifyScript...", this, "ClassifyScript" );
	

	/***********************************************************/
	// Add a render widget, attach it to the view frame, and pack
	if (!this->Viewer->RenderWidget)
	{
		this->Viewer->RenderWidget = vtkKWRenderWidget::New();
	}
	this->Viewer->RenderWidget->SetParent(this->GetViewFrame());
	this->Viewer->RenderWidget->Create();
	this->Viewer->RenderWidget->CornerAnnotationVisibilityOn();
	this->Viewer->RenderWidget->GetRenderWindowInteractor()->Start();
			
	app->Script("pack %s -expand y -fill both -anchor c -expand y", 
				this->Viewer->RenderWidget->GetWidgetName());

	/**********************************************************/
	//Allocate a blank Image to use as placeholder
	ImageType::Pointer blankImage = ImageType::New();
	ImageType::RegionType region;
	
	ImageType::SizeType size;
	size[0] = 100;
	size[1] = 100;
	size[2] = 20;
	
	ImageType::SpacingType spacing;
	spacing[0] = 1;
	spacing[1] = 1;
	spacing[2] = 1;

	ImageType::DirectionType direction;
	direction.SetIdentity();
	blankImage->SetDirection(direction);

	double origin[3] = {0,0,0};
	blankImage->SetOrigin(origin);

	region.SetSize(size);
	blankImage->SetRegions(region);
	blankImage->SetSpacing(spacing);

	blankImage->Allocate();
	blankImage->FillBuffer(0);
	blankImage->Update();
	
	vtkKWImage *blankKWImage = vtkKWImage::New();
	blankKWImage->SetITKImageBase(blankImage);

	//Send blank image to the Image Viewer class
	this->Viewer->SetImage(blankKWImage);
	this->Viewer->DisplayImage();
	
	/**********************************************************/
	//Add a File Manager widget.  
	vtkKWFrameWithLabel *frame2 = vtkKWFrameWithLabel::New();
	frame2->SetParent(this->GetMainPanelFrame() );
	frame2->Create();
	frame2->SetLabelText("File Manager");
	app->Script("pack %s -fill x -side top -anchor nw -expand n -padx 2 -pady 6", 
					frame2->GetWidgetName());

	this->FileManager->SetParent( frame2->GetFrame() );
	this->FileManager->Create();
	this->FileManager->SelectionFillOn();
	this->FileManager->SetBorderWidth(2);
	this->FileManager->SetReliefToGroove();
	this->FileManager->AddNode(NULL, "image_node", "Images");
	this->FileManager->SetNodeFontWeightToBold("image_node");
	this->FileManager->SetNodeSelectableFlag("image_node", 0);
	this->FileManager->OpenTree("image_node");
	this->FileManager->AddNode(NULL, "grid_node", "Spectroscopy Grids");
	this->FileManager->OpenTree("grid_node");
	this->FileManager->SetNodeFontWeightToBold("grid_node");
	this->FileManager->SetNodeSelectableFlag("grid_node", 0);
	//this->FileManager->SetSelectionChangedCommand(this, "FileSelectionChangedCallback");
	//this->FileManager->SetDoubleClickOnNodeCommand(this, "DoubleClickFileCallback");
	app->Script( "pack %s -fill x -side top -anchor nw -expand n -padx 2 -pady 2", 
		this->FileManager->GetWidgetName()); 

	  /**********************************************************/

} //end CreateWidget
/**************************************************************************************************************************/
void vtkKWMyWindow::LoadSeriesFile()
{
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\loadseriesfile.txt");
	//clock_t time;
	//time = clock();

	vtkKWApplication *app = this->GetApplication();
	vtkKWImageIO * dicomIO = vtkKWImageIO::New();
	vtkKWImage * dicomImage = vtkKWImage::New();
	/***********************************************************************/
	//Call FileBrowser Dialog Box:: Could put in its own function
	vtkKWFileBrowserDialog *dlg = vtkKWFileBrowserDialog::New();
	dlg->SetApplication(app);
	dlg->Create();
	dlg->SetFileTypes("{{All files} {.*}} {{Text Document} {.txt}} {{JPEG image} {.jpg .jpeg}}");

	// Invoke the dialog
	dlg->RetrieveLastPathFromRegistry("LastPath");
	dlg->ChooseDirectoryOn();
	dlg->Invoke();
	
	if (dlg->GetStatus()==vtkKWDialog::StatusOK)
	{
		//string test = dlg->GetFileName();
		dlg->SaveLastPathToRegistry("LastPath");
		string dName = dlg->GetFileName();
		//dName = dName + "/";
		string fileName =	dlg->GetInitialFileName();
		dicomIO->SetFileName(fileName);
		
		dicomIO->SetDirectory(dName);

		try
		{
			dicomIO->ReadImageSeries();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		dicomImage = dicomIO->HarvestReadImage();
		/************************************************************************/

		ImageType::Pointer temp = ImageType::New();
		temp = GetITK(dicomImage);
		dicomImage->SetITKImageBase(temp);

		this->CurrentImage = dicomImage; //resampleFilter->GetOutput();
		
		this->Viewer->SetImage(dicomImage);
		this->Viewer->DisplayImage();	
	
		/************************************************************************/
		AnatomicalImage image;
		image.SetImage(dicomImage);

//		char display[50];
		//sprintf(display, "Image%d", this->AnatomicalImages.size());

		string dirName = dlg->GetLastPath();

		int size = dirName.length();

		string ext;
		string name;
		string folder;
		int tmp = size;
		for (int i = size-1; i >= 0; i--)
		{
			/*
			if( fileName.substr(i,1).compare(".")==0 && ext.empty() )
			{
				ext = fileName.substr(i+1,tmp-i);
				tmp = i-1;
			}*/
			if( dirName.substr(i,1).compare("/")==0 && !dirName.substr(i,1).compare("\\")==0 )
			{
				/*if (name.empty()) 
				{
					name = fileName.substr(i+1,tmp-i);
					tmp = i-1;
				}
				else 
				*/	
				if (folder.empty())
				{
					folder = dirName.substr(i+1,tmp-i);
					tmp = i-1;
				}
			}
	
		}

		image.SetDisplayName(fileName.c_str());
		this->AnatomicalImages.push_back(image);

		this->FileManager->AddNode("image_node",fileName.c_str(), fileName.c_str());
		//this->FileManager->SetNodeImageToPredefinedIcon(display,vtkKWIcon::IconSilkEye);
		this->FileManager->SetNodePadX(fileName.c_str(),18);

		vtkKWPushButton *visible_button = vtkKWPushButton::New();
		visible_button->SetParent(this->FileManager);
		visible_button->Create();
		visible_button->SetBorderWidth(0);
		visible_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetImageToPredefinedIcon( 20021);
		char command[100];
		strcpy(command, "ChangeImageVisibility ");
		strcat(command, folder.c_str());
		visible_button->SetCommand( this, command);
		this->FileManager->SetNodeWindow(fileName.c_str(), visible_button);
		/************************************************************************/
		ChangeImageVisibility(fileName.c_str());
	}	

	//time = clock() - time;
	//debugStream <<"Time elapsed: "<<time/CLOCKS_PER_SEC << std::endl;
	//debugStream.close();

}//end Load Image
/**************************************************************************************************************************/
void vtkKWMyWindow::LoadFile()
{
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\loadfile.txt");

	vtkKWApplication *app = this->GetApplication();
	vtkKWImageIO * dicomIO = vtkKWImageIO::New();
	vtkKWImage * dicomImage = vtkKWImage::New();
	/***********************************************************************/
	//Call FileBrowser Dialog Box:: Could put in its own function
	vtkKWFileBrowserDialog *dlg = vtkKWFileBrowserDialog::New();
	dlg->SetApplication(app);
	dlg->Create();
	dlg->SetFileTypes("{{All files} {.*}} {{Text Document} {.txt}} {{JPEG image} {.jpg .jpeg}}");
	// Invoke the dialog
	dlg->RetrieveLastPathFromRegistry("LastPath");
	dlg->Invoke();

	if (dlg->GetStatus()==vtkKWDialog::StatusOK)
	{
		dlg->SaveLastPathToRegistry("LastPath");
		char * fileName = dlg->GetFileName();

		dicomIO->SetFileName(fileName);
		dicomIO->SetDirectory(dlg->GetLastPath());

		try
		{
			dicomIO->ReadImage();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		dicomImage = dicomIO->HarvestReadImage();

		ImageType::Pointer temp = ImageType::New();
		temp = GetITK(dicomImage);
		dicomImage->SetITKImageBase(temp);
	
		/**********************************************************************************/
		this->CurrentImage = dicomImage; 
		//Display the resampled image.
		this->Viewer->SetImage(this->CurrentImage);
		this->Viewer->DisplayImage();
		this->Viewer->RenderWidget->Render(); 
		/**********************************************************************************/
		AnatomicalImage image;
		image.SetImage(dicomImage);

		char display[50];
		//sprintf(display, "Image%d", this->AnatomicalImages.size());

		char * pch;
		pch = strtok(fileName,"/\\");
		while (pch != NULL)
		{
			pch = strtok (NULL, "\\/");
			if (pch) strcpy(display,pch);
		}
	
		image.SetDisplayName(display);
		this->AnatomicalImages.push_back(image);

		this->FileManager->AddNode("image_node",display, display);
		//this->FileManager->SetNodeImageToPredefinedIcon(display,vtkKWIcon::IconSilkEye);
		this->FileManager->SetNodePadX(display,18);

		vtkKWPushButton *visible_button = vtkKWPushButton::New();
		visible_button->SetParent(this->FileManager);
		visible_button->Create();
		visible_button->SetBorderWidth(0);
		visible_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetImageToPredefinedIcon( 20021);
		char command[100];
		strcpy(command, "ChangeImageVisibility ");
		strcat(command, display);
		visible_button->SetCommand( this, command);
		this->FileManager->SetNodeWindow(display, visible_button);
		/**********************************************************************************/
		ChangeImageVisibility(display);

	}
	//debugStream.close();
}//end Load Image
/**************************************************************************************************************************/
vtkKWImage * vtkKWMyWindow::LoadFile(char* dirName, char* fileName)
{
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\loadfile.txt");
	vtkKWImageIO * dicomIO = vtkKWImageIO::New();
	vtkKWImage * dicomImage = vtkKWImage::New();

	ReaderType::Pointer reader = ReaderType::New();
	

	/**********************************************************************************/
	//Auto Load an image
	char fName[1024] = ""; 
	char dName[1024] = ""; 
	
	strcpy(dName, dirName);
	strcpy(fName, dName );
	strcat(fName, fileName);
	
	dicomIO->SetFileName(fName);
	dicomIO->SetDirectory(dName);
	reader->SetFileName(fName);

	try
	{
	//	dicomIO->ReadImage();
		reader->Update();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
	//dicomImage = dicomIO->HarvestReadImage();

	//ImageType::Pointer temp = ImageType::New();
	//temp = GetITK(dicomImage);
	//dicomImage->SetITKImageBase(temp);

	dicomImage->SetITKImageBase(reader->GetOutput());

	return dicomImage;

}//end Load Image
/**************************************************************************************************************************/
vtkKWImage * vtkKWMyWindow::LoadSeriesFile(char* dirName, char* fileName)
{
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\loadfile.txt");

	vtkKWApplication *app = this->GetApplication();
	vtkKWImageIO * dicomIO = vtkKWImageIO::New();
	vtkKWImage * dicomImage = vtkKWImage::New();
	/**********************************************************************************/
	//Auto Load an image
	char fName[100] = ""; 
	char dName[100] = ""; 
	
	strcpy(dName, dirName);
	strcpy(fName, dName);
	strcat(fName, fileName);
	
	dicomIO->SetFileName(fName);
	dicomIO->SetDirectory(dName);
	dicomIO->ReadImageSeries();
	dicomImage = dicomIO->HarvestReadImage();
	/********************************************************************************/
	ImageType::Pointer temp = ImageType::New();
	temp = GetITK(dicomImage);
	dicomImage->SetITKImageBase(temp);
	return dicomImage;
	//debugStream.close();

}//end Load Image
/**************************************************************************************************************************/
void vtkKWMyWindow::LoadT2Map()
{
	vtkKWApplication *app = this->GetApplication();
	vtkKWFileBrowserDialog *dlg = vtkKWFileBrowserDialog::New();
	dlg->SetApplication(app);
	dlg->Create();
	dlg->SetFileTypes("{{All files} {.*}}");

	// Invoke the dialog
	dlg->RetrieveLastPathFromRegistry("LastPath");
	dlg->ChooseDirectoryOn();
	dlg->Invoke();
	
	if (dlg->GetStatus()==vtkKWDialog::StatusOK)
	{
		//string test = dlg->GetFileName();
		dlg->SaveLastPathToRegistry("LastPath");
		string dName = dlg->GetFileName();
		//dName = dName + "/";
//		string fileName =	dlg->GetInitialFileName();
	
		std::string inputDirectory = dName;
		int algorithm = 0;
		double maxT2Time = 5000.0;

		LoadSEMCImages * loadSEMC = new LoadSEMCImages();
		loadSEMC->SetDirectory(inputDirectory);
		loadSEMC->SetAlgorithm(algorithm);
		loadSEMC->SetMaxT2Time(maxT2Time);
		loadSEMC->Update();

//		std::vector<vtkKWImage *> allImages;
//		std::vector<double> allEchoes;
//		allImages = loadSEMC->GetAllImages();
//		allEchoes = loadSEMC->GetEchoTimes();

		//vtkKWImage * Aimage= vtkKWImage::New();
		//vtkKWImage * Cimage= vtkKWImage::New();
		//vtkKWImage * Errorimage = vtkKWImage::New();

		this->T2Map = loadSEMC->GetT2Map();

		this->Viewer->SetImage(this->T2Map);
		this->Viewer->DisplayImage();	

	/************************************************************************/
		AnatomicalImage image;
		image.SetImage(this->T2Map);
		string fileName = "T2Map";

//		char display[50];
		//sprintf(display, "Image%d", this->AnatomicalImages.size());

		//string dirName = dlg->GetLastPath();

		//int size = dirName.length();

		//string ext;
		//string name;
		//string folder;
		//int tmp = size;
		//for (int i = size-1; i >= 0; i--)
		//{
		//	/*
		//	if( fileName.substr(i,1).compare(".")==0 && ext.empty() )
		//	{
		//		ext = fileName.substr(i+1,tmp-i);
		//		tmp = i-1;
		//	}*/
		//	if( dirName.substr(i,1).compare("/")==0 && !dirName.substr(i,1).compare("\\")==0 )
		//	{
		//		/*if (name.empty()) 
		//		{
		//			name = fileName.substr(i+1,tmp-i);
		//			tmp = i-1;
		//		}
		//		else 
		//		*/	
		//		if (folder.empty())
		//		{
		//			folder = dirName.substr(i+1,tmp-i);
		//			tmp = i-1;
		//		}
		//	}
	
		//}

		image.SetDisplayName(fileName.c_str());
		this->AnatomicalImages.push_back(image);

		this->FileManager->AddNode("image_node",fileName.c_str(), fileName.c_str());
		//this->FileManager->SetNodeImageToPredefinedIcon(display,vtkKWIcon::IconSilkEye);
		this->FileManager->SetNodePadX(fileName.c_str(),18);

		vtkKWPushButton *visible_button = vtkKWPushButton::New();
		visible_button->SetParent(this->FileManager);
		visible_button->Create();
		visible_button->SetBorderWidth(0);
		visible_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetImageToPredefinedIcon( 20021);
		char command[100];
		strcpy(command, "ChangeImageVisibility ");
		strcat(command, fileName.c_str());
		visible_button->SetCommand( this, command);
		this->FileManager->SetNodeWindow(fileName.c_str(), visible_button);
		/************************************************************************/
		ChangeImageVisibility(fileName.c_str());

	/***********************************************/
	vtkKWImageIO * KWwriter = vtkKWImageIO::New();
	KWwriter->SetFileName("output\\t2Map.nii");
	KWwriter->SetImageToBeWritten( this->T2Map );
	try
	{
		KWwriter->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
	/***********************************************/

	}
}
/**************************************************************************************************************************/
void vtkKWMyWindow::LoadT1Map()
{
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\loadseriesfile.txt");
	//clock_t time;
	//time = clock();

	vtkKWApplication *app = this->GetApplication();
	vtkKWImageIO * dicomIO = vtkKWImageIO::New();
	vtkKWImage * temp = vtkKWImage::New();
	/***********************************************************************/
	//Call FileBrowser Dialog Box:: Could put in its own function
	vtkKWFileBrowserDialog *dlg = vtkKWFileBrowserDialog::New();
	dlg->SetApplication(app);
	dlg->Create();
	dlg->SetFileTypes("{{All files} {.*}} {{Text Document} {.txt}} {{JPEG image} {.jpg .jpeg}}");

	// Invoke the dialog
	dlg->RetrieveLastPathFromRegistry("LastPath");
	dlg->ChooseDirectoryOn();
	dlg->Invoke();
	
	if (dlg->GetStatus()==vtkKWDialog::StatusOK)
	{
		//string test = dlg->GetFileName();
		dlg->SaveLastPathToRegistry("LastPath");
		string dName = dlg->GetFileName();
		//dName = dName + "/";
		string fileName =	dlg->GetInitialFileName();
		dicomIO->SetFileName(fileName);
		
		dicomIO->SetDirectory(dName);

		try
		{
			dicomIO->ReadImageSeries();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		this->T1Map = dicomIO->HarvestReadImage();
		/************************************************************************/
		
		this->Viewer->SetImage(this->T1Map);
		this->Viewer->DisplayImage();	
	
		/************************************************************************/
		AnatomicalImage image;
		image.SetImage(this->T1Map);
		fileName = "T1Map";
//		char display[50];
		//sprintf(display, "Image%d", this->AnatomicalImages.size());

		//string dirName = dlg->GetLastPath();

		//int size = dirName.length();

		//string ext;
		//string name;
		//string folder;
		//int tmp = size;
		//for (int i = size-1; i >= 0; i--)
		//{
		//	/*
		//	if( fileName.substr(i,1).compare(".")==0 && ext.empty() )
		//	{
		//		ext = fileName.substr(i+1,tmp-i);
		//		tmp = i-1;
		//	}*/
		//	if( dirName.substr(i,1).compare("/")==0 && !dirName.substr(i,1).compare("\\")==0 )
		//	{
		//		/*if (name.empty()) 
		//		{
		//			name = fileName.substr(i+1,tmp-i);
		//			tmp = i-1;
		//		}
		//		else 
		//		*/	
		//		if (folder.empty())
		//		{
		//			folder = dirName.substr(i+1,tmp-i);
		//			tmp = i-1;
		//		}
		//	}
	
		//}

		image.SetDisplayName(fileName.c_str());
		this->AnatomicalImages.push_back(image);

		this->FileManager->AddNode("image_node",fileName.c_str(), fileName.c_str());
		//this->FileManager->SetNodeImageToPredefinedIcon(display,vtkKWIcon::IconSilkEye);
		this->FileManager->SetNodePadX(fileName.c_str(),18);

		vtkKWPushButton *visible_button = vtkKWPushButton::New();
		visible_button->SetParent(this->FileManager);
		visible_button->Create();
		visible_button->SetBorderWidth(0);
		visible_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetImageToPredefinedIcon( 20021);
		char command[100];
		strcpy(command, "ChangeImageVisibility ");
		strcat(command, fileName.c_str());
		visible_button->SetCommand( this, command);
		this->FileManager->SetNodeWindow(fileName.c_str(), visible_button);
		/************************************************************************/
		ChangeImageVisibility(fileName.c_str());
	}	

	//time = clock() - time;
	//debugStream <<"Time elapsed: "<<time/CLOCKS_PER_SEC << std::endl;
	//debugStream.close();

	/***********************************************/
	vtkKWImageIO * KWwriter = vtkKWImageIO::New();
	KWwriter->SetFileName("output\\t1Map.nii");
	KWwriter->SetImageToBeWritten( this->T1Map );
	try
	{
		KWwriter->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
	/***********************************************/

}//end Load Image
/**************************************************************************************************************************/
void vtkKWMyWindow::LoadT1Image()
{
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\loadseriesfile.txt");
	//clock_t time;
	//time = clock();

	vtkKWApplication *app = this->GetApplication();
	vtkKWImageIO * dicomIO = vtkKWImageIO::New();
	vtkKWImage * dicomImage = vtkKWImage::New();
	/***********************************************************************/
	//Call FileBrowser Dialog Box:: Could put in its own function
	vtkKWFileBrowserDialog *dlg = vtkKWFileBrowserDialog::New();
	dlg->SetApplication(app);
	dlg->Create();
	dlg->SetFileTypes("{{All files} {.*}} {{Text Document} {.txt}} {{JPEG image} {.jpg .jpeg}}");

	// Invoke the dialog
	dlg->RetrieveLastPathFromRegistry("LastPath");
	//dlg->ChooseDirectoryOn();
	dlg->Invoke();
	
	if (dlg->GetStatus()==vtkKWDialog::StatusOK)
	{
		//string test = dlg->GetFileName();
		dlg->SaveLastPathToRegistry("LastPath");
		string fileName =	dlg->GetInitialFileName();
		/**************************************
		//When File is a Dicom Series
		string dName = dlg->GetFileName();
		//dName = dName + "/";
		
		dicomIO->SetFileName(fileName);
		
		dicomIO->SetDirectory(dName);

		try
		{
			dicomIO->ReadImageSeries();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		/*****************************************************/
		//When it's an .nii file
		char * fname = dlg->GetFileName();
		dicomIO->SetFileName(fname);
		dicomIO->SetDirectory(dlg->GetLastPath());
		try
		{
			dicomIO->ReadImage();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		
		this->T1Image = dicomIO->HarvestReadImage();
		/************************************************************************/
		this->Viewer->SetImage(this->T1Image);
		this->Viewer->DisplayImage();	
		
		/***********************************************
		vtkKWImageIO * KWwriter2 = vtkKWImageIO::New();
		KWwriter2->SetFileName("E:\\Development\\output\\t1Image.nii");
		KWwriter2->SetImageToBeWritten(this->T1Image);
		try
		{
			KWwriter2->WriteImage();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		/***********************************************/

	
		/************************************************************************/
		AnatomicalImage image;
		image.SetImage(this->T1Image);

//		char display[50];
		//sprintf(display, "Image%d", this->AnatomicalImages.size());

		string dirName = dlg->GetLastPath();

		int size = dirName.length();

		string ext;
		string name;
		string folder;
		int tmp = size;
		for (int i = size-1; i >= 0; i--)
		{
			/*
			if( fileName.substr(i,1).compare(".")==0 && ext.empty() )
			{
				ext = fileName.substr(i+1,tmp-i);
				tmp = i-1;
			}*/
			if( dirName.substr(i,1).compare("/")==0 && !dirName.substr(i,1).compare("\\")==0 )
			{
				/*if (name.empty()) 
				{
					name = fileName.substr(i+1,tmp-i);
					tmp = i-1;
				}
				else 
				*/	
				if (folder.empty())
				{
					folder = dirName.substr(i+1,tmp-i);
					tmp = i-1;
				}
			}
	
		}

		fileName = "T1w";

		image.SetDisplayName(fileName.c_str());
		this->AnatomicalImages.push_back(image);

		this->FileManager->AddNode("image_node",fileName.c_str(), fileName.c_str());
		//this->FileManager->SetNodeImageToPredefinedIcon(display,vtkKWIcon::IconSilkEye);
		this->FileManager->SetNodePadX(fileName.c_str(),18);

		vtkKWPushButton *visible_button = vtkKWPushButton::New();
		visible_button->SetParent(this->FileManager);
		visible_button->Create();
		visible_button->SetBorderWidth(0);
		visible_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetImageToPredefinedIcon( 20021);
		char command[100];
		strcpy(command, "ChangeImageVisibility ");
		strcat(command, fileName.c_str());
		visible_button->SetCommand( this, command);
		this->FileManager->SetNodeWindow(fileName.c_str(), visible_button);
		/************************************************************************/
		ChangeImageVisibility(fileName.c_str());
	}	

	//time = clock() - time;
	//debugStream <<"Time elapsed: "<<time/CLOCKS_PER_SEC << std::endl;
	//debugStream.close();

}//end Load Image
/**************************************************************************************************************************/
void vtkKWMyWindow::LoadT2Image()
{
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\loadseriesfile.txt");
	//clock_t time;
	//time = clock();

	vtkKWApplication *app = this->GetApplication();
	vtkKWImageIO * dicomIO = vtkKWImageIO::New();
	vtkKWImage * dicomImage = vtkKWImage::New();
	/***********************************************************************/
	//Call FileBrowser Dialog Box:: Could put in its own function
	vtkKWFileBrowserDialog *dlg = vtkKWFileBrowserDialog::New();
	dlg->SetApplication(app);
	dlg->Create();
	dlg->SetFileTypes("{{All files} {.*}} {{Text Document} {.txt}} {{JPEG image} {.jpg .jpeg}}");

	// Invoke the dialog
	dlg->RetrieveLastPathFromRegistry("LastPath");
	//dlg->ChooseDirectoryOn();
	dlg->Invoke();
	
	if (dlg->GetStatus()==vtkKWDialog::StatusOK)
	{
		//string test = dlg->GetFileName();
		dlg->SaveLastPathToRegistry("LastPath");
		string fileName =	dlg->GetInitialFileName();
		/*********************************************
		//When a Dicom Series
		string dName = dlg->GetFileName();
		//dName = dName + "/";
		
		dicomIO->SetFileName(fileName);
		
		dicomIO->SetDirectory(dName);

		try
		{
			dicomIO->ReadImageSeries();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		/******************************************************/
		//When it's a .nii file		
		char * fName = dlg->GetFileName();
		dicomIO->SetFileName(fName);
		dicomIO->SetDirectory(dlg->GetLastPath());

		try
		{
			dicomIO->ReadImage();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		
		this->T2Image = dicomIO->HarvestReadImage();
		/************************************************************************/

		this->Viewer->SetImage(this->T2Image);
		this->Viewer->DisplayImage();	

		/***********************************************
		vtkKWImageIO * KWwriter2 = vtkKWImageIO::New();
		KWwriter2->SetFileName("E:\\Development\\output\\t2Image.nii");
		KWwriter2->SetImageToBeWritten(this->T2Image);
		try
		{
			KWwriter2->WriteImage();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		/***********************************************/
	
		/************************************************************************/
		AnatomicalImage image;
		image.SetImage(this->T2Image);

//		char display[50];
		//sprintf(display, "Image%d", this->AnatomicalImages.size());

		string dirName = dlg->GetLastPath();

		int size = dirName.length();

		string ext;
		string name;
		string folder;
		int tmp = size;
		for (int i = size-1; i >= 0; i--)
		{
			/*
			if( fileName.substr(i,1).compare(".")==0 && ext.empty() )
			{
				ext = fileName.substr(i+1,tmp-i);
				tmp = i-1;
			}*/
			if( dirName.substr(i,1).compare("/")==0 && !dirName.substr(i,1).compare("\\")==0 )
			{
				/*if (name.empty()) 
				{
					name = fileName.substr(i+1,tmp-i);
					tmp = i-1;
				}
				else 
				*/	
				if (folder.empty())
				{
					folder = dirName.substr(i+1,tmp-i);
					tmp = i-1;
				}
			}
	
		}

		fileName = "T2w";

		image.SetDisplayName(fileName.c_str());
		this->AnatomicalImages.push_back(image);

		this->FileManager->AddNode("image_node",fileName.c_str(), fileName.c_str());
		//this->FileManager->SetNodeImageToPredefinedIcon(display,vtkKWIcon::IconSilkEye);
		this->FileManager->SetNodePadX(fileName.c_str(),18);

		vtkKWPushButton *visible_button = vtkKWPushButton::New();
		visible_button->SetParent(this->FileManager);
		visible_button->Create();
		visible_button->SetBorderWidth(0);
		visible_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetImageToPredefinedIcon( 20021);
		char command[100];
		strcpy(command, "ChangeImageVisibility ");
		strcat(command, fileName.c_str());
		visible_button->SetCommand( this, command);
		this->FileManager->SetNodeWindow(fileName.c_str(), visible_button);
		/************************************************************************/
		ChangeImageVisibility(fileName.c_str());
	}	

	//time = clock() - time;
	//debugStream <<"Time elapsed: "<<time/CLOCKS_PER_SEC << std::endl;
	//debugStream.close();

}//end Load Image
/**************************************************************************************************************************/
void vtkKWMyWindow::LoadMask()
{
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\loadseriesfile.txt");
	//clock_t time;
	//time = clock();

	vtkKWApplication *app = this->GetApplication();
	vtkKWImageIO * dicomIO = vtkKWImageIO::New();
	vtkKWImage * dicomImage = vtkKWImage::New();
	/***********************************************************************/
	//Call FileBrowser Dialog Box:: Could put in its own function
	vtkKWFileBrowserDialog *dlg = vtkKWFileBrowserDialog::New();
	dlg->SetApplication(app);
	dlg->Create();
	dlg->SetFileTypes("{{All files} {.*}} {{Text Document} {.txt}} {{JPEG image} {.jpg .jpeg}}");

	// Invoke the dialog
	dlg->RetrieveLastPathFromRegistry("LastPath");
	//dlg->ChooseDirectoryOn();
	dlg->Invoke();
	
	if (dlg->GetStatus()==vtkKWDialog::StatusOK)
	{
		//string test = dlg->GetFileName();
		dlg->SaveLastPathToRegistry("LastPath");
		string fileName =	dlg->GetInitialFileName();
		/**************************************
		//When File is a Dicom Series
		string dName = dlg->GetFileName();
		//dName = dName + "/";
		
		dicomIO->SetFileName(fileName);
		
		dicomIO->SetDirectory(dName);

		try
		{
			dicomIO->ReadImageSeries();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		/*****************************************************/
		//When it's an .nii file
		char * fname = dlg->GetFileName();
		dicomIO->SetFileName(fname);
		dicomIO->SetDirectory(dlg->GetLastPath());
		try
		{
			dicomIO->ReadImage();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		
		this->CurrentMask = dicomIO->HarvestReadImage();
		/************************************************************************/
		this->Viewer->SetImage(this->CurrentMask);
		this->Viewer->DisplayImage();	
		
		/************************************************************************/
		AnatomicalImage image;
		image.SetImage(this->CurrentMask);

//		char display[50];
		//sprintf(display, "Image%d", this->AnatomicalImages.size());

		string dirName = dlg->GetLastPath();

		int size = dirName.length();

		string ext;
		string name;
		string folder;
		int tmp = size;
		for (int i = size-1; i >= 0; i--)
		{
			/*
			if( fileName.substr(i,1).compare(".")==0 && ext.empty() )
			{
				ext = fileName.substr(i+1,tmp-i);
				tmp = i-1;
			}*/
			if( dirName.substr(i,1).compare("/")==0 && !dirName.substr(i,1).compare("\\")==0 )
			{
				/*if (name.empty()) 
				{
					name = fileName.substr(i+1,tmp-i);
					tmp = i-1;
				}
				else 
				*/	
				if (folder.empty())
				{
					folder = dirName.substr(i+1,tmp-i);
					tmp = i-1;
				}
			}
	
		}

		fileName = "Mask";

		image.SetDisplayName(fileName.c_str());
		this->AnatomicalImages.push_back(image);

		this->FileManager->AddNode("image_node",fileName.c_str(), fileName.c_str());
		//this->FileManager->SetNodeImageToPredefinedIcon(display,vtkKWIcon::IconSilkEye);
		this->FileManager->SetNodePadX(fileName.c_str(),18);

		vtkKWPushButton *visible_button = vtkKWPushButton::New();
		visible_button->SetParent(this->FileManager);
		visible_button->Create();
		visible_button->SetBorderWidth(0);
		visible_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetImageToPredefinedIcon( 20021);
		char command[100];
		strcpy(command, "ChangeImageVisibility ");
		strcat(command, fileName.c_str());
		visible_button->SetCommand( this, command);
		this->FileManager->SetNodeWindow(fileName.c_str(), visible_button);
		/************************************************************************/
		ChangeImageVisibility(fileName.c_str());
	}	

	//time = clock() - time;
	//debugStream <<"Time elapsed: "<<time/CLOCKS_PER_SEC << std::endl;
	//debugStream.close();

}//end Load Image
/**************************************************************************************************************************/
void vtkKWMyWindow::LoadClassifiedImage()
{
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\loadseriesfile.txt");
	//clock_t time;
	//time = clock();

	vtkKWApplication *app = this->GetApplication();
	vtkKWImageIO * dicomIO = vtkKWImageIO::New();
	vtkKWImage * dicomImage = vtkKWImage::New();
	/***********************************************************************/
	//Call FileBrowser Dialog Box:: Could put in its own function
	vtkKWFileBrowserDialog *dlg = vtkKWFileBrowserDialog::New();
	dlg->SetApplication(app);
	dlg->Create();
	dlg->SetFileTypes("{{All files} {.*}} {{Text Document} {.txt}} {{JPEG image} {.jpg .jpeg}}");

	// Invoke the dialog
	dlg->RetrieveLastPathFromRegistry("LastPath");
	//dlg->ChooseDirectoryOn();
	dlg->Invoke();
	
	if (dlg->GetStatus()==vtkKWDialog::StatusOK)
	{
		//string test = dlg->GetFileName();
		dlg->SaveLastPathToRegistry("LastPath");
		string fileName =	dlg->GetInitialFileName();
		/**************************************
		//When File is a Dicom Series
		string dName = dlg->GetFileName();
		//dName = dName + "/";
		
		dicomIO->SetFileName(fileName);
		
		dicomIO->SetDirectory(dName);

		try
		{
			dicomIO->ReadImageSeries();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		/*****************************************************/
		//When it's an .nii file
		char * fname = dlg->GetFileName();
		dicomIO->SetFileName(fname);
		dicomIO->SetDirectory(dlg->GetLastPath());
		try
		{
			dicomIO->ReadImage();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		
		this->ClassifiedImage = dicomIO->HarvestReadImage();
		/************************************************************************/
		this->Viewer->SetImage(this->ClassifiedImage);
		this->Viewer->DisplayImage();	
		
		/***********************************************
		vtkKWImageIO * KWwriter2 = vtkKWImageIO::New();
		KWwriter2->SetFileName("E:\\Development\\output\\t1Image.nii");
		KWwriter2->SetImageToBeWritten(this->T1Image);
		try
		{
			KWwriter2->WriteImage();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}
		/***********************************************/

	
		/************************************************************************/
		AnatomicalImage image;
		image.SetImage(this->ClassifiedImage);

//		char display[50];
		//sprintf(display, "Image%d", this->AnatomicalImages.size());

		string dirName = dlg->GetLastPath();

		int size = dirName.length();

		string ext;
		string name;
		string folder;
		int tmp = size;
		for (int i = size-1; i >= 0; i--)
		{
			/*
			if( fileName.substr(i,1).compare(".")==0 && ext.empty() )
			{
				ext = fileName.substr(i+1,tmp-i);
				tmp = i-1;
			}*/
			if( dirName.substr(i,1).compare("/")==0 && !dirName.substr(i,1).compare("\\")==0 )
			{
				/*if (name.empty()) 
				{
					name = fileName.substr(i+1,tmp-i);
					tmp = i-1;
				}
				else 
				*/	
				if (folder.empty())
				{
					folder = dirName.substr(i+1,tmp-i);
					tmp = i-1;
				}
			}
	
		}

		fileName = "Classified";

		image.SetDisplayName(fileName.c_str());
		this->AnatomicalImages.push_back(image);

		this->FileManager->AddNode("image_node",fileName.c_str(), fileName.c_str());
		//this->FileManager->SetNodeImageToPredefinedIcon(display,vtkKWIcon::IconSilkEye);
		this->FileManager->SetNodePadX(fileName.c_str(),18);

		vtkKWPushButton *visible_button = vtkKWPushButton::New();
		visible_button->SetParent(this->FileManager);
		visible_button->Create();
		visible_button->SetBorderWidth(0);
		visible_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetImageToPredefinedIcon( 20021);
		char command[100];
		strcpy(command, "ChangeImageVisibility ");
		strcat(command, fileName.c_str());
		visible_button->SetCommand( this, command);
		this->FileManager->SetNodeWindow(fileName.c_str(), visible_button);
		/************************************************************************/
		ChangeImageVisibility(fileName.c_str());
	}	

	//time = clock() - time;
	//debugStream <<"Time elapsed: "<<time/CLOCKS_PER_SEC << std::endl;
	//debugStream.close();

}//end Load Classified
/**************************************************************************************************************************/
void vtkKWMyWindow::LoadCSI()
{

	vtkKWApplication *app = this->GetApplication();

	this->MetaboliteList->SetValue("NAA");
	//Hard coded
	char* fileName = "E:\\Development\\braincsi\\Testing\\CSI-WS.rda";

	CSIgrid *csi = new CSIgrid();
	csi->SetFileName(fileName);
	csi->Update();
	this->Spectroscopy.push_back(csi);
	//this->Viewer->SetGrid( csi.GetOutput() );
	this->Viewer->AddSpectroscopy( csi );
	this->Viewer->DisplayGrids();

}
/**************************************************************************************************************************/
void vtkKWMyWindow::LoadRDA()
{
	/**********		Load RDA File.	**********/
	vtkKWApplication *app = this->GetApplication();
	
	/**********	Get file name from Dialog Box.  **********/
	vtkKWFileBrowserDialog *dlg = vtkKWFileBrowserDialog::New();
	dlg->SetApplication(app);
	dlg->Create();
	dlg->SetFileTypes("{{All files} {.*}} {{Text Document} {.txt}} {{Spectroscopy} {.rda}}");
	dlg->RetrieveLastPathFromRegistry("LastPath");
	dlg->Invoke();
	char* fileName;

	if (dlg->GetStatus()==vtkKWDialog::StatusOK)
	{
		dlg->SaveLastPathToRegistry("LastPath");
		fileName = dlg->GetFileName();

		/****************************************************************
		CSIgrid *grid = new CSIgrid();
		grid->SetFileName(fileName);
		grid->Update();
		this->GridDirCos = grid->GetDirCos();
		this->SGridSpacing = grid->GetSpacing();
		/****************************************************************
		csFilter = vtkTransformFilter::New();
		csFilter->SetTransform(this->ChemicalShift);
		csFilter->SetInput(grid->GetOutput());
		csFilter->Update();
		this->SGrid = (vtkStructuredGrid *) csFilter->GetOutput();
		/**********************************************************************************/
		CSIgrid *csi = new CSIgrid();
		csi->SetFileName(fileName);
		csi->Update();

		this->CurrentCSI = csi;
		this->Viewer->AddSpectroscopy( csi );
		this->Spectroscopy.push_back(csi);
		
		char display[50];

		char * pch;
		pch = strtok (fileName,"/\\");
		while (pch != NULL)
		{
			pch = strtok (NULL, "\\/");
			if (pch) strcpy(display,pch);
		}
	
		csi->SetDisplayName(display);
		this->Spectroscopy.push_back(csi);
		/**********************************************************************************/
		this->FileManager->AddNode("grid_node",display, display);
		this->FileManager->SetNodePadX(display,18);
		
		vtkKWPushButton *visible_button = vtkKWPushButton::New();
		visible_button->SetParent(this->FileManager);
		visible_button->Create();
		visible_button->SetBorderWidth(0);
		visible_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetImageToPredefinedIcon(20021);
		this->FileManager->SetNodeWindow(display, visible_button);
		char command[100];
		strcpy(command, "ChangeGridVisibility ");
		strcat(command, display);
		visible_button->SetCommand( this, command);
		this->FileManager->SetNodeWindow(display, visible_button);
	
		/**********************************************************************************/
		this->CurrentGrid = csi->GetOutput();
		
		const char* metabolites[] = {"NAA", "GPC+PCh", "Cre"};
		
		if (!this->MetaboliteList)
		{
			/**********************************************************************************/
			// Create another menu button, this time with a label
			this->MetaboliteList = vtkKWComboBox::New();
			/**********************************************************************************/
			this->MetaboliteList->SetApplication(app);
			this->MetaboliteList->SetParent(this->GetMainPanelFrame());
			this->MetaboliteList->Create();
			this->MetaboliteList->SetWidth(20);
			this->MetaboliteList->ReadOnlyOn();
			this->MetaboliteList->SetBalloonHelpString("Select the metabolite for chemical shift");
			this->MetaboliteList->SetCommand(this, "SetChemicalShift");
			
			for (int i = 0; i < sizeof(metabolites) / sizeof(metabolites[0]); i++)
			{
				this->MetaboliteList->AddValue(metabolites[i]);
			}
			
			this->MetaboliteList->SetValue(metabolites[0]);
			app->Script( "pack %s -side top -anchor nw -expand n -padx 2 -pady 6",  this->MetaboliteList->GetWidgetName());
		}
		else
		{
			this->MetaboliteList->SetValue(metabolites[0]);
		}

		/**********************************************************/
		this->PickButton->SetParent(this->GetMainPanelFrame());
		this->PickButton->Create();
		this->PickButton->SetText("Pick Cells");
		//this->PickButton->SetImageToPredefinedIcon(vtkKWIcon::IconLock);
		this->PickButton->SetCompoundModeToLeft();
		this->PickButton->IndicatorVisibilityOff();
		this->PickButton->SetCommand(this, "SetPicking");
		SetPicking(0);

		app->Script( "pack %s -side top -anchor nw -expand n -padx 2 -pady 6", this->PickButton->GetWidgetName());

		this->DrawButton->SetParent(this->GetMainPanelFrame());
		this->DrawButton->Create();
		this->DrawButton->SetText("Draw Cells");
	  	this->DrawButton->SetCompoundModeToLeft();
		this->DrawButton->IndicatorVisibilityOff();
		this->DrawButton->SetCommand(this, "RedrawGrids");

		app->Script( "pack %s -side top -anchor nw -expand n -padx 2 -pady 6", this->DrawButton->GetWidgetName());

		this->Viewer->DisplayGrids();
		this->Viewer->RenderWidget->Render();
	}
	
}//end of LoadSiemensRDA
/**************************************************************************************************************************/
CSIgrid * vtkKWMyWindow::LoadRDA(char* fileName)
{
	//std::ofstream debugStream;
    //debugStream.open("E:\\Development\\output\\grid.txt");

	/**********		Load RDA File.	**********/
	vtkKWApplication *app = this->GetApplication();

	CSIgrid *csi= new CSIgrid();
	csi->SetFileName(fileName);
	csi->Update();
	this->Spectroscopy.push_back(csi);


	this->CurrentCSI = csi;
	this->Viewer->AddSpectroscopy( csi );
		
	return csi;
}//end of LoadSiemensRDA
/**************************************************************************************************************************/
void vtkKWMyWindow::TranslateGrid()
{
	this->Viewer->Spectroscopy->Shift(this->deltaR);
}
/**************************************************************************************************************************/
void vtkKWMyWindow::Calculate()
{
	CSIgrid * csi = new CSIgrid;
	csi = this->Spectroscopy[0];
   //Calculate Partial Volume
	vtkDataArray * pv = vtkDoubleArray::New();
	pv = Calculate(this->ClassifiedImage, csi);
		
	//Write out PV.txt file
	std::ofstream percentStream;
	percentStream.open("E:\\BrainCSI\\output\\PV.txt");

	percentStream <<"CellID, BG, CSF, Grey, White, Volume"<<endl;
		
	double * tupleOUT = NULL;
		
	for ( int cellId = 0; cellId < 32*32; cellId++ )
	{
 		tupleOUT = pv->GetTuple(cellId);
		percentStream <<cellId <<","<<tupleOUT[0]<<","<<tupleOUT[1]<<","<<tupleOUT[2]<<","<<tupleOUT[3]<<","<<tupleOUT[4]<<endl;
	}

	percentStream.close();

}
/**************************************************************************************************************************
void vtkKWMyWindow::SetCSFromScaleCallback(double value)
{
  //this->deltaR = value - m_Shift;
  //TranslateGrid(); 
  //m_Shift = value;
  //this->Viewer->RenderWidget->Render();
}
/**************************************************************************************************************************/
vtkDataArray * vtkKWMyWindow::Calculate(vtkKWImage * classifiedImage, CSIgrid * csi)
{

	/***********************************************************************/
	ImageProcessing * bgFilter = new ImageProcessing();	
	ImageProcessing * whiteFilter = new ImageProcessing();	
	ImageProcessing * greyFilter = new ImageProcessing();
	ImageProcessing * csfFilter = new ImageProcessing();

	vtkKWImage * bgImage = vtkKWImage::New();		
	vtkKWImage * csfImage = vtkKWImage::New();	
	vtkKWImage * greyImage = vtkKWImage::New();
	vtkKWImage * whiteImage = vtkKWImage::New();
	
	vtkDataArray *pVolume = vtkDoubleArray::New(); 
		
	pVolume->SetNumberOfComponents(7);
	pVolume->SetNumberOfTuples(1024);
	pVolume->SetName("Tissue");
	
	for (int a = 0; a < 7; a++)
	{
		pVolume->FillComponent(a,0);
	}

	bgFilter->SetImage(classifiedImage);
	bgFilter->Separate(0);
			
	PointSpreadFunction * bgPSF = new PointSpreadFunction();
	bgPSF->SetImage(bgFilter->GetOutput());
	bgPSF->SetKernelChoice(2);
	bgPSF->Update();

	bgImage = bgPSF->GetOutput();
	/***********************************************
	char debug[100] = "";
	strcpy(debug,pathname);
	strcat(debug,num);
	strcat(debug,"BG.nii");

	vtkKWImageIO * KWwriter = vtkKWImageIO::New();
	KWwriter->SetFileName(debug);
	KWwriter->SetImageToBeWritten(bgImage);
	try
	{
		KWwriter->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
	/***************************************************/
			
	whiteFilter->SetImage(classifiedImage); 
	whiteFilter->Separate(3);
			
	PointSpreadFunction * whitePSF = new PointSpreadFunction();
	whitePSF->SetImage(whiteFilter->GetOutput());
	whitePSF->SetKernelChoice(2);
	whitePSF->Update();
	
	whiteImage = whitePSF->GetOutput();
	/***********************************************
	vtkKWImageIO * KWwriter = vtkKWImageIO::New();
	KWwriter->SetFileName("E:\\Development\\output\\white.nii");
	KWwriter->SetImageToBeWritten(whiteImage);
	try
	{
		KWwriter->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
	/***************************************************/
	greyFilter->SetImage(classifiedImage); 
	greyFilter->Separate(2);

	PointSpreadFunction * greyPSF = new PointSpreadFunction();
	greyPSF->SetImage(greyFilter->GetOutput());
	greyPSF->SetKernelChoice(2);
	greyPSF->Update();
			
	greyImage = greyPSF->GetOutput();
	/***********************************************
		
	strcpy(debug,pathname);
	strcat(debug,num);
	strcat(debug,"grey.nii");

	KWwriter->SetFileName(debug);
	KWwriter->SetImageToBeWritten(greyImage);
	try
	{
		KWwriter->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
	/***************************************************/
		
	csfFilter->SetImage(classifiedImage); 
	csfFilter->Separate(1);
				
	PointSpreadFunction * csfPSF = new PointSpreadFunction();
	csfPSF->SetImage(csfFilter->GetOutput());
	csfPSF->SetKernelChoice(2);
	csfPSF->Update();

	csfImage = csfPSF->GetOutput();
	/***********************************************
			
	strcpy(debug,pathname);
	strcat(debug,num);
	strcat(debug,"csf.nii");

	KWwriter->SetFileName(debug);
	KWwriter->SetImageToBeWritten(csfImage);
	try
	{
		KWwriter->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
			
	/***********************************************/
	
	//csi->GetOutput();

	/***********************************************/
	GridCalculation *gridCalc = new GridCalculation();
	gridCalc->SetWhiteMap(whiteImage);
	gridCalc->SetGreyMap(greyImage);
	gridCalc->SetBGMap(bgImage);
	gridCalc->SetCSFMap(csfImage);
	gridCalc->SetGrid(csi->GetOutput());
	gridCalc->SetName("Tissue");
	gridCalc->ParameterCalculate();
	/************************************************/
			
	pVolume = gridCalc->GetOutput();
	
	return pVolume;
}
/**************************************************************************************************************************/
vtkKWImage * vtkKWMyWindow::TissueClassification( vtkKWImage * t1, vtkKWImage * t2, vtkKWImage * mask)
{

	vtkKWImage * kmeans = vtkKWImage::New();
	
	/***********************************************
	vtkKWImageIO * KWwriter2 = vtkKWImageIO::New();
	KWwriter2->SetFileName("E:\\Development\\output\\mask.nii");
	KWwriter2->SetImageToBeWritten(this->CurrentMask);
	try
	{
		KWwriter2->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
	/***********************************************/

	ImageType::Pointer itkT1 = ImageType::New();
	itkT1 = GetITK(t1);
	ImageType::Pointer itkT2 = ImageType::New();
	itkT2 = GetITK(t2);
	ImageType::Pointer itkmask = ImageType::New();
	itkmask = GetITK(mask);

	
	KMeansTissueClassifier * tissueClassifier = new KMeansTissueClassifier();
	tissueClassifier->SetImage( itkT1 );
	tissueClassifier->SetBrainMask( itkmask );
	tissueClassifier->Classify();

	kmeans->SetITKImageBase( tissueClassifier->GetOutput() );

	//this->KMeansImage->Print(debugStream);
	/***********************************************
	vtkKWImageIO * KMeanswriter = vtkKWImageIO::New();
	KMeanswriter->SetFileName("output\\kmeans.nii");
	KMeanswriter->SetImageToBeWritten(kmeans);
	try
	{
		KMeanswriter->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
	/***********************************************/
	
	vtkKWImage * sampleplug = vtkKWImage::New();
	
	sampleplug->SetITKImageBase( BRAINSRandomPlugsCSI( tissueClassifier->GetOutput() )); 

	vtkKWImage * bayesian = vtkKWImage::New();
	
	bayesian = BayesianClassifierBrainCSI(t1,t2,kmeans,mask, sampleplug);
	

	//AnatomicalImage image;
	//char name[100];  
	//strcpy(name, "Classified");
	//image.SetImage(this->ClassifiedImage);
	//image.SetDisplayName(name);
	//this->AnatomicalImages.push_back(image);

	//this->FileManager->AddNode("image_node",name, name);
	////this->FileManager->SetNodeImageToPredefinedIcon(display,vtkKWIcon::IconSilkEye);
	//this->FileManager->SetNodePadX(name,18);

	//vtkKWPushButton *visible_button = vtkKWPushButton::New();
	//visible_button->SetParent(this->FileManager);
	//visible_button->Create();
	//visible_button->SetBorderWidth(0);
	//visible_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
	//visible_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
	//visible_button->SetImageToPredefinedIcon( 20021);
	//char command[100];
	//strcpy(command, "ChangeImageVisibility ");
	//strcat(command, name);
	//visible_button->SetCommand( this, command);
	//this->FileManager->SetNodeWindow(name, visible_button);
	///**********************************************************************************/
	////ChangeImageVisibility(name);

	/***********************************************
	vtkKWImageIO * KWwriter = vtkKWImageIO::New();
	KWwriter->SetFileName("E:\\Development\\output\\TissueClassified.nii");
	KWwriter->SetImageToBeWritten(this->ClassifiedImage);
	try
	{
		KWwriter->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
	/***********************************************/

	//this->Viewer->SetImage( bayesian );
	//this->Viewer->DisplayImage();

	return bayesian;

	//debugStream <<"Time elapsed: "<<time/CLOCKS_PER_SEC << std::endl;
	//debugStream.close();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::Extract()
{
	
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\extract.txt");
	//




	ImageProcessing * extract = new ImageProcessing();
	
	extract->SetImage(this->CurrentImage);
	extract->SetGrid(this->Spectroscopy[0]->GetOutput());
	extract->SetGridSpacing(this->Spectroscopy[0]->GetSpacing());
	extract->SetGridDirCos(this->Spectroscopy[0]->GetDirCos());

	extract->SetGridFOV(this->Spectroscopy[0]->GetFOV() );

	extract->SetGridCenter(this->Spectroscopy[0]->GetGridCenter());
	
	//debugStream <<"*"<<endl;
	extract->ExtractGridVoxels();
	//debugStream <<"*"<<endl;

	this->CurrentImage = extract->GetOutput();
	this->ExtractImage = extract->GetOutput();
	
	//debugStream.close();

}
/**************************************************************************************************************************/
vtkKWImage * vtkKWMyWindow::Extract(vtkKWImage * image)
{
	
	//std::ofstream debugStream;
 //   debugStream.open("E:\\Development\\output\\extract.txt");
	
	ImageProcessing * extract = new ImageProcessing();
	
	extract->SetImage(image);
	extract->SetGrid(this->Spectroscopy[0]->GetOutput());
	extract->SetGridSpacing(this->Spectroscopy[0]->GetSpacing());
	extract->SetGridDirCos(this->Spectroscopy[0]->GetDirCos());
	extract->SetGridFOV(this->Spectroscopy[0]->GetFOV() );
	extract->SetGridCenter(this->Spectroscopy[0]->GetGridCenter());

	extract->ExtractGridVoxels();	
	
	return extract->GetOutput();
	//debugStream.close();

}
/**************************************************************************************************************************/
void vtkKWMyWindow::LoadLCModel()
{
	//std::ofstream debugStream;
	//debugStream.open("output\\loadLcmodel.txt");

	vtkKWApplication *app = this->GetApplication();

	if (!this->CurrentGrid)
	{
 		vtkKWMessageDialog *msg_dlg1 = vtkKWMessageDialog::New();
		msg_dlg1->SetApplication(app);
		msg_dlg1->SetStyleToCancel();
		msg_dlg1->Create();
		msg_dlg1->SetTitle("Oops!");
		msg_dlg1->SetText("You need to load a Spectroscopy File first");
		msg_dlg1->Invoke();
	}
	else
	{
		//Get file name from Dialog Box.  
		vtkKWFileBrowserDialog *dlg = vtkKWFileBrowserDialog::New();
		dlg->SetApplication(app);
		dlg->Create();
		dlg->SetFileTypes("{{All files} {.*}} {{Text Document} {.txt}} {{CSV} {.csv}}");
		dlg->RetrieveLastPathFromRegistry("LastPath");
		dlg->Invoke();
		char* fileName;

		if (dlg->GetStatus()==vtkKWDialog::StatusOK)
		{
			dlg->SaveLastPathToRegistry("LastPath");
			fileName = dlg->GetFileName();
			/**********************************************************/
			int * extent = this->CurrentGrid->GetExtent();
			int * size = new int[3];
			size[0] = extent[1]; size[1]=extent[3]; size[2] = extent[5];

			// Read in the RDA file and the information that we will need.
			LCModelReader *lcmodel = new LCModelReader();
			lcmodel->SetGridSize(size);
			lcmodel->Read(fileName);
			/**********************************************************/
			//Find out how many metabolite arrays there are.
			vtkSmartPointer<vtkStringArray> names = vtkSmartPointer<vtkStringArray>::New();
			names = lcmodel->GetMetaboliteNames();
			/********************************************************************/
			//Loop over all names
			int metabNum = names->GetNumberOfValues();
			//std::cout<<metabNum<<std::endl;
			for (int i = 0; i < metabNum; i++)
			{
				vtkSmartPointer<vtkDoubleArray>  metaboliteConc = vtkSmartPointer<vtkDoubleArray>::New();
				metaboliteConc = lcmodel->GetOutputArray( names->GetValue(i) );

				int size = metaboliteConc->GetNumberOfComponents();
				int tuples = metaboliteConc->GetNumberOfTuples();

				this->CurrentGrid->GetCellData()->AddArray(metaboliteConc);
			}

			/**********************************************************************************/
			// Create another menu button, this time with a label
			this->MetabMapChoice = vtkKWComboBox::New();
			/**********************************************************************************/
			this->MetabMapChoice->SetApplication(app);
			this->MetabMapChoice->SetParent(this->GetMainPanelFrame());
			this->MetabMapChoice->Create();
			this->MetabMapChoice->SetWidth(20);
			this->MetabMapChoice->ReadOnlyOn();
			this->MetabMapChoice->SetBalloonHelpString("Select the metabolite to display");
			for (int i = 0; i < names->GetSize(); i++)
			{
				this->MetabMapChoice->AddValue( names->GetValue(i) );
			}
			this->MetabMapChoice->SetValue("NAA");
			this->MetabMapChoice->SetCommand(this, "SetViewMetab" );
			app->Script( "pack %s -side top -anchor nw -expand n -padx 2 -pady 6",  this->MetabMapChoice->GetWidgetName());
			/**********************************************************************************/
			// Create a checkbutton
			this->ComponentChoice = vtkKWComboBox::New();
			this->ComponentChoice->SetParent(this->GetMainPanelFrame());
			this->ComponentChoice->Create();
			this->ComponentChoice->AddValue("Original");
			this->ComponentChoice->AddValue("CRLB");
			this->ComponentChoice->AddValue("Ratio");
			this->ComponentChoice->AddValue("Filtered");
			this->ComponentChoice->ReadOnlyOn();
			this->ComponentChoice->SetValue("Filtered");
			this->ComponentChoice->SetCommand(this, "SetComponentChoice");
			app->Script("pack %s -side top -anchor nw -expand n -padx 2 -pady 2", this->ComponentChoice->GetWidgetName());
			
			/**********************************************************************************/
			this->Viewer->SetMetabolite("NAA");
			this->Viewer->CalcCRLBRange();
			this->Viewer->CalcMetabRange();
			this->Viewer->DisplayMetabolites();
			/**********************************************************************************/			
			//Set Metabolite Range Widget
			this->MetabRange = vtkKWRange::New();
			this->MetabRange->SetParent(this->GetMainPanelFrame() );
			this->MetabRange->Create();
			this->MetabRange->SetLabelText("Range of Metab. Conc.");
			this->MetabRange->SetEntry1PositionToBottom();
			this->MetabRange->SetEntry2PositionToBottom();
			this->MetabRange->SetWholeRange(this->Viewer->GetMetabWholeRange());
			this->MetabRange->SetRange( this->Viewer->GetMetabRange() );
			this->MetabRange->SetEndCommand(this, "SetMetabViewRange");
			app->Script("pack %s -side top -anchor nw -expand n -padx 2 -pady 2", this->MetabRange->GetWidgetName());	
			/**********************************************************************************/
			//Set CRLB Range Widget
			this->CRLBRange = vtkKWRange::New();
			this->CRLBRange->SetParent(this->GetMainPanelFrame() );
			this->CRLBRange->Create();
			this->CRLBRange->SetLabelText("Range of CRLB");
			this->CRLBRange->SetEntry1PositionToBottom();
			this->CRLBRange->SetEntry2PositionToBottom();
			double * rangecrlb = this->Viewer->GetCRLBRange();
			this->CRLBRange->SetWholeRange(0,20);
			this->CRLBRange->SetRange(this->Viewer->GetCRLBRange());
			this->CRLBRange->SetEndCommand(this, "SetViewCRLBRange");
			app->Script("pack %s -side top -anchor nw -expand n -padx 2 -pady 2", this->CRLBRange->GetWidgetName());

			/**********************************************************
			vtkXMLStructuredGridWriter * writer = vtkXMLStructuredGridWriter::New();
			writer->SetInput(this->CurrentGrid);
			writer->SetFileName("E:\\Development\\output\\metab.vts");
			writer->Update();
			/**********************************************************/
		}
	}
	this->Viewer->RenderWidget->Render();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::CreateBrainMask()
{
	//// To Do:  Check to see if T1Image and T2Image exist.
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\BrainMask.txt");
	//clock_t time;
	//time = clock();

	//typedef float													FloatPixelType;
	
	//ImageType::Pointer itkT1Image = ImageType::New();
	//ImageType::Pointer itkT2Image = ImageType::New();
	//
	//ImageType::Pointer beforeImage = ImageType::New();
	//beforeImage = GetITK(this->T1Image);
	//
	//ImageType::SizeType		size;
	//size = beforeImage->GetLargestPossibleRegion().GetSize();
	////size[0] = 300;
	////size[1] = 300;
	////size[2] = 300;
	//
	//ImageType::SpacingType spacing;
	//spacing = beforeImage->GetSpacing();
	////spacing[0] = 2;
	////spacing[1] = 2;
	////spacing[2] = 2;

	////Set Transform	
	//typedef itk::AffineTransform<double,3>								AffineTransformType;
	//AffineTransformType::Pointer transform = AffineTransformType::New();
	//transform->SetMatrix(this->GridDirCos);
	// 
	//ImageProcessing * resampleT1Filter = new ImageProcessing();
	//resampleT1Filter->SetImage(this->T1Image);
	//resampleT1Filter->SetGridDirCos(this->GridDirCos);
	//resampleT1Filter->SetSize(size);
	//resampleT1Filter->SetSpacing(spacing);
	//resampleT1Filter->ResampleImage();

	//ImageProcessing * resampleT2Filter = new ImageProcessing();
	//resampleT2Filter->SetImage(this->T2Image);
	//resampleT2Filter->SetGridDirCos(this->GridDirCos);
	//resampleT2Filter->SetSize(size);
	//resampleT2Filter->SetSpacing(spacing);
	//resampleT2Filter->ResampleImage();

	//itkT1Image = GetITK( resampleT1Filter->GetOutput() );
	//itkT2Image = GetITK( resampleT2Filter->GetOutput() );

	//typedef itk::ImageFileWriter<ImageType>		WriterType;
	////WriterType::Pointer	 writer = WriterType::New();
	////writer->SetInput(itkT1Image);
	////writer->SetFileName("E:\\Development\\output\\itkT1Image.nii");
	////writer->Update();

	////vtkKWImageIO * KWwriter = vtkKWImageIO::New();
	////KWwriter->SetFileName("E:\\Development\\output\\T1ImageExtract.nii");
	////KWwriter->SetImageToBeWritten(this->T1Image);
	////try
	////{
	////	KWwriter->WriteImage();
	////}
	////catch( itk::ExceptionObject & excp )
	////{
	////	std::cerr << excp << std::endl;
	////}
	//
	//typedef itk::CastImageFilter< ImageType, FloatImageType > FilterType;
	//FilterType::Pointer floatFilter = FilterType::New();
	//floatFilter->SetInput( itkT1Image );
	//floatFilter->Update();

	//FloatImageType::Pointer T1float = FloatImageType::New();
	//T1float = floatFilter->GetOutput();
	//
	//FilterType::Pointer floatFilter2 = FilterType::New();
	//floatFilter2->SetInput( itkT2Image );
	//floatFilter2->Update();

	//FloatImageType::Pointer T2float = FloatImageType::New();
	//T2float = floatFilter2->GetOutput();

	//T1float->Print(debugStream);
	//T2float->Print(debugStream);

	//ImageType::Pointer mushImage = ImageType::New();
	//mushImage =  BRAINSMushPrimary( T1float, T2float );

	//mushImage->Print(debugStream);

	//mushImage->SetDirection( beforeImage->GetDirection() );
	//mushImage->SetOrigin( beforeImage->GetOrigin() );

	//mushImage->Print(debugStream);

	//WriterType::Pointer	 writer3 = WriterType::New();
	//writer3->SetInput(mushImage);
	//writer3->SetFileName("E:\\Development\\output\\mushImage.nii");
	//writer3->Update();

	//this->CurrentMask->SetITKImageBase( mushImage );
	//
	//time = clock() - time;
	//debugStream <<"Time elapsed: "<<time/CLOCKS_PER_SEC << std::endl;
	//debugStream.close();
}
/**************************************************************************************************************************/
vtkKWImage *  vtkKWMyWindow::CreateBrainMask(vtkKWImage * image1, vtkKWImage * image2)
{
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\BrainMask.txt");
	//clock_t time;
	//time = clock();

	ImageType::Pointer beforeImage = ImageType::New();
	ImageType::Pointer itkT1Image = ImageType::New();
	ImageType::Pointer itkT2Image = ImageType::New();	

	/*****************************************************************************************
	ImageType::SizeType		size;
	size[0] = 150;
	size[1] = 150;
	size[2] = 150;

	ImageType::SpacingType spacing;
	spacing[0] = 2;
	spacing[1] = 2;
	spacing[2] = 2;
	
	ImageType::DirectionType direction;
	direction.SetIdentity();

	ImageType::PointType origin;
	origin[0] = -150;
	origin[1] = -150;
	origin[2] = -150;

	
	/*****************************************************************************************/
	//Get the size and spacing of images beforehand
	beforeImage = GetITK(image1);
	
	ImageType::SizeType		size;
	size = beforeImage->GetLargestPossibleRegion().GetSize();

	ImageType::SpacingType spacing;
	spacing = beforeImage->GetSpacing();
	
	ImageType::DirectionType direction;
	direction = beforeImage->GetDirection();
	
	ImageType::PointType origin;
	origin = beforeImage->GetOrigin();
	
	/*****************************************************************************************
	//Resample both images into the same size and spacing and direction

	
	ImageProcessing * resampleT1Filter = new ImageProcessing;
	resampleT1Filter->SetImage( GetITK(image1) );
	//resampleT1Filter->SetGridDirCos(this->GridDirCos);
	resampleT1Filter->SetSize(size);
	resampleT1Filter->SetSpacing(spacing);
	//resampleT1Filter->SetDirection(direction);
	//resampleT1Filter->SetOrigin(origin);
	resampleT1Filter->ResampleImage();

	ImageProcessing * resampleT2Filter = new ImageProcessing;
	resampleT2Filter->SetImage( GetITK(image2) );
	//resampleT2Filter->SetGridDirCos(this->GridDirCos);
	resampleT2Filter->SetSize(size);
	resampleT2Filter->SetSpacing(spacing);
	//resampleT2Filter->SetOutputDirection(direction);
	//resampleT2Filter->SetOutputOrigin(origin);
	resampleT2Filter->ResampleImage();

	vtkKWImage * temp1 = vtkKWImage::New();
	vtkKWImage * temp2 = vtkKWImage::New();

//	temp1 = resampleT1Filter->GetOutput();
//	temp2 = resampleT2Filter->GetOutput();
	/*****************************************************************************************/
	itkT1Image = GetITK(image1); //temp1); resampleT1Filter->GetOutput());
	itkT2Image = GetITK(image2); //temp2); resampleT2Filter->GetOutput());
	//debugStream<<"T1 Image Resampled"<<std::endl;
	//itkT1Image->Print(debugStream);
	//debugStream<<"T2 Image Resampled"<<std::endl;
	//itkT2Image->Print(debugStream);

	/***************************************************************************************

	typedef itk::ImageFileWriter<ImageType>		WriterType;
	WriterType::Pointer	 writer = WriterType::New();
	writer->SetInput(itkT1Image);
	writer->SetFileName("E:\\Development\\output\\itkT1Image.nii");
	writer->Update();

	WriterType::Pointer	 writer2 = WriterType::New();
	writer2->SetInput(itkT2Image);
	writer2->SetFileName("E:\\Development\\output\\itkT2Image.nii");
	writer2->Update();

	/***************************************************************************************/
	//Recast images into Float Images
	typedef float													FloatPixelType;
	typedef itk::Image< FloatPixelType, 3 >							FloatImageType;

	typedef itk::CastImageFilter< ImageType, FloatImageType > FilterType;
	
	FilterType::Pointer floatFilter = FilterType::New();
	floatFilter->SetInput( itkT1Image );
	floatFilter->Update();

	FloatImageType::Pointer T1float = FloatImageType::New();
	T1float = floatFilter->GetOutput();
	
	FilterType::Pointer floatFilter2 = FilterType::New();
	floatFilter2->SetInput( itkT2Image );
	floatFilter2->Update();

	FloatImageType::Pointer T2float = FloatImageType::New();
	T2float = floatFilter2->GetOutput();

	/***************************************************************************************/
	//Send images to BrainsMush
	ImageType::Pointer mushImage = ImageType::New();
	mushImage =  BRAINSMushPrimary( T1float, T2float );

	/***************************************************************************************
	WriterType::Pointer	 writer3 = WriterType::New();
	writer3->SetInput(mushImage);
	writer3->SetFileName("E:\\Development\\output\\mushImage.nii");
	writer3->Update();
	/***************************************************************************************
	//Resample with identity filter with GridCosines as output
	typedef itk::ResampleImageFilter<ImageType, ImageType>							ResampleFilterType;	

	AffineTransformType::Pointer transform = AffineTransformType::New();
	transform->SetIdentity();

	ResampleFilterType::Pointer resample = ResampleFilterType::New();
	resample->SetTransform(transform ); 
	resample->SetOutputSpacing(spacing); //mushImage->GetSpacing());
	resample->SetSize(size); //mushImage->GetLargestPossibleRegion().GetSize() );
	resample->SetOutputDirection(direction);// mushImage->GetDirection()); //this->Spectroscopy[0]->GetDirCos());
	resample->SetOutputOrigin(origin); //itkT1Image->GetOrigin() );
	resample->SetInput(mushImage);
	resample->Update();

	/***************************************************************************************/
	//Output Brain Mask 
	
	vtkKWImage * output = vtkKWImage::New();
	output->SetITKImageBase(mushImage);  //resample->GetOutput() );
		
	//time = clock() - time;
	//debugStream <<"Mush Image Time elapsed: "<< time/CLOCKS_PER_SEC << std::endl;

	return output;
	//debugStream.close();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::CalculateTest()
{
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\calculateTest.txt");
	/*****************************************************************************/
	//Load Files and Separate label images
	this->ClassifiedImage = LoadFile(this->testDir, "kwclassified.nii");
	LoadRDA("E:\\Development\\braincsi\\Testing\\CSI-WS.rda");

	/*****************************************************************************
	ImageProcessing * getCSF = new ImageProcessing();
	getCSF->SetImage( this->ClassifiedImage );
	getCSF->Separate(1);
	this->CSFImage = getCSF->GetOutput();
	getCSF->WriteImage();

	ImageProcessing * getWhite = new ImageProcessing();
	getWhite->SetImage( this->ClassifiedImage );
	getWhite->Separate(2);
	this->WhiteImage = getWhite->GetOutput();

	ImageProcessing * getGrey = new ImageProcessing();
	getGrey->SetImage( this->ClassifiedImage );
	getGrey->Separate(3);
	this->GreyImage = getGrey->GetOutput();

	ImageProcessing * getBG = new ImageProcessing();
	getBG->SetImage( this->ClassifiedImage );
	getBG->Separate(0);
	this->BGImage = getBG->GetOutput();
	/*****************************************************************************
	//Convolve with Grid Point Spread Function
	PointSpreadFunction * convolveCSF = new PointSpreadFunction();
	convolveCSF->SetImage( getCSF->GetOutput() );
	//convolveCSF->SetGrid(this->CurrentGrid);
	convolveCSF->SetKernelChoice(1);
	convolveCSF->Update();
	this->CSFImage= convolveCSF->GetOutput();
		
	PointSpreadFunction * convolveGrey = new PointSpreadFunction();
	convolveGrey->SetImage( getGrey->GetOutput() );
	//convolveGrey->SetGrid( this->CurrentGrid );
	convolveGrey->SetKernelChoice(1);
	convolveGrey->Update();
	this->GreyImage = convolveGrey->GetOutput();

	PointSpreadFunction * convolveWhite = new PointSpreadFunction();
	convolveWhite->SetImage( getWhite->GetOutput() );
	//convolveWhite->SetGrid( this->CurrentGrid );
	convolveWhite->SetKernelChoice(1);
	convolveWhite->Update();
	this->WhiteImage = convolveWhite->GetOutput();
	
	PointSpreadFunction * convolveBG = new PointSpreadFunction();
	convolveBG->SetImage( getBG->GetOutput() );
	//convolveBG->SetGrid( this->CurrentGrid );
	convolveBG->SetKernelChoice(1);
	convolveBG->Update();
	this->BGImage = convolveBG->GetOutput();
	/*****************************************************************************/
	//Calculate Partial Volumes
	GridCalculation *calc = new GridCalculation();
	calc->SetImage( this->ClassifiedImage );
	calc->SetGrid(this->SGrid);
	calc->Calculate();
	this->PVGrid = calc->GetOutputGrid();

	/*****************************************************************************/
	vtkXMLStructuredGridWriter * vtkWriter = vtkXMLStructuredGridWriter::New();
	vtkWriter->SetInput(this->PVGrid);
	vtkWriter->SetFileName("output\\PVGrid.vts");
	vtkWriter->Update(); 
	/*****************************************************************************
	//Calculate Partial Volumes
	GridCalculation *greyCalc = new GridCalculation();
	greyCalc->SetImage( this->GreyImage );
	greyCalc->SetGrid(this->SGrid);
	greyCalc->SetName("Grey");
	greyCalc->Calculate();

	GridCalculation *whiteCalc = new GridCalculation();
	whiteCalc->SetImage( this->WhiteImage);
	whiteCalc->SetGrid(this->SGrid);
	whiteCalc->SetName("White");
	whiteCalc->Calculate();

	GridCalculation *csfCalc = new GridCalculation();
	csfCalc->SetImage( this->CSFImage);
	csfCalc->SetGrid(this->SGrid);
	csfCalc->SetName("CSF");
	csfCalc->Calculate();

	GridCalculation *BGCalc = new GridCalculation();
	BGCalc->SetImage( this->BGImage);
	BGCalc->SetGrid(this->SGrid);
	BGCalc->SetName("BG");
	BGCalc->Calculate();
	/*****************************************************************************/

	//this->PVGrid = this->SGrid;
	//Put partial volumes into new grid 
	//this->PVGrid->GetCellData()->AddArray( greyCalc->GetOutput() );
	//this->PVGrid->GetCellData()->AddArray( whiteCalc->GetOutput() );
	//this->PVGrid->GetCellData()->AddArray( csfCalc->GetOutput() );
	//this->PVGrid->GetCellData()->AddArray( BGCalc->GetOutput() );
	/**************************************************************************
	vtkDataArray *greyVolume	= vtkDoubleArray::New(); 
	vtkDataArray *whiteVolume	= vtkDoubleArray::New(); 
	vtkDataArray *csfVolume		= vtkDoubleArray::New(); 
	vtkDataArray *bgVolume		= vtkDoubleArray::New();
	//vtkDataArray *metabolite	= vtkDoubleArray::New(); 

	greyVolume	= this->PVGrid->GetCellData()->GetArray("Grey");
	whiteVolume	= this->PVGrid->GetCellData()->GetArray("White");
	csfVolume	= this->PVGrid->GetCellData()->GetArray("CSF");
	bgVolume	= this->PVGrid->GetCellData()->GetArray("BG");
	
	//Add in metabolite information
	//metabolite  = this->SGrid->GetCellData()->GetArray( this->Names->GetValue(29) );  //GetMetabolite() );

	int * extent = this->SGrid->GetWholeExtent();
	
	debugStream << "Row,Column,Grey Matter,White Matter,CSF,Background,Total"<<endl;

	for (int col = 0; col < extent[1] ; col++)
	{
		for (int row = 0; row < extent[3]; row++)
		{
			vtkIdType cell = row*extent[3] + col;
            
			debugStream << row << "," <<col<< "," << greyVolume->GetComponent(cell, 0) << ","
				<< whiteVolume->GetComponent(cell, 0) << "," << csfVolume->GetComponent(cell, 0) << ","
				<< bgVolume->GetComponent(cell, 0) << std::endl;
			
			//<< bgVolume->GetComponent(cell, 0)<<","
			//debugStream << metabolite->GetComponent(cell, 0)<<",";
			//debugStream<< metabolite->GetComponent(cell, 0) /  greyVolume->GetComponent(cell, 0) <<endl;
		}
	}
	/*****************************************************************************

	vtkGeometryFilter * geometry = vtkGeometryFilter::New();
	geometry->SetInput(this->PVGrid);
	geometry->Update();

	vtkPolyDataWriter * vtkpolyWriter = vtkPolyDataWriter::New();
	vtkpolyWriter->SetInput(geometry->GetOutput());
	vtkpolyWriter->SetFileName("E:\\Development\\output\\polydatagrid.vtk");
	vtkpolyWriter->Update();
	/********************************************************************
	vtkStructuredGridWriter * vtkWriter = vtkStructuredGridWriter::New();
	vtkWriter->SetInput(this->PVGrid);
	vtkWriter->SetFileName("E:\\Development\\output\\structuredgrid.vtk");
	vtkWriter->Write();
	vtkWriter->Update(); 
	/********************************************************************/
	this->Viewer->SetGrid(this->PVGrid);
	this->Viewer->DisplayGrids();

	//debugStream.close();
}
/**************************************************************************************************************************/
const char * vtkKWMyWindow::GetMetabolite()
{
	//return this->MetaboliteList->GetWidget()->GetValue();
	return this->MetaboliteList->GetValue();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::DoNothing()
{
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\DoNothing.txt");
	//debugStream.close();

}
/**************************************************************************************************************************/
void vtkKWMyWindow::Test()
{
	std::ofstream debugStream;
    debugStream.open("output\\test.txt");

	char pname[100] = "E:/Research/HumanStudies/Reliability/Results/"; 
	char pathname[100] = ""; 
	char rdaname[100] = ""; 
	char PVname[100] = "";
	char classifiedname[100] = ""; 
	char t1name[100] = "";
	char t2name[100] = "";
	char outt1name[100] = "";
	char outt2name[100] = "";
	char outmaskname[100] = "";
	char num[100] = "";
	char spec[100] = "";
	char orient[100] = "";

	//Iterate through subjects
	for (int i = 301; i<=303; i++)
	{
		itoa(i,num,10);
		strcpy(pathname,pname);
		strcat(pathname,num);
		strcat(pathname,"/");
		
		//Iterate through orientations
		//for (int o = 0; o <=3; o++)
		//{ 
		int o=1;
		itoa(o,orient,10);
		//Iterate through acquisitions
		//for (int s = 0; s <=3; s++)
		int s=0;
		itoa(s,spec,10);

		strcpy(rdaname,pathname);
		strcat(rdaname,num);
		strcat(rdaname,"-");
		strcat(rdaname,spec);
		strcat(rdaname,".rda");

		strcpy(PVname,pathname);
		strcat(PVname,num);
		strcat(PVname,"-");
		strcat(PVname,orient);
		strcat(PVname,"-");
		strcat(PVname,spec);
		strcat(PVname,"-PV.txt");

		strcpy(classifiedname,pathname);
		strcat(classifiedname,num);
		strcat(classifiedname,"-");
		strcat(classifiedname,orient);
		strcat(classifiedname,"-bayes.nii");

		strcpy(t1name,pathname);
		strcat(t1name,num);
		strcat(t1name,"-t1.nii");
		//strcat(t1name,spec);
		//strcat(t1name,".nii");

		strcpy(t2name,pathname);
		strcat(t2name,num);
		strcat(t2name,"-t2-");
		strcat(t2name,orient);
		strcat(t2name,".nii");
			
		//Load T1
		vtkKWImage * t1 = vtkKWImage::New();
		t1=ITKLoadFile( t1name);
		t1->Print(debugStream);
		//Load T2
		vtkKWImage * t2 = vtkKWImage::New();
		t2=ITKLoadFile(t2name);
		t2->Print(debugStream);
		//Load RDA
		CSIgrid * csi = new CSIgrid;
		csi = LoadRDA(rdaname);

		//Register T1 and T2
		vtkKWImage * fixed = vtkKWImage::New();
		vtkKWImage * moving = vtkKWImage::New();

		fixed = t1;
		moving = t2;

		TransformType::Pointer transform = TransformType::New();
		transform = Register(fixed,moving);
		transform->Print(debugStream);	

		//Transform moving image to fixed frame
		vtkKWImage * reg = vtkKWImage::New();
		reg = Rotate(fixed, moving,transform);
		reg->Print(debugStream);
		//Create Mask
		vtkKWImage * mask = vtkKWImage::New();
		mask = CreateBrainMask(fixed,reg);
		mask->Print(debugStream);
		//Extract smaller image
		vtkKWImage * t1e = vtkKWImage::New();
		vtkKWImage * t2e = vtkKWImage::New();
		vtkKWImage * maske = vtkKWImage::New();

		t1e = Extract(t1);//need to send csi to extract function
		t2e = Extract(t2);
		maske = Extract(mask);

		//Classify
		vtkKWImage * classifiedImage = vtkKWImage::New();
		classifiedImage = TissueClassification(t1e,t2e,maske);
		debugStream <<"Classified Image"<<std::endl;
		classifiedImage->Print(debugStream);

		//Calculate Partial Volume
		vtkDataArray * pv = vtkDoubleArray::New();
		pv = Calculate(classifiedImage,csi);
		
		//Write out PV.txt file
		std::ofstream percentStream;
		percentStream.open(PVname);

		percentStream <<"CellID, BG, CSF, Grey, White, Volume"<<endl;
		
		double * tupleOUT = NULL;
		
		for ( int cellId = 0; cellId < 32*32; cellId++ )
		{
 			tupleOUT = pv->GetTuple(cellId);
			percentStream <<cellId <<","<<tupleOUT[0]<<","<<tupleOUT[1]<<","<<tupleOUT[2]<<","<<tupleOUT[3]<<","<<tupleOUT[4]<<endl;
		}

		percentStream.close();
		//Write out Classified Imag
		vtkKWImageIO * KWwriter = vtkKWImageIO::New();
		KWwriter->SetFileName( classifiedname);
		KWwriter->SetImageToBeWritten(classifiedImage);
		try
		{
			KWwriter->WriteImage();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}

		//Write out extracted images
		
	}
	debugStream.close();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::TestFFT()
{
	//std::ofstream debugStream;
	//debugStream.open("E:\\Development\\output\\TestFFT.txt");
	/******************************************************************************************/

	this->ClassifiedImage = LoadFile(this->testDir, "tissuelabel.nii");
	DoubleImageType::Pointer tissueImage = DoubleImageType::New();
	const DoubleImageType * testImage = static_cast< const DoubleImageType * >(this->ClassifiedImage->GetITKImageBase() );
	tissueImage = const_cast<DoubleImageType *>(testImage);

	/******************************************************************************************/

	vtkKWImage * kernel = vtkKWImage::New();
	kernel = LoadFile(this->testDir, "kernel.nii");

	/******************************************************************************************
	//AutoLoad data
	char fnameT1[100] = ""; 
	char dnameT1[100] = ""; 
	strcpy(dnameT1,this->testDir,100);
	strcat(dnameT1,this->T1folder,100);
	//strcpy(dnameT1,fnameT1,100);
	//strcat(fnameT1,this->T1file,100);
	kernel = LoadSeriesFile(dnameT1, this->T1file);
	/******************************************************************************************/
	DoubleImageType::Pointer kernelImage = DoubleImageType::New();
	const DoubleImageType * tempImage = static_cast< const DoubleImageType * >(kernel->GetITKImageBase() );
	kernelImage = const_cast<DoubleImageType *>(tempImage);
	/******************************************************************************************
	//Normalize Kernel
	typedef itk::NormalizeToConstantImageFilter<DoubleImageType,DoubleImageType> NormalizeFilterType;
	NormalizeFilterType::Pointer normalize = NormalizeFilterType::New();
	normalize->SetInput(kernelImage);
	normalize->Update();

	//Pad both Kernel and Image to same size.
	typedef itk::FFTPadImageFilter< DoubleImageType, DoubleImageType, DoubleImageType, DoubleImageType > PadType;
	PadType::Pointer pad = PadType::New();
	pad->SetInput( tissueImage );
	pad->SetInputKernel( normalize->GetOutput() );
	pad->SetPadMethod( 1 );
	pad->SetPadToPowerOfTwo(true);
	pad->Update();
	
	/******************************************************************************************
	//FFT Real to ComplexConjugate for Image
	typedef itk::FFTRealToComplexConjugateImageFilter< double, 3> FFTType;
	FFTType::Pointer fft = FFTType::New();
	fft->SetInput( tissueImage );
	try
	{
		fft->Update();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
	/******************************************************************************************
	typedef itk::ComplexToRealImageFilter<FFTType::OutputImageType,DoubleImageType>  ComplexCastFilterType;
	ComplexCastFilterType::Pointer filter = ComplexCastFilterType::New();
	filter->SetInput(fft->GetOutput());
	filter->Update();

	DoubleImageType::Pointer fftImage = DoubleImageType::New();
	fftImage = filter->GetOutput();
	/******************************************************************************************/
	
	//Mulitiply Kernel and Image
	/*typedef itk::MultiplyImageFilter< FFTType::OutputImageType,ComplexImageType,FFTType::OutputImageType > MultType;
	MultType::Pointer mult = MultType::New();
	mult->SetInput( 0, fft->GetOutput() );
	mult->SetInput( 1, pad->GetOutputKernel() );*/


	/******************************************************************************************
	typedef itk::ImageFileWriter<DoubleImageType> DoubleImageWriterType;
	DoubleImageWriterType::Pointer writer = DoubleImageWriterType::New();
	writer->SetInput(fftImage);
	writer->SetFileName("E:\\Development\\output\\Test.nii");
	writer->Update();

	/******************************************************************************************
	typedef itk::CastImageFilter<DoubleImageType, ImageType> CastFilterType;
	CastFilterType::Pointer castFilter = CastFilterType::New();
	castFilter->SetInput(fftImage);
	castFilter->Update();
	/******************************************************************************************
	vtkKWImage * display = vtkKWImage::New();
	display->SetITKImageBase( castFilter->GetOutput() );
	/*****************************************************************************************/

	this->Viewer->SetImage(this->ClassifiedImage);
	this->Viewer->DisplayImage();

	//debugStream.close();
}
/**************************************************************************************************************************/
ImageType::Pointer vtkKWMyWindow::GetITK(vtkKWImage * image)
{	
	ImageType::Pointer output = ImageType::New();
	const ImageType * testImage = static_cast< const ImageType * >(image->GetITKImageBase() );
	output = const_cast<ImageType *>(testImage);

	//typedef itk::CastImageFilter<vtkKWImage::ImageBaseType,ImageType> CastImageFilterType;
	//CastImageFilterType::Pointer castFilter = CastImageFilterType::New();
	//castFilter->SetInput(output);
	//castFilter->Update();
	
	return output;//castFilter->GetOutput(); 
}
/**************************************************************************************************************************/
void vtkKWMyWindow::SetChemicalShift(const char* metabName)
{
	//std::ofstream debugStream;
	//debugStream.open("output\\SetChemicalShift.txt");
	

	//Need to get this info from RDA FILE!!!
	this->B0Field = 3.0;
	this->ScannerFreq = 123.25;
	this->Bandwidth = 1600;
	this->DwellTime = 625;
	this->GridThickness = 15;
	char name[20] = "";
	//metabName = GetMetabolite();
	strcpy( name,metabName);

	vtkStringArray *metabNames = vtkStringArray::New();
	metabNames->SetName("MetaboliteNames");
	metabNames->InsertNextValue("NAA");
	metabNames->InsertNextValue("GPC+PCh");
	metabNames->InsertNextValue("Cre");

	int choice = 0;
	choice = metabNames->LookupValue(metabName);

    switch (choice)
    {
		case 0://NAA
			this->MetaboliteChemShift = 2.01; 
			break;
		case 1: //Cho
			this->MetaboliteChemShift = 3.21;
			break;
		case 2://Cre
			this->MetaboliteChemShift = 3.03;
			break;
		default:
			this->MetaboliteChemShift = 2.01; //Assume Center Frequency is at NAA peak.
    }

	this->deltaR = this->DwellTime * this->ScannerFreq * this->GridThickness * (this->MetaboliteChemShift - this->CurrentMetabolite)/1000000;
		
	this->CurrentMetabolite = this->MetaboliteChemShift;

	if (this->Spectroscopy[0]->GetOutput())
	{
		TranslateGrid(); 
		this->Viewer->SetMetabolite( name);
		this->Viewer->DisplayGrids();
		this->Viewer->RenderWidget->Render();
	}

	//debugStream.close();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::SetMetabMapChoice(const char* metabName)
{
	char name[20] = "";
	strcpy( name,metabName);
	if (this->CurrentGrid)
	{
		this->Viewer->SetMetabolite( name);
		this->Viewer->DisplayGrids();
		this->Viewer->RenderWidget->Render();
	}
}
/**************************************************************************************************************************/
void vtkKWMyWindow::SetComponentChoice(const char* compName)
{
	char name[20] = "";
	strcpy( name, compName);
	int comp;

	if ( strcmp(name,"Original") == 0)
	{
		comp = 0;
	}
	else if ( strcmp(name, "CRLB") == 0)
	{
		comp = 1;
	}
	else if ( strcmp(name, "Ratio") == 0)
	{
		comp = 2;
	}
	else if ( strcmp(name, "Filtered") )
	{
		comp = 3;
	}

	this->Viewer->SetComponent(comp);
	this->Viewer->CalcCRLBRange();
	this->Viewer->CalcMetabRange();
	this->MetabRange->SetRange(this->Viewer->GetMetabRange());
	this->MetabRange->SetWholeRange(this->Viewer->GetMetabWholeRange());
	this->Viewer->DisplayMetabolites();
	this->Viewer->RenderWidget->Render();

}
/**************************************************************************************************************************
void vtkKWMyWindow::SetRatioState()
{
	this->Viewer->SetRatioState(this->RatioButton->GetSelectedState());
	this->Viewer->DisplayGrids();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::SetPicking(int state)
{
	vtkKWApplication *app = this->GetApplication();

	std::vector<int> cells;
	std::vector<int>::iterator iter;
	
	if (!this->PickListBox)
	{
		this->PickListBox = vtkKWListBoxWithScrollbars::New();
		this->PickListBox->SetParent(this->GetMainPanelFrame());
		this->PickListBox->Create();
		this->PickListBox->SetBorderWidth(2);
		this->PickListBox->SetReliefToGroove();
		this->PickListBox->SetPadX(2);
		this->PickListBox->SetPadY(2);
		this->PickListBox->GetWidget()->SetSelectionModeToSingle();
		this->Pickcallback->SetWidget( this->PickListBox );
		this->Viewer->SetCellPickerCallback(this->Pickcallback);	
	
	}

	if (state)
	{
		this->Pickcallback->SetCSI(this->CurrentCSI);
		this->Viewer->PickingOn();
		app->Script( "pack %s -side top -anchor nw -expand n -padx 2 -pady 6", 
				this->PickListBox->GetWidgetName());
	}	
	else
	{
		this->Viewer->PickingOff();
		this->PickListBox->Unpack();
	}

}
/**************************************************************************************************************************/
void vtkKWMyWindow::SetViewMetab(const char* metab)
{
	this->Viewer->SetMetabolite(metab);
	this->Viewer->CalcCRLBRange();	
	this->Viewer->CalcMetabRange();
	this->MetabRange->SetWholeRange(this->Viewer->GetMetabWholeRange() );
	this->MetabRange->SetRange(this->Viewer->GetMetabRange() );
	this->CRLBRange->SetRange(this->Viewer->GetCRLBRange());
	this->Viewer->DisplayMetabolites();
	this->Viewer->RenderWidget->Render();
	
	//this->Viewer->Update();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::SetMetabViewRange(double range1, double range2)
{
	this->Viewer->GridActor->GetMapper()->SetScalarRange(range1,range2);	
	this->MetabRange->SetRange(range1,range2);
	this->Viewer->RenderWidget->Render();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::SetViewCRLBRange(double range1, double range2)
{
	this->Viewer->SetCRLBRange(range1,range2);
	this->Viewer->CalcMetabRange();
	this->MetabRange->SetWholeRange(this->Viewer->GetMetabWholeRange() );
	this->MetabRange->SetRange(this->Viewer->GetMetabRange() );
	this->Viewer->DisplayMetabolites();
	this->Viewer->RenderWidget->Render();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::SetMetabViewWholeRange(double range1, double range2)
{
	double * temp = new double[2];
	temp[0] = range1; temp[1]= range2;
	this->Viewer->SetMetabWholeRange(temp);
	this->MetabRange->SetWholeRange(range1,range2);
	this->Viewer->RenderWidget->Render();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::ReadStructuredGrid()
{
	vtkXMLStructuredGridReader * reader = vtkXMLStructuredGridReader::New();
	reader->SetFileName("output\\sgrid.vts");
	reader->Update();
	this->CurrentGrid = reader->GetOutput();

	this->Viewer->SetGrid(this->CurrentGrid );
	this->Viewer->DisplayGrids();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::DisplayPickedCells()
{
	this->Viewer->GetPickedCells();
	vtkKWListBoxWithScrollbars *listbox = vtkKWListBoxWithScrollbars::New();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::FileSelectionChangedCallback()
{
	if (this->FileManager->HasSelection())
    {
		DoubleClickFileCallback();
    }
}
/**************************************************************************************************************************/
void vtkKWMyWindow::RedrawGrids(int state)
{
	this->Viewer->DisplayPickedCells(state);
	//this->Viewer->GridActor->SetVisibility( !(static_cast<bool>(state) ) );
	this->Viewer->RenderWidget->Render();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::ChangeImageVisibility( const char * node)
{

	vtksys_stl::string parentName(this->FileManager->GetNodeParent(node) );
	vtksys_stl::string childrenNames(this->FileManager->GetNodeChildren(parentName.c_str()));
	
	vtksys_stl::string buf; // Have a buffer string
	vtksys_stl::stringstream ss(childrenNames); // Insert the string into a stream

	std::vector<vtksys_stl::string> tokens; // Create vector to hold our words
	while (ss >> buf)  tokens.push_back(buf);

	int numNodes = tokens.size();

	for (int i = 0; i < numNodes; i++)
	{
		if (strcmp( node, tokens[i].c_str() ) != 0)
		{
			vtkKWPushButton *visible_button = vtkKWPushButton::New();
			visible_button->SetParent(this->FileManager);
			visible_button->Create();
			visible_button->SetBorderWidth(0);
			visible_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
			visible_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
			visible_button->SetImageToPredefinedIcon( 17 ); //grey eye
			char command[100];
			strcpy(command, "ChangeImageVisibility ");
			strcat(command, tokens[i].c_str());
			visible_button->SetCommand( this, command);
			this->FileManager->SetNodeWindow(tokens[i].c_str(), visible_button);
		}
		else 
		{
			vtkKWPushButton *visible_button = vtkKWPushButton::New();
			visible_button->SetParent(this->FileManager);
			visible_button->Create();
			visible_button->SetBorderWidth(0);
			visible_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
			visible_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
			visible_button->SetImageToPredefinedIcon( 20021 ); //silk eye
			char command[100];
			strcpy(command, "ChangeImageVisibility ");
			strcat(command, tokens[i].c_str());
			visible_button->SetCommand( this, command);
			this->FileManager->SetNodeWindow(tokens[i].c_str(), visible_button);

			for ( int j = 0; j < this->AnatomicalImages.size(); j++)
			{
				if (strcmp( node, this->AnatomicalImages[j].GetName() ) == 0)
				{
					this->CurrentImage = this->AnatomicalImages[j].GetImage();
					this->Viewer->SetImage(this->CurrentImage);
					this->Viewer->Update();
				}
			}

		}

	}

}
/**************************************************************************************************************************/
void vtkKWMyWindow::ChangeGridVisibility( char * node, bool state)
{

	vtksys_stl::string parentName(this->FileManager->GetNodeParent(node) );
	vtksys_stl::string childrenNames(this->FileManager->GetNodeChildren(parentName.c_str()));
	
	vtksys_stl::string buf; // Have a buffer string
	vtksys_stl::stringstream ss(childrenNames); // Insert the string into a stream

	std::vector<vtksys_stl::string> tokens; // Create vector to hold our words
	while (ss >> buf)  tokens.push_back(buf);

	int numNodes = tokens.size();

	//vtkKWCheckButton *check_button = vtkKWCheckButton::New();
	//check_button->SetParent(this->FileManager);
	//check_button->Create();
	//check_button->SetBorderWidth(0);
	//check_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
	//check_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
	//check_button->SetImageToPredefinedIcon(20021);
	//check_button->SetSelectedState(state);

	//char command[100];
	//strcpy(command, "ChangeGridVisibility ");
	//strcat(command, node);
	//check_button->SetCommand( this, command);
	//this->FileManager->SetNodeWindow(node, check_button);


}
/**************************************************************************************************************************/
void vtkKWMyWindow::DoubleClickFileCallback()
{
	//std::ofstream debugStream;
	//debugStream.open("output\\callback.txt");

	vtksys_stl::string node( this->FileManager->GetSelection() );
	vtksys_stl::string parent( this->FileManager->GetNodeParent( node.c_str() ) );	

	if ( strcmp(parent.c_str(),"image_node") == 0 )
	{
		//debugStream << "Parent Node was Images" <<std::endl;
		for (int i = 0; i < this->AnatomicalImages.size(); i++)
		{
			//debugStream << "Image " <<i<<std::endl;
			if ( strcmp(node.c_str(), this->AnatomicalImages[i].GetName()) == 0)
			{
				this->CurrentImage = this->AnatomicalImages[i].GetImage();
				this->Viewer->SetImage(this->CurrentImage);
				this->Viewer->DisplayImage();
				//debugStream << "Set to Current " <<i<<std::endl;
			}
		}
		
	}
	else if ( strcmp( parent.c_str(),"grid_node") == 0 )
	{
		//debugStream << "Parent Node was Grid" <<std::endl;
		for (int i = 0; i < this->Spectroscopy.size(); i++)
		{
			//debugStream << "Grid " <<i<<std::endl;
			if ( strcmp(node.c_str(), this->Spectroscopy[i]->GetName()) == 0 )
			{
				this->CurrentGrid = this->Spectroscopy[i]->GetOutput();
				this->Viewer->SetGrid(this->CurrentGrid);
				this->Viewer->DisplayGrids();
				//debugStream << "Set to Current "<<i<<std::endl;
			}
		}
	}
	else
	{
		//debugStream << "Error" <<std::endl;
		//error?
	}

	this->Viewer->RenderWidget->Render();
	//debugStream.close();
}
/**************************************************************************************************************************/
void vtkKWMyWindow::ProcessCallbackCommandEvents(vtkObject *caller, unsigned long event, void *calldata)
{

	if ( /*(caller == this->RatioButton && event == vtkKWCheckButton::SelectedStateChangedEvent) 
		||*/  (caller == this->MetabMapChoice && event == vtkKWComboBox::EntryValueChangedEvent))
	{
		//this->Viewer->SetRatioState(this->RatioButton->GetSelectedState());
		char tmp[1024] = ""; 
		strcpy(tmp, this->MetabMapChoice->GetValue());
		this->Viewer->SetMetabolite(tmp);
	
		this->MetabRange->SetWholeRange( this->Viewer->GetMetabWholeRange() );
		this->MetabRange->SetRange( this->Viewer->GetMetabWholeRange() );
		vtkKWWindowBase *win = this->GetApplication()->GetNthWindow(0);
		if (win)
		{
			char buffer[256];
			double * range = new double[2];
			range[0] = 0;
			range[1] = 0;
			range = this->MetabRange->GetWholeRange();
			sprintf(buffer, "Whole Range: %f %f", range[0], range[1] );
			win->SetStatusText(buffer);
		}
		this->Viewer->DisplayGrids();
	}

	if (caller == this->MetabRange && event == vtkKWRange::RangeValueChangedEvent) 
	{
		this->Viewer->SetMetabRange( this->MetabRange->GetRange() );		
		
		vtkKWWindowBase *win = this->GetApplication()->GetNthWindow(0);
		if (win)
		{
			char buffer[256];
			double * range = new double[2];
			range[0] = 0;
			range[1] = 0;
			range = this->MetabRange->GetRange();
			sprintf(buffer, "Range: %f %f", range[0], range[1] );
			win->SetStatusText(buffer);
		}

		//this->Viewer->SetRatioState(this->RatioButton->GetSelectedState());
		char tmp[1024] = ""; 
		strcpy(tmp, this->MetabMapChoice->GetValue());
		this->Viewer->SetMetabolite(tmp);
		this->Viewer->DisplayGrids();
	}

}
/**************************************************************************************************************************/
TransformType::Pointer vtkKWMyWindow::Register(vtkKWImage * fixed,vtkKWImage * moving)
{

	//itk::TransformFileReader::Pointer reader = itk::TransformFileReader::New();
	//reader->SetFileName("E:\\Research\\HumanStudies\\Reliability\\Motion\\301\\firstsession.txt");
	//reader->Update();

	//typedef itk::TransformFileReader::TransformListType * TransformListType;
	//TransformListType transforms = reader->GetTransformList();
	//itk::TransformFileReader::TransformListType::const_iterator it;
	//it = transforms->begin();

	//typedef itk::AffineTransform<double,3> AffineTransformType;
	//AffineTransformType::Pointer affineTransform; 
	//if ( !strcmp((*it)->GetNameOfClass(),"AffineTransform"))
	//{
	//	affineTransform = static_cast<AffineTransformType*>((*it).GetPointer());
	//}

	//TransformType::Pointer inputTransform = TransformType::New();

	ImageType::Pointer fixedImage = ImageType::New();
	ImageType::Pointer  movingImage = ImageType::New();

	fixedImage = GetITK(fixed);
	movingImage = GetITK(moving);
	
	ImageType::SpacingType spacing;
	ImageType::SizeType size;

	spacing = fixedImage->GetSpacing();
	size = fixedImage->GetLargestPossibleRegion().GetSize();
	
	ResampleFilterType::Pointer resampleT2 = ResampleFilterType::New();
	
	resampleT2->SetInput(movingImage);
	resampleT2->SetOutputSpacing(spacing);
	resampleT2->SetSize(size);
	resampleT2->SetOutputDirection(movingImage->GetDirection() );
	resampleT2->SetOutputOrigin(movingImage->GetOrigin() );
	resampleT2->Update();
	
	movingImage= resampleT2->GetOutput();

	//typedef itk::AffineTransform<double,3> 		TransformType;
	TransformType::Pointer transform = TransformType::New();

	ImageProcessing * registration = new ImageProcessing();
	
	registration->RegisterImages(fixedImage,movingImage);
	
	transform = registration->GetRegistrationTransform();

	return transform;

	//itk::TransformFileWriter::Pointer transformWriter = itk::TransformFileWriter::New();
	//transformWriter->SetInput(transform);
	//transformWriter->SetFileName("braincsiTransform.tfm");
	//transformWriter->Update();

}
/**************************************************************************************************************************/
void vtkKWMyWindow::CreateMask()
{
	//Load T1 image
	//Load T2 image
	
	//this->T1Image = ITKLoadFile("E:\\Research\\HumanStudies\\Reliability\\Subjects\\302\\302-T1.nii");
	//this->T2Image = ITKLoadFile("E:\\Research\\HumanStudies\\Reliability\\Subjects\\302\\302-T2A-reg.nii");

	//LoadT1Image();
	//LoadT2Image();

	TransformType::Pointer transform = TransformType::New();
	transform = Register(this->T1Image,this->T2Image);
	
	ImageType::Pointer itkT1 = ImageType::New();
	ImageType::Pointer itkT2 = ImageType::New();

	itkT1 = GetITK(this->T1Image);
	itkT2 = GetITK(this->T2Image);

	ResampleFilterType::Pointer resample = ResampleFilterType::New();

	ImageType::SpacingType spacing;
	ImageType::DirectionType direction;
	ImageType::PointType origin;
	ImageType::SizeType size;

	spacing = itkT1->GetSpacing();
	direction = itkT1->GetDirection();
	origin = itkT1->GetOrigin();
	size = itkT1->GetLargestPossibleRegion().GetSize();

	resample->SetInput( itkT2 );
	resample->SetOutputSpacing(spacing);
	resample->SetOutputDirection( direction);
	resample->SetOutputOrigin(origin);
	resample->SetSize(size);
	//resample->SetTransform(transform->GetInverseTransform());
	resample->Update();

	ImageType::Pointer temp = ImageType::New();
	temp = resample->GetOutput();
	//Resample T2 image to T1 image size, spacing, etc
	
	this->T2Image->SetITKImageBase(temp);
		
	vtkKWImage * brainmask = vtkKWImage::New();
	
	brainmask = CreateBrainMask(this->T1Image,this->T2Image);

	vtkKWImageIO * KWwriter = vtkKWImageIO::New();
	KWwriter->SetFileName("E:\\Development\\output\\mask.nii");
	KWwriter->SetImageToBeWritten( brainmask );
	try
	{
		KWwriter->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
			
	/*vtkKWImageIO * KWwriter2 = vtkKWImageIO::New();
	KWwriter2->SetFileName("E:\\Research\\HumanStudies\\Reliability\\Results\\303\\C-303-T1.nii");
	KWwriter2->SetImageToBeWritten( this->T1Image );
	try
	{
		KWwriter2->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
		
	vtkKWImageIO * KWwriter3 = vtkKWImageIO::New();
	KWwriter3->SetFileName("E:\\Research\\HumanStudies\\Reliability\\Results\\303\\C-303-T2-reg.nii");
	KWwriter3->SetImageToBeWritten( this->T2Image );
	try
	{
		KWwriter3->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}*/

	//itk::TransformFileWriter::Pointer transformWriter = itk::TransformFileWriter::New();
	//transformWriter->SetInput(transform);
	//transformWriter->SetFileName("E:\\Research\\HumanStudies\\Reliability\\Results\\302\\transformA.tfm");
	//transformWriter->Update();

}
/**************************************************************************************************************************/
void vtkKWMyWindow::ClassifyScript()
{

	
	//Iterate through subjects
	for (int i = 303; i<=303; i++)
	{
		for (int o=0; o<3; o++)
		{
			
			char pname[100] = "E:\\BrainCSI\\"; 
			char pathname[100] = ""; 
			char rdaname[100] = ""; 
			//char PVname[100] = "";
			char classifiedname[100] = ""; 
			char t1name[100] = "";
			char t2name[100] = "";
			char outt1name[100] = "";
			char outt2name[100] = "";
			char outmaskname[100] = "";
			char num[100] = "";
			//char spec[100] = "";
			char j[100] = "";
						
			vtkKWImage * mask = vtkKWImage::New();			
			vtkKWImage * classified = vtkKWImage::New();
			vtkKWImage * t1 = vtkKWImage::New();
			vtkKWImage * t2 = vtkKWImage::New();
			TransformType::Pointer transform = TransformType::New();  
			TransformType::Pointer Itransform = TransformType::New(); 

			itoa(i,num,10);
			itoa(o,j,10);

			strcpy(pathname,pname);
			strcat(pathname,num);
			strcat(pathname,"\\");
		
			strcat(t1name,num);
			strcat(t1name,"-T1.nii");

			strcat(t2name,num);
			strcat(t2name,"-T2");
				
			//strcat(pathname,num);
			//strcat(pathname,"\\");

			switch( o)
			{
			case 0:
				strcat(t2name,"A.nii");
				break;
			case 1:
				strcat(t2name,"A.nii");
				break;
			case 2:
				strcat(t2name,"B.nii");
				break;
			}

			//Load Images
			t1 = LoadFile(pathname,t1name);
			t2 = LoadFile(pathname,t2name);
			//mask = LoadFile("E:\\BrainCSI\\301\\","301-maskA.nii");
			
			//Register Images
			if (o==1)
			{
				//T1 Image is the fixed image;
				transform = Register(t1,t2);
				t2 = Rotate(t1,t2,transform);
			}
			else
			{
				//T2 Image is the fixed image;
				transform = Register(t2,t1);
				t1 = Rotate(t2,t1,transform);
			}

			mask = CreateBrainMask(t1,t2);
	
			//Load Spectroscopy File
			//char spec[100] = "";
			strcpy(rdaname,pathname);
			strcat(rdaname,num);
			strcat(rdaname,"-");
			strcat(rdaname,j);
			strcat(rdaname,".rda");
			LoadRDA(rdaname);

			t1 = Extract(t1);
			t2 = Extract(t2);
			mask = Extract(mask);

			classified = TissueClassification(t1,t2,mask);

			switch(o)
			{
				case 0:
					strcat(pathname,"Results-T2");
					strcat(pathname,"A\\");
					break;
				case 1:
					strcat(pathname,"Results-T1\\");
					break;
				case 2:
					strcat(pathname,"Results-T2");
					strcat(pathname,"B\\");
					break;
			}
			
			strcpy(outt1name,pathname);
			strcat(outt1name,"t1-extract.nii");
						
			strcpy(outt2name,pathname);
			strcat(outt2name,"t2-extract.nii");
			
			strcpy(outmaskname,pathname);
			strcat(outmaskname,"mask-extract.nii");
						
			strcpy(classifiedname,pathname);
			strcat(classifiedname,"bayes.nii");
			
			vtkKWImageIO * KWwriter = vtkKWImageIO::New();
			KWwriter->SetFileName(outt1name);
			KWwriter->SetImageToBeWritten( t1 );
			try
			{
				KWwriter->WriteImage();
			}
			catch( itk::ExceptionObject & excp )
			{
				std::cerr << excp << std::endl;
			}

			vtkKWImageIO * KWwriter2 = vtkKWImageIO::New();
			KWwriter2->SetFileName(outt2name);
			KWwriter2->SetImageToBeWritten( t2 );
			try
			{
				KWwriter2->WriteImage();
			}
			catch( itk::ExceptionObject & excp )
			{
				std::cerr << excp << std::endl;
			}
	
			vtkKWImageIO * KWwriter3 = vtkKWImageIO::New();
			KWwriter3->SetFileName(outmaskname);
			KWwriter3->SetImageToBeWritten( mask );
			try
			{
				KWwriter3->WriteImage();
			}
			catch( itk::ExceptionObject & excp )
			{
				std::cerr << excp << std::endl;
			}
		
			vtkKWImageIO * KWwriter4 = vtkKWImageIO::New();
			KWwriter4->SetFileName(classifiedname);
			KWwriter4->SetImageToBeWritten( classified );
			try
			{
				KWwriter4->WriteImage();
			}
			catch( itk::ExceptionObject & excp )
			{
				std::cerr << excp << std::endl;
			}
	}
}



}
/**************************************************************************************************************************/
void vtkKWMyWindow::Classify()
{
	if (this->Spectroscopy.size() > 0)
	{
	vtkKWImage * t1 = vtkKWImage::New();
	vtkKWImage * t2 = vtkKWImage::New();
	vtkKWImage * mask = vtkKWImage::New();
	//vtkKWImage * classified = vtkKWImage::New();
	
	t1 = Extract(this->T1Image);
	t2 = Extract(this->T2Image);
	mask = Extract(this->CurrentMask);

	this->ClassifiedImage = TissueClassification(t1,t2,mask);

	vtkKWImageIO * KWwriter = vtkKWImageIO::New();
	KWwriter->SetFileName("E:\\Development\\output\\extract-t1.nii");
	KWwriter->SetImageToBeWritten( t1 );
	try
	{
		KWwriter->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}

	vtkKWImageIO * KWwriter2 = vtkKWImageIO::New();
	KWwriter2->SetFileName("E:\\Development\\output\\extract-t2.nii");
	KWwriter2->SetImageToBeWritten( t2 );
	try
	{
		KWwriter2->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
	
	vtkKWImageIO * KWwriter3 = vtkKWImageIO::New();
	KWwriter3->SetFileName("E:\\Development\\output\\extract-mask.nii");
	KWwriter3->SetImageToBeWritten( mask );
	try
	{
		KWwriter3->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
		
	vtkKWImageIO * KWwriter4 = vtkKWImageIO::New();
	KWwriter4->SetFileName("E:\\Development\\output\\classified.nii");
	KWwriter4->SetImageToBeWritten( this->ClassifiedImage );
	try
	{
		KWwriter4->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}
	/************************************************************************/
		AnatomicalImage image;
		image.SetImage(this->ClassifiedImage);

		string fileName = "Classified";

		image.SetDisplayName(fileName.c_str());
		this->AnatomicalImages.push_back(image);

		this->FileManager->AddNode("image_node",fileName.c_str(), fileName.c_str());
		//this->FileManager->SetNodeImageToPredefinedIcon(display,vtkKWIcon::IconSilkEye);
		this->FileManager->SetNodePadX(fileName.c_str(),18);

		vtkKWPushButton *visible_button = vtkKWPushButton::New();
		visible_button->SetParent(this->FileManager);
		visible_button->Create();
		visible_button->SetBorderWidth(0);
		visible_button->SetBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetActiveBackgroundColor(this->FileManager->GetBackgroundColor());
		visible_button->SetImageToPredefinedIcon( 20021);
		char command[100];
		strcpy(command, "ChangeImageVisibility ");
		strcat(command, fileName.c_str());
		visible_button->SetCommand( this, command);
		this->FileManager->SetNodeWindow(fileName.c_str(), visible_button);
		/************************************************************************/
		ChangeImageVisibility(fileName.c_str());
}
}
/**************************************************************************************************************************/
vtkKWImage * vtkKWMyWindow::Rotate(vtkKWImage * fixedimage, vtkKWImage * movingimage, TransformTypePointer transform)
{


//	TransformType::Pointer transform = TransformType::New();
	//transform = Register(t2,bayes);
	
	ImageType::Pointer itkmoving = ImageType::New();
	ImageType::Pointer itkfixed = ImageType::New();

	itkfixed = GetITK(fixedimage);
	itkmoving = GetITK(movingimage);

	ResampleFilterType::Pointer resample = ResampleFilterType::New();

	ImageType::SpacingType spacing;
	ImageType::DirectionType direction;
	ImageType::PointType origin;
	ImageType::SizeType size;

	spacing = itkfixed->GetSpacing();
	direction = itkfixed->GetDirection();
	origin = itkfixed->GetOrigin();
	size = itkfixed->GetLargestPossibleRegion().GetSize();

	resample->SetInput( itkmoving );
	resample->SetOutputSpacing(spacing);
	resample->SetOutputDirection( direction);
	resample->SetOutputOrigin(origin);
	resample->SetSize(size);
	resample->SetTransform(transform);   //transform->GetInverseTransform());
	resample->Update();

	ImageType::Pointer itkoutput = ImageType::New();
	itkoutput = resample->GetOutput();
	//Resample T2 image to T1 image size, spacing, etc
	vtkKWImage * output = vtkKWImage::New();
	output->SetITKImageBase(itkoutput);
		
	
	//vtkKWImageIO * KWwriter = vtkKWImageIO::New();
	//KWwriter->SetFileName("E:\\Research\\HumanStudies\\Reliability\\Results\\301\\301-bayes-A.nii");
	//KWwriter->SetImageToBeWritten( output );
	//try
	//{
	//	KWwriter->WriteImage();
	//}
	//catch( itk::ExceptionObject & excp )
	//{
	//	std::cerr << excp << std::endl;
	//}
	return output;

}
/**************************************************************************************************************************/
vtkKWImage * vtkKWMyWindow::ITKLoadFile(char* fileName, char* dirName)
{
	//combine fname and dname
	char fName[1024] = ""; 
	char dName[1024] = ""; 
	
	strcpy(dName, dirName);
	strcpy(fName, dName );
	strcat(fName, fileName);

	ReaderType::Pointer reader = ReaderType::New();
	reader->SetFileName(fName);
	reader->Update();

	vtkKWImage * newImage = vtkKWImage::New();

	newImage->SetITKImageBase(reader->GetOutput());

	return newImage;
}
/**************************************************************************************************************************/
vtkKWImage * vtkKWMyWindow::ITKLoadFile(char* filename)
{
	//combine fname and dname
	char fName[1024] = ""; 
	char dName[1024] = ""; 
	
	//strcpy(dName, dirName);
	//strcpy(fName, dName );
	//strcat(fName, fileName);

	ReaderType::Pointer reader = ReaderType::New();
	reader->SetFileName(filename);
	reader->Update();

	vtkKWImage * newImage = vtkKWImage::New();

	newImage->SetITKImageBase(reader->GetOutput());

	return newImage;
}
/**************************************************************************************************************************/
vtkKWImage * vtkKWMyWindow::ITKLoadSeriesFile(char* dirName )
{
	//combine fname and dname
	//char fName[1024] = ""; 
	//char dName[1024] = ""; 
	//
	//strcpy(dName, dirName);
	////strcpy(fName, dName );
	////strcat(fName, fileName);
	itk::GDCMImageIO::Pointer GDCMIO = itk::GDCMImageIO::New();
	itk::GDCMSeriesFileNames::Pointer GDCM = itk::GDCMSeriesFileNames::New();
	GDCM->SetInputDirectory(dirName);

	typedef itk::ImageSeriesReader<ImageType> SeriesReaderType;
	SeriesReaderType::Pointer seriesreader = SeriesReaderType::New();
	SeriesReaderType::FileNamesContainer filenames;
	filenames = GDCM->GetInputFileNames();
	seriesreader->SetImageIO(GDCMIO);
	seriesreader->SetFileNames(filenames);
	try   
	{
		seriesreader->Update();
    }
	catch (itk::ExceptionObject &excp)
    {
		std::cerr << "Exception thrown while reading the series" << std::endl;
		std::cerr << excp << std::endl;
	}

	vtkKWImage * newImage = vtkKWImage::New();

	//newImage->SetITKImageBase(reader->GetOutput());

	return newImage;
}
/**************************************************************************************************************************/
void vtkKWMyWindow::RotateGrid()
{
		
	TransformType::Pointer transform = TransformType::New();
	transform = Register(this->T2Image,this->T1Image);
	vtkKWImage * t1Registered = vtkKWImage::New();
	t1Registered = Rotate(this->T2Image,this->T1Image,transform);

	vtkKWImage * brainmask = vtkKWImage::New();
	brainmask = CreateBrainMask(t1Registered,this->T2Image);

	vtkKWImage * t1 = vtkKWImage::New();
	vtkKWImage * t2 = vtkKWImage::New();
	vtkKWImage * mask = vtkKWImage::New();
	//vtkKWImage * classified = vtkKWImage::New();
	
	t1 = Extract(t1Registered);
	t2 = Extract(this->T2Image);
	mask = Extract(brainmask);

	this->ClassifiedImage = TissueClassification(t1,t2,mask);

	vtkKWImageIO * KWwriter4 = vtkKWImageIO::New();
	KWwriter4->SetFileName("E:\\Development\\output\\classified.nii");
	KWwriter4->SetImageToBeWritten( this->ClassifiedImage );
	try
	{
		KWwriter4->WriteImage();
	}
	catch( itk::ExceptionObject & excp )
	{
		std::cerr << excp << std::endl;
	}

}
/**************************************************************************************************************************/
void vtkKWMyWindow::LoadTransform()
{
	vtkKWApplication *app = this->GetApplication();

	/***********************************************************************/
	//Call FileBrowser Dialog Box:: Could put in its own function
	vtkKWFileBrowserDialog *dlg = vtkKWFileBrowserDialog::New();
	dlg->SetApplication(app);
	dlg->Create();
	dlg->SetFileTypes("{{All files} {.*}} {{Transform} {.tfm}}");

	// Invoke the dialog
	dlg->RetrieveLastPathFromRegistry("LastPath");
	//dlg->ChooseDirectoryOn();
	dlg->Invoke();
	
	if (dlg->GetStatus()==vtkKWDialog::StatusOK)
	{
		//string test = dlg->GetFileName();
		dlg->SaveLastPathToRegistry("LastPath");
		string filename =	dlg->GetFileName();
	
		TransformReaderType::Pointer reader = TransformReaderType::New();
		reader->SetFileName(filename);
		
		try
		{
			reader->Update();
		}
		catch( itk::ExceptionObject & excp )
		{
			std::cerr << excp << std::endl;
		}

		TransformListType * read = reader->GetTransformList();
		BaseTransformType::Pointer transform = read->front(); //transform = BaseTransformType::New();
		
		TransformListType::iterator it=read->begin();
		//AffineTransformType::Pointer  affineTransform = AffineTransformType::New();
		
		
		//Make this a Rigid Transform
		this->Transform = AffineTransformType::New();

		for(TransformListType::iterator it=read->begin(); it !=read->end() ; it++)
		{
			this->Transform->SetParameters((*it)->GetParameters());
			this->Transform->SetFixedParameters((*it)->GetFixedParameters());
		}

	}

	

}
/**************************************************************************************************************************
void vtkKWMyWindow::LoadImageScript()
{
	char pname[100] = "E:/Research/HumanStudies/Reliability/Results/"; 
	char pathname[100] = ""; 
	char t1name[100] = "";
	char t2name[100] = "";
	char outt1name[100] = "";
	char outt2name[100] = "";
	char outmaskname[100] = "";
	char num[100] = "";
	char spec[100] = "";
	char orient[100] = "";

	//Iterate through subjects
	for (int i = 301; i<=303; i++)
	{
		itoa(i,num,10);
		strcpy(pathname,pname);
		strcat(pathname,num);
		strcat(pathname,"/");
		
		//Iterate through orientations
		//for (int o = 0; o <=3; o++)
		//{ 
		int o=1;
		itoa(o,orient,10);
		//Iterate through acquisitions
		//for (int s = 0; s <=3; s++)
		int s=0;
		itoa(s,spec,10);

		strcpy(rdaname,pathname);
		strcat(rdaname,num);
		strcat(rdaname,"-");
		strcat(rdaname,spec);
		strcat(rdaname,".rda");

		strcpy(PVname,pathname);
		strcat(PVname,num);
		strcat(PVname,"-");
		strcat(PVname,orient);
		strcat(PVname,"-");
		strcat(PVname,spec);
		strcat(PVname,"-PV.txt");

		strcpy(classifiedname,pathname);
		strcat(classifiedname,num);
		strcat(classifiedname,"-");
		strcat(classifiedname,orient);
		strcat(classifiedname,"-bayes.nii");

		strcpy(t1name,pathname);
		strcat(t1name,num);
		strcat(t1name,"-t1.nii");
		//strcat(t1name,spec);
		//strcat(t1name,".nii");

		strcpy(t2name,pathname);
		strcat(t2name,num);
		strcat(t2name,"-t2-");
		strcat(t2name,orient);
		strcat(t2name,".nii");
			

}
/**************************************************************************/
#endif
