#ifndef __AnatomicalImage_h
#define __AnatomicalImage_h

#include "vtkKWImage.h"
#include "itkImage.h"

typedef signed short														PixelType;
typedef itk::Image<PixelType, 3>											ITKImageType;

class AnatomicalImage
{
public:

	AnatomicalImage();
	~AnatomicalImage();

	void SetDisplayName(const char *);
	void Update();
	ITKImageType::Pointer GetITKImage();
	vtkKWImage * GetImage();
	char * GetName();
	char * GetInputDirectory();
	void SetInputDirectory(char *);
	char * GetOutputLocation();
	void SetOutputFileName(char *, char *);
	void SetOutputPath(char *);

	void LoadImageFile(char *);
	void SetImage(vtkKWImage *);
	//void SetImage(vtkImageData *);
	void SetImage(ITKImageType::Pointer);
	void SetITKImage(vtkKWImage *);

	
private:
	
	char *			Name;  //Display name
	char *			InputDirectory;
	char *			OutputDirectory;
	char *			OutputFileName;
	char *			InputFileName;

	ITKImageType::Pointer		ITKImage;
	vtkKWImage *				Image;
	
};

#endif
