/*=========================================================================

 Program:   BRAINS (Brain Research: Analysis of Images, Networks, and Systems)
 Module:    $RCSfile: $
 Language:  TCL
 Date:      $Date: 2006/03/29 14:53:40 $
 Version:   $Revision: 1.9 $
 
   Copyright (c) Iowa Mental Health Clinical Research Center. All rights reserved.
   See BRAINSCopyright.txt or http://www.psychiatry.uiowa.edu/HTML/Copyright.html 
   for details.
 
      This software is distributed WITHOUT ANY WARRANTY; without even 
      the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
      PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#ifndef __BayesianClassifierBrainCSI_h__
#define __BayesianClassifierBrainCSI_h__

#include "itkPointSet.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkListSample.h"
#include "itkSubsample.h"
#include "vtkKWImage.h"

typedef signed short															PixelType;
typedef float																	FloatPixelType;
typedef itk::PointSet< PixelType >												PointSetType;
typedef itk::Image<PixelType, 3>										ImageType;
typedef itk::VectorImage<PixelType, 3>											VectorImageType;
typedef itk::VectorImage<FloatPixelType, 3>										FloatVectorImageType;
typedef itk::VariableLengthVector<PixelType>									MeasurementVectorType;
typedef itk::Statistics::ListSample< MeasurementVectorType >					SampleType;
typedef itk::Statistics::Subsample< SampleType >								ClassSampleType;


vtkKWImage * BayesianClassifierBrainCSI( vtkKWImage *, vtkKWImage *, vtkKWImage *, vtkKWImage *, vtkKWImage *);

void GetClassSample ( PointSetType::Pointer points, ImageType::Pointer image, int classType );
	
PointSetType::Pointer LoadTrainingPoints ( char * textFile );
	
void GetClassTraining (PointSetType::Pointer points, VectorImageType::Pointer initialimages, 
								SampleType::Pointer training, std::vector< ClassSampleType::Pointer > classSamples, 
								int classType, int numberofimages);
	
  void LoadPoints2Classify(ImageType::Pointer, ImageType::Pointer, SampleType::Pointer sample);
  
  PointSetType::Pointer CreateTrainingPoints(ImageType::Pointer, PixelType labelValue );
  
  ImageType::Pointer BRAINSRandomPlugsCSI(ImageType::Pointer);

  ImageType::Pointer GetITK(vtkKWImage *);

#endif /* __BayesianClassifier_h__ */
