#ifndef PICKCELLCALLBACK_H
#define PICKCELLCALLBACK_H

#include "vtkCallbackCommand.h"
#include "vtkCellPicker.h"
#include "vtkIdList.h"
#include "vtkCell.h"
#include "vtkPolyDataMapper.h"
#include "vtkProperty.h"
#include "vtkPoints.h"
#include "vtkHexahedron.h"
#include "vtkMatrix4x4.h"
#include "vtkTransform.h"
#include "vtkTransformPolyDataFilter.h"
#include "vtkUnstructuredGridToPolyDataFilter.h"
#include "vtkGeometryFilter.h"
#include "vtkStructuredGrid.h"
#include "vtkRenderer.h"
#include "vtkActor.h"

#include "CSIgrid.h"
#include "vtkKWListBoxWithScrollbars.h"
#include "vtkKWListBox.h"


//#define TotalNumofCell 10

class PickCellCallBack: public vtkCallbackCommand{

	private:

		int cellid;
		CSIgrid			*Spectroscopy;


		vtkStructuredGrid *Grid;
		//vtkRenderer *m_Renderer;
		vtkMatrix4x4 *TransformMatrix;
		
		//vtkActor ** m_CellActors;
		int GetCellID(int, int *);

		std::vector<vtkStructuredGrid *>    Cells;
		std::vector<int>    CellIDs;
		vtkKWListBoxWithScrollbars * Widget;

	public:
		PickCellCallBack(void);
		~PickCellCallBack(void);

		static PickCellCallBack * New()
			{return new PickCellCallBack;};

		void SetGrid(vtkStructuredGrid *);

		void SetCSI( CSIgrid *);

		void SetWidget( vtkKWListBoxWithScrollbars * );

		void SetTransform(vtkMatrix4x4 *);

		void Execute(vtkObject *,unsigned long, void* );

		vtkStructuredGrid * GenerateCell(int, int *);
		void RemoveCell(int );
		std::vector<vtkStructuredGrid *> GetCellCollection();
		std::vector<int> GetCellIDs();
};

#endif