#ifndef PSF_h
#define PSF_h

#include "itkCastImageFilter.h"

#include "itkImage.h"
#include "itkVnlFFTComplexConjugateToRealImageFilter.h"
#include "itkRealAndImaginaryToComplexImageFilter.h"
#include "itkFFTShiftImageFilter.h"
#include "itkMultiplyImageFilter.h"
#include "itkComplexToRealImageFilter.h"
#include "itkComplexToImaginaryImageFilter.h"
#include "itkVnlFFTRealToComplexConjugateImageFilter.h"
#include "itkExtractImageFilter.h"
#include "vtkKWImage.h"

	typedef signed short															PixelType;
	typedef itk::Image< PixelType, 3 >												ImageType;
	typedef double																	DoublePixelType;
	typedef itk::Image< DoublePixelType, 3 >										PSFImageType;
	typedef itk::Image< DoublePixelType, 2 >										ImageSliceType;
	typedef itk::RealAndImaginaryToComplexImageFilter<DoublePixelType,
						DoublePixelType,DoublePixelType,2>							RI2CImageFilter;
	typedef RI2CImageFilter::OutputImageType										PSFComplexImageType;
	typedef PSFComplexImageType::PixelType											PSFComplexPixelType;

	typedef itk::ComplexToRealImageFilter<PSFComplexImageType, ImageSliceType>		c2rFilterType;
	typedef itk::ComplexToImaginaryImageFilter<PSFComplexImageType, ImageSliceType> c2iFilterType;

class PointSpreadFunction
{
public:
	PointSpreadFunction();
	void SetImage( vtkKWImage * );
	void SetKernelChoice(int);
	void SetPhaseEncodeSteps(int);

	vtkKWImage * GetOutput();
	ImageSliceType::Pointer Convolve(ImageSliceType::Pointer);
	void Update();
	void WriteImage();

private:

	PSFComplexImageType::Pointer		CreateKernel(int, PSFComplexImageType::SizeType);

	ImageType::Pointer					GetITK(vtkKWImage *);

	PSFImageType::Pointer				PadImage(PSFImageType::Pointer);
	PSFImageType::Pointer				CropImage(PSFImageType::Pointer);

	int									KernelChoice;
	int									numCells;

	PSFImageType::Pointer				inputImage;
	PSFImageType::Pointer				outputImage;
	PSFImageType::IndexType				buffer;

};

#endif