#ifndef __vtkKWMyWindow_h
#define __vtkKWMyWindow_h

#include "vtkKWWindow.h"

#define PI 3.14159265

#include "vtkKWRenderWidget.h"

#include "vtkKWScale.h"
#include "vtkStructuredGrid.h"
#include "itkMatrix.h"
#include "vtkTransform.h"
#include "vtkTransformFilter.h"

#include <vtkKWMenuButtonWithSpinButtonsWithLabel.h>
#include "CSIDisplay.h"

#include "vtkStringArray.h"
#include "vtkDataArray.h"
#include "itkImage.h"

#include "vtkKWImage.h"
#include "vtkKWImageIO.h"

#include "time.h"
#include "vtkKWTree.h"

#include "itkComplexToRealImageFilter.h"
#include "itkComplexToImaginaryImageFilter.h"
#include "itkMultiplyImageFilter.h"
#include "itkCastImageFilter.h"
//#include "itkFFTComplexConjugateToRealImageFilter.h"
#include "itkRealAndImaginaryToComplexImageFilter.h"

#include "PointSpreadFunction.h"
#include "vtkKWMenuButtonWithLabel.h"
#include "vtkKWMenuButtonWithSpinButtons.h"

#include "vtkStructuredGridReader.h"
#include "vtkStructuredGridWriter.h"
#include "vtkPolyDataReader.h"
#include "vtkKWCheckButton.h"
#include "vtkKWComboBox.h"
#include "vtkKWPushButton.h"

#include "vtkKWRange.h"

#include "vtkKWListBoxWithScrollbars.h"
#include "vtkKWListBox.h"
#include "PickCellCallBack.h"

#include "CSIgrid.h"
#include "AnatomicalImage.h"
#include <vector>
#include "LoadSEMCImages.h"

#include "itkTransformFileWriter.h"
#include "itkTransformFileReader.h"
#include "itkAffineTransform.h"
#include "itkVersorRigid3DTransform.h"
//#include "itkCastImageFilter.h"
#include "itkImageFileReader.h"

#include <vtksys/stl/string>

typedef signed short															PixelType;
typedef double																	DoublePixelType;
typedef itk::Image<PixelType, 3>												ImageType;
typedef ImageType::Pointer														ImageTypePointer;
typedef ImageType::SpacingType													ImageSpacingType;
typedef ImageType::SizeType														ImageSizeType;

typedef itk::Image<DoublePixelType, 3>											DoubleImageType;
typedef DoubleImageType::Pointer												DoubleImageTypePointer;

typedef itk::Matrix<double>														MatrixType;

typedef std::complex<double>													ComplexPixelType;
typedef itk::Image< ComplexPixelType,3>											ComplexImageType;
typedef ComplexImageType::Pointer												ComplexImageTypePointer;

typedef std::vector<CSIgrid *>													CSIVectorType;
typedef std::vector<AnatomicalImage>											AnatomicalImageVectorType;
typedef std::vector<int>														IntVectorType;

typedef itk::VersorRigid3DTransform<double>										TransformType;
typedef itk::AffineTransform<double,3>											AffineTransformType;
typedef AffineTransformType::Pointer											AffineTransformTypePointer;
typedef TransformType::Pointer													TransformTypePointer;
typedef itk::ImageFileReader<ImageType>											ReaderType;
typedef itk::TransformFileReader												TransformReaderType;
typedef  TransformReaderType::TransformListType									TransformListType;
typedef  TransformReaderType::TransformType										BaseTransformType;
/************************************************************************************************************/

class vtkKWMyWindow : public vtkKWWindow
{
public:
	//Carried over from example in KWWidgets
	static vtkKWMyWindow* New();
	vtkTypeRevisionMacro(vtkKWMyWindow, vtkKWWindow);

	//My functions
	/*******************************************************************************
	Load Functions:
	
		/*******************************************************************************	
		Anatomical Images:  These two functions are in the File Menu.  They load anatomical 
		images using a dialog box by either selecting a file or directory.  The output of 
		the reader is put into AnatomicalImage and CurrentImage.  
		********************************************************************************/
		void LoadFile();
		void LoadSeriesFile();
		void LoadT2Map();
		void LoadT1Map();
		void LoadT2Image();
		void LoadT1Image();
		void LoadMask();
		void LoadClassifiedImage();
		vtkKWImage * LoadFile(char*, char*);
		vtkKWImage * LoadSeriesFile(char*, char *);
		vtkKWImage * ITKLoadFile(char*, char*);
		vtkKWImage * ITKLoadFile(char*);
		vtkKWImage * ITKLoadSeriesFile(char*);
		void LoadTransform();
			
		/*******************************************************************************
		Loads the Spectroscopy Grid from a RDA file reader.   Builds an unstructured 
		grid and sets it as CurrentGrid and SGrid. Also sets the direction cosine 
		matrix: GridDirCos
		********************************************************************************/
		void LoadRDA();
		CSIgrid * LoadRDA(char *);
		void LoadCSI();

		/*******************************************************************************
		Loads the Segmented Image or Label Mask.  Sets the output of the reader to
		CurrentMask, LabelMask, and CalculateMask
		********************************************************************************/
		//void LoadLabelMask();	
	
	/********************************************************************************/

	/*******************************************************************************
	LCModel functions:  
	********************************************************************************/
		void LoadLCModel();
		const char * GetMetabolite();
	/*******************************************************************************/
	
	/*******************************************************************************
	Processing Functions:
	********************************************************************************/
	
		void TranslateGrid();
		//virtual void SetCSFromScaleCallback(double value);	
		void Extract();
		vtkKWImage * Extract(vtkKWImage *);
		
		//void CorrectPSF();
		vtkKWImage * TissueClassification(vtkKWImage *,vtkKWImage *, vtkKWImage *);
		void Test();
		void TestFFT();
		TransformTypePointer Register(vtkKWImage *, vtkKWImage *);
		void CreateBrainMask();
		vtkKWImage *  CreateBrainMask(vtkKWImage *, vtkKWImage *);
		void DoNothing();
		void CreateMask();
		void Classify();
		void ClassifyScript();
		vtkKWImage * Rotate(vtkKWImage *, vtkKWImage *, TransformTypePointer);
		
		
		void RotateGrid();

		//void SetMetabRange();

		void SetChemicalShift(const char*);
		void SetMetabMapChoice(const char*);
		void SetComponentChoice(const char*);

	/*******************************************************************************
	Calculation Functions:
	********************************************************************************/
		vtkDataArray * Calculate(vtkKWImage *, CSIgrid *);
		void CalculateTest();
		void Calculate();
	/*******************************************************************************/
		ImageTypePointer GetITK(vtkKWImage *);

		void ReadStructuredGrid();
	//	void SetRatioState();
		void SetPicking(int);
		void RedrawGrids(int);
		void SetViewMetab(const char*);
		void SetMetabViewRange(double,double);
		void SetMetabViewWholeRange(double,double);
		void FileSelectionChangedCallback();
		void DoubleClickFileCallback();
		void ChangeImageVisibility(const char *);
		void ChangeGridVisibility(char *, bool);

		void SetViewCRLBRange(double,double);
		void DisplayPickedCells();
		

protected:
	vtkKWMyWindow();
	~vtkKWMyWindow();

	// Description:
	// Create the widget.
	virtual void CreateWidget();
	
	//vtkKWRenderWidget								*RenderWidget;
	CSIDisplay										*Viewer;

	//For Display Purposes
	vtkKWImage *									CurrentImage;
	vtkKWImage *									CurrentMask;
	vtkStructuredGrid								*CurrentGrid;	
	vtkKWImage										*KWImage;

	//Images to process
	vtkKWImage *									KMeansImage;
	vtkKWImage *									SamplePlugImage;
	//vtkKWImage *									AnatomicalImage;
	vtkKWImage *									T2Image;	
	vtkKWImage *									T1Image;
	vtkKWImage *									T2ImageExtract;	
	vtkKWImage *									T1ImageExtract;
	vtkKWImage *									MaskExtract;
	vtkKWImage *									CalculateMask;
	vtkKWImage *									CSFImage;
	vtkKWImage *									GreyImage;
	vtkKWImage *									WhiteImage;
	vtkKWImage *									BGImage;
	vtkKWImage *									ExtractImage;
	vtkKWImage *									ClassifiedImage;
	vtkKWImage *									DoubleImage;
	vtkKWImage *									PSFImage;
	vtkKWImage *									T2Map;	
	vtkKWImage *									T1Map;	
	//Image parameters
	ImageSpacingType								ImageSpacing;
	ImageSizeType									ImageSize;

	vtkImagePlaneWidget								*m_PlaneX;			
	vtkImagePlaneWidget								*m_PlaneY;
	vtkImagePlaneWidget								*m_PlaneZ;

	//Grid
	vtkStructuredGrid								*SGrid;		
	MatrixType										GridDirCos;

	vtkActor										*m_SGridActor;
	vtkActor										*surfaceActor;
	vtkActor										*surfaceActor2;

	vtkTransform									*ChemicalShift;
	AffineTransformTypePointer						Transform;

	vtkTransformFilter								*csFilter;
	vtkStructuredGrid								*tempGrid;
	vtkStructuredGrid								*PVGrid;

	//vtkKWScale									*CSScale;

	vtkKWTree										*FileManager;
	//vtkKWMenuButtonWithSpinButtons				*MetaboliteList;
	vtkKWComboBox									*MetaboliteList;
	vtkKWComboBox									*MetabMapChoice;
	vtkKWComboBox									*ComponentChoice;
	//vtkKWCheckButton								*RatioButton;
	vtkKWCheckButton								*PickButton;
	vtkKWCheckButton								*DrawButton;

	vtkKWListBoxWithScrollbars						*PickListBox;
	
	vtkKWRange										*MetabRange;
	vtkKWRange										*CRLBRange;
	virtual void ProcessCallbackCommandEvents(vtkObject *caller, unsigned long event, void *calldata);

private:

	CSIVectorType										Spectroscopy;
	AnatomicalImageVectorType							AnatomicalImages;

	CSIgrid												*CurrentCSI;
	PickCellCallBack *									Pickcallback;

	//Do these all need to be here?
	char*												testDir;
	char*												T1file;
	char*												T1folder;
	char*												T2file;
	char*												T2folder;
	char*												RDAfile;

	vtkStringArray										*Names;
													
	double												B0Field;
	double												ScannerFreq;
	double				 								Bandwidth;
	double												GridThickness;
	double												deltaR;
	double												CurrentMetabolite;

	double												RefChemShift;
	
	double												DwellTime;
	double												MetaboliteChemShift;

	double												*GridOrigin;
	double												*SGridSpacing;
	double												GridFOV[3];
	double												GridCenter[3];

		
	vtkKWMyWindow(const vtkKWMyWindow&);   // Not implemented.
	void operator=(const vtkKWMyWindow&);  // Not implemented.
};

#endif
